/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.ZipUtil2;
import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.zip.ZipFile;

@OptionClass(alias="dynamic-system-update")
public class DynamicSystemPreparer
extends BaseTargetPreparer {
    static final int DSU_MAX_WAIT_SEC = 600;
    private static final String DEST_PATH = "/sdcard/system.raw.gz";
    @Option(name="system-image-zip-name", description="The name of the zip file containing system.img.")
    private String mSystemImageZipName = "system-img.zip";

    private boolean isDSURunning(ITestDevice device) throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        device.executeShellCommand("gsi_tool status", (IShellOutputReceiver)receiver);
        return receiver.getOutput().contains("running");
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        File systemImageGZ;
        File systemImage;
        ZipFile zipFile;
        block8: {
            File systemImageZipFile = buildInfo.getFile(this.mSystemImageZipName);
            if (systemImageZipFile == null) {
                throw new BuildError("Cannot find " + this.mSystemImageZipName + " in build info.", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
            }
            zipFile = null;
            systemImage = null;
            systemImageGZ = null;
            zipFile = new ZipFile(systemImageZipFile);
            systemImage = ZipUtil2.extractFileFromZip((ZipFile)zipFile, (String)"system.img");
            systemImageGZ = FileUtil.createTempFile((String)"system", (String)".raw.gz");
            long rawSize = systemImage.length();
            ZipUtil.gzipFile((File)systemImage, (File)systemImageGZ);
            LogUtil.CLog.i((String)"Pushing %s to %s", (Object[])new Object[]{systemImageGZ.getAbsolutePath(), DEST_PATH});
            if (!device.pushFile(systemImageGZ, DEST_PATH)) {
                throw new TargetSetupError(String.format("Failed to push %s to %s", systemImageGZ.getName(), DEST_PATH), device.getDeviceDescriptor());
            }
            device.setProperty("persist.sys.fflag.override.settings_dynamic_system", "true");
            String command = "am start-activity -n com.android.dynsystem/com.android.dynsystem.VerificationActivity -a android.os.image.action.START_INSTALL -d file:///sdcard/system.raw.gz --el KEY_SYSTEM_SIZE " + rawSize + " --el KEY_USERDATA_SIZE 8589934592 --ez KEY_ENABLE_WHEN_COMPLETED true";
            device.executeShellCommand(command);
            device.waitForDeviceNotAvailable(600000L);
            device.waitForDeviceOnline();
            if (!this.isDSURunning(device)) {
                throw new TargetSetupError("Timeout to boot into DSU", device.getDeviceDescriptor());
            }
            CommandResult result = device.executeShellV2Command("gsi_tool enable");
            if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) break block8;
            FileUtil.deleteFile((File)systemImage);
            FileUtil.deleteFile((File)systemImageGZ);
            ZipUtil2.closeZip((ZipFile)zipFile);
            return;
        }
        try {
            try {
                throw new TargetSetupError("fail on gsi_tool enable", device.getDeviceDescriptor());
            }
            catch (IOException e) {
                LogUtil.CLog.e((Throwable)e);
                throw new TargetSetupError("fail to install the DynamicSystemUpdate", (Throwable)e, device.getDeviceDescriptor());
            }
        }
        catch (Throwable throwable) {
            FileUtil.deleteFile(systemImage);
            FileUtil.deleteFile(systemImageGZ);
            ZipUtil2.closeZip((ZipFile)zipFile);
            throw throwable;
        }
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        if (e instanceof DeviceNotAvailableException) {
            LogUtil.CLog.e((String)"skip tearDown on DeviceNotAvailableException");
            return;
        }
        device.executeShellCommand("gsi_tool disable");
        device.executeShellCommand("gsi_tool enable -s");
        device.executeShellCommand("gsi_tool disable");
        device.reboot();
    }
}

