/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.TestInformation;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;

@OptionClass(alias="device-wiper")
public class DeviceWiper
extends BaseTargetPreparer {
    @Option(name="use-erase", description="instruct wiper to use fastboot erase instead of format")
    protected boolean mUseErase = false;

    public void setUp(TestInformation testInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
        ITestDevice device = testInfo.getDevice();
        LogUtil.CLog.i((String)"Wiping device");
        device.rebootIntoBootloader();
        if (this.mUseErase) {
            this.doErase(device);
        } else {
            this.doFormat(device);
        }
        device.executeFastbootCommand(new String[]{"reboot"});
        device.waitForDeviceAvailable();
    }

    private void doFormat(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.d((String)"Attempting fastboot wiping");
        CommandResult r = device.executeLongFastbootCommand(new String[]{"-w"});
        if (r.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("fastboot wiping failed: %s", r.getStderr()), device.getDeviceDescriptor());
        }
    }

    private void doErase(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        this.performFastbootOp(device, "erase", "cache");
        this.performFastbootOp(device, "erase", "userdata");
    }

    private void performFastbootOp(ITestDevice device, String op, String partition) throws DeviceNotAvailableException, TargetSetupError {
        LogUtil.CLog.d((String)"Attempting fastboot %s %s", (Object[])new Object[]{op, partition});
        CommandResult r = device.executeLongFastbootCommand(new String[]{op, partition});
        if (r.getStatus() != CommandStatus.SUCCESS) {
            throw new TargetSetupError(String.format("%s %s failed: %s", op, partition, r.getStderr()), device.getDeviceDescriptor());
        }
    }
}

