/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetprep;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IDeviceBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.error.DeviceErrorIdentifier;
import com.android.tradefed.result.error.ErrorIdentifier;
import com.android.tradefed.result.error.InfraErrorIdentifier;
import com.android.tradefed.targetprep.BaseTargetPreparer;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IAbiReceiver;
import com.android.tradefed.util.AaptParser;
import com.android.tradefed.util.AbiFormatter;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@OptionClass(alias="all-tests-installer")
public class AllTestAppsInstallSetup
extends BaseTargetPreparer
implements IAbiReceiver {
    @Option(name="force-abi", description="The abi to use, can be either 32 or 64.", importance=Option.Importance.IF_UNSET)
    private String mForceAbi = null;
    @Option(name="install-arg", description="Additional arguments to be passed to install command, including leading dash, e.g. \"-d\"")
    private Collection<String> mInstallArgs = new ArrayList<String>();
    @Option(name="force-queryable", description="Whether apks should be installed as force queryable.")
    private boolean mForceQueryable = true;
    @Option(name="cleanup-apks", description="Whether apks installed should be uninstalled after test. Note that the preparer does not verify if the apks are successfully removed.")
    private boolean mCleanup = false;
    @Option(name="stop-install-on-failure", description="Whether to stop the preparer by throwing an exception or only log the error on continue.")
    private boolean mStopInstallOnFailure = true;
    private IAbi mAbi = null;
    private List<String> mPackagesInstalled = new ArrayList<String>();

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException {
        if (!(buildInfo instanceof IDeviceBuildInfo)) {
            throw new TargetSetupError("Invalid buildInfo, expecting an IDeviceBuildInfo", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.UNDETERMINED);
        }
        File testsDir = ((IDeviceBuildInfo)buildInfo).getTestsDir();
        if (testsDir == null || !testsDir.exists()) {
            throw new TargetSetupError("Failed to find a valid test zip directory.", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        if (this.mForceQueryable && device.isAppEnumerationSupported()) {
            this.mInstallArgs.add("--force-queryable");
        }
        this.resolveAbi(device);
        this.installApksRecursively(testsDir, device);
    }

    void installApksRecursively(File directory, ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        File[] files;
        if (directory == null || !directory.isDirectory()) {
            throw new TargetSetupError("Invalid test zip directory!", device.getDeviceDescriptor(), (ErrorIdentifier)InfraErrorIdentifier.ARTIFACT_NOT_FOUND);
        }
        LogUtil.CLog.d((String)"Installing all apks found in dir %s ...", (Object[])new Object[]{directory.getAbsolutePath()});
        for (File f : files = directory.listFiles()) {
            if (f.isDirectory()) {
                this.installApksRecursively(f, device);
            }
            if (FileUtil.getExtension((String)f.getAbsolutePath()).toLowerCase().equals(".apk")) {
                this.installApk(f, device);
                continue;
            }
            LogUtil.CLog.d((String)"Skipping %s because it is not an apk", (Object[])new Object[]{f.getAbsolutePath()});
        }
    }

    void installApk(File appFile, ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        LogUtil.CLog.d((String)"Installing apk from %s ...", (Object[])new Object[]{appFile.getAbsolutePath()});
        String result = device.installPackage(appFile, true, this.mInstallArgs.toArray(new String[0]));
        if (result == null) {
            if (this.mCleanup) {
                AaptParser parser = AaptParser.parse((File)appFile);
                if (parser == null) {
                    throw new TargetSetupError("apk installed but AaptParser failed", device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.AAPT_PARSER_FAILED);
                }
                this.mPackagesInstalled.add(parser.getPackageName());
            }
        } else {
            if (this.mStopInstallOnFailure) {
                throw new TargetSetupError(String.format("Failed to install %s on %s. Reason: '%s'", appFile, device.getSerialNumber(), result), device.getDeviceDescriptor(), (ErrorIdentifier)DeviceErrorIdentifier.APK_INSTALLATION_FAILED);
            }
            LogUtil.CLog.e((String)"Failed to install %s on %s. Reason: '%s'", (Object[])new Object[]{appFile, device.getSerialNumber(), result});
        }
    }

    void resolveAbi(ITestDevice device) throws DeviceNotAvailableException {
        if (this.mAbi != null && this.mForceAbi != null) {
            throw new IllegalStateException("cannot specify both abi flags");
        }
        String abiName = null;
        if (this.mAbi != null) {
            abiName = this.mAbi.getName();
        } else if (this.mForceAbi != null) {
            abiName = AbiFormatter.getDefaultAbi((ITestDevice)device, (String)this.mForceAbi);
        }
        if (abiName != null) {
            this.mInstallArgs.add(String.format("--abi %s", abiName));
        }
    }

    public void setAbi(IAbi abi) {
        this.mAbi = abi;
    }

    public IAbi getAbi() {
        return this.mAbi;
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        if (this.mCleanup && !(e instanceof DeviceNotAvailableException)) {
            for (String packageName : this.mPackagesInstalled) {
                String msg = device.uninstallPackage(packageName);
                if (msg == null) continue;
                LogUtil.CLog.w((String)String.format("error uninstalling package '%s': %s", packageName, msg));
            }
        }
    }
}

