/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.AtraceCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.LogDataType;
import java.util.concurrent.TimeUnit;

@OptionClass(alias="trace-cmd")
public class TraceCmdCollector
extends AtraceCollector {
    @Option(name="trace-cmd-binary", description="The path on the device of the trace-cmd binary to use")
    private String mTraceCmdBinary = null;
    @Option(name="trace-cmd-recording-args", description="The flags to pass to 'trace-cmd record'")
    private String mTraceCmdRecordArgs = "-e sched:sched_waking -e sched:sched_wakeup -e sched:sched_wakeup_new -e sched:sched_switch -e power:cpu_idle -e power:cpu_frequency -e power:cpu_frequency_limits -e power:suspend_resume -e power:clock_set_rate -e power:clock_enable -e power:clock_disable -b 12000 -C boot -s 10000000 ";

    @Override
    protected LogDataType getLogType() {
        return LogDataType.KERNEL_TRACE;
    }

    @Override
    protected void startTracing(ITestDevice device) {
        if (this.mTraceCmdBinary == null) {
            LogUtil.CLog.w((String)"--trace-cmd-binary was not set, skipping trace metric collection");
            return;
        }
        super.startTracing(device);
        StringBuilder traceCmd = new StringBuilder(100);
        traceCmd.append("nohup ");
        traceCmd.append(this.mTraceCmdBinary);
        traceCmd.append(" record -o ");
        traceCmd.append(this.fullLogPath());
        traceCmd.append(" ");
        traceCmd.append(this.mTraceCmdRecordArgs);
        traceCmd.append(" > /dev/null 2>&1 &");
        LogUtil.CLog.i((String)"Issuing trace-cmd: %s ", (Object[])new Object[]{traceCmd.toString()});
        CollectingOutputReceiver c = new CollectingOutputReceiver();
        try {
            device.executeShellCommand("chmod +x " + this.mTraceCmdBinary, (IShellOutputReceiver)c, 1L, TimeUnit.SECONDS, 1);
            device.executeShellCommand(traceCmd.toString(), (IShellOutputReceiver)c, 1L, TimeUnit.SECONDS, 1);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)"Error starting trace-cmd:");
            LogUtil.CLog.e((Throwable)e);
        }
    }

    @Override
    protected void stopTracing(ITestDevice device) {
        if (this.mTraceCmdBinary == null) {
            LogUtil.CLog.w((String)"trace-cmd was not set, skipping attempt to stop trace collection");
            return;
        }
        try {
            LogUtil.CLog.i((String)("Collecting trace-cmd log from device: " + device.getSerialNumber()));
            device.executeShellCommand("for PID in $(pidof trace-cmd); do while kill -s sigint $PID; do sleep 0.3; done; done;", (IShellOutputReceiver)new NullOutputReceiver(), 60L, TimeUnit.SECONDS, 1);
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((String)"Error stopping atrace");
            LogUtil.CLog.e((Throwable)e);
        }
    }
}

