/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.ScheduledDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemperatureCollector
extends ScheduledDeviceMetricCollector {
    private static final String CELCIUS_UNIT = "celcius";
    @Option(name="device-temperature-file-path", description="Name of file that contains device temperature. Example: /sys/class/hwmon/hwmon1/device/msm_therm")
    private String mDeviceTemperatureFilePath = null;
    @Option(name="device-temperature-file-regex", description="Regex to parse temperature file. First group must be the temperature parsableto Double. Default: Result:(\\d+) Raw:.*")
    private String mDeviceTemperatureFileRegex = "Result:(\\d+) Raw:.*";
    private Map<ITestDevice, Double> mMaxDeviceTemps;
    private Map<ITestDevice, Double> mMinDeviceTemps;
    private static Pattern mTemperatureRegex;
    private Map<ITestDevice, MetricMeasurement.DoubleValues.Builder> mValues;

    @Override
    void onStart(DeviceMetricData runData) {
        mTemperatureRegex = Pattern.compile(this.mDeviceTemperatureFileRegex);
        this.mMaxDeviceTemps = new HashMap<ITestDevice, Double>();
        this.mMinDeviceTemps = new HashMap<ITestDevice, Double>();
        this.mValues = new HashMap<ITestDevice, MetricMeasurement.DoubleValues.Builder>();
    }

    @Override
    void collect(ITestDevice device, DeviceMetricData runData) throws InterruptedException {
        if (this.mDeviceTemperatureFilePath == null) {
            return;
        }
        try {
            if (!device.isAdbRoot()) {
                return;
            }
            Double temp = this.getTemperature(device);
            if (temp == null) {
                return;
            }
            if (this.mValues.get(device) == null) {
                this.mValues.put(device, MetricMeasurement.DoubleValues.newBuilder());
            }
            this.mValues.get(device).addDoubleValue(temp.doubleValue());
            this.mMaxDeviceTemps.putIfAbsent(device, temp);
            this.mMinDeviceTemps.putIfAbsent(device, temp);
            if (this.mMaxDeviceTemps.get(device) < temp) {
                this.mMaxDeviceTemps.put(device, temp);
            }
            if (this.mMinDeviceTemps.get(device) > temp) {
                this.mMinDeviceTemps.put(device, temp);
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((Throwable)e);
        }
    }

    private Double getTemperature(ITestDevice device) throws DeviceNotAvailableException {
        String cmd = "cat " + this.mDeviceTemperatureFilePath;
        String result = device.executeShellCommand(cmd).trim();
        Matcher m = mTemperatureRegex.matcher(result);
        if (m.matches()) {
            return Double.parseDouble(m.group(1));
        }
        LogUtil.CLog.e((String)("Error parsing temperature file output: " + result));
        return null;
    }

    @Override
    void onEnd(DeviceMetricData runData) {
        for (ITestDevice device : this.getDevices()) {
            Double minTemp;
            Double maxTemp;
            MetricMeasurement.DoubleValues.Builder values = this.mValues.get(device);
            if (values != null) {
                MetricMeasurement.Metric.Builder metric = MetricMeasurement.Metric.newBuilder();
                metric.setMeasurements(MetricMeasurement.Measurements.newBuilder().setDoubleValues(values.build()).build());
                metric.setUnit(CELCIUS_UNIT).setType(MetricMeasurement.DataType.RAW);
                runData.addMetricForDevice(device, "temperature", metric);
            }
            if ((maxTemp = this.mMaxDeviceTemps.get(device)) != null) {
                MetricMeasurement.Metric.Builder metric = MetricMeasurement.Metric.newBuilder();
                metric.setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleDouble(maxTemp.doubleValue()).build());
                metric.setUnit(CELCIUS_UNIT).setType(MetricMeasurement.DataType.PROCESSED);
                runData.addMetricForDevice(device, "max_temperature", metric);
            }
            if ((minTemp = this.mMinDeviceTemps.get(device)) == null) continue;
            MetricMeasurement.Metric.Builder metric = MetricMeasurement.Metric.newBuilder();
            metric.setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleDouble(minTemp.doubleValue()).build());
            metric.setUnit(CELCIUS_UNIT).setType(MetricMeasurement.DataType.PROCESSED);
            runData.addMetricForDevice(device, "min_temperature", metric);
        }
    }
}

