/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.loganalysis.item.DumpsysProcessMeminfoItem;
import com.android.loganalysis.parser.DumpsysProcessMeminfoParser;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.ScheduledDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcessMaxMemoryCollector
extends ScheduledDeviceMetricCollector {
    @Option(name="memory-usage-process-name", description="Process names (from `dumpsys meminfo`) to measure memory usage for")
    private List<String> mProcessNames = new ArrayList<String>();
    private Map<ITestDevice, DeviceMemoryData> mMemoryData;
    private Map<ITestDevice, Map<String, MetricMeasurement.NumericValues.Builder>> mPssMemoryPerProcess;
    private Map<ITestDevice, Map<String, MetricMeasurement.NumericValues.Builder>> mUssMemoryPerProcess;

    @Override
    void onStart(DeviceMetricData runData) {
        this.mMemoryData = new HashMap<ITestDevice, DeviceMemoryData>();
        this.mPssMemoryPerProcess = new HashMap<ITestDevice, Map<String, MetricMeasurement.NumericValues.Builder>>();
        this.mUssMemoryPerProcess = new HashMap<ITestDevice, Map<String, MetricMeasurement.NumericValues.Builder>>();
        for (ITestDevice device : this.getDevices()) {
            this.mMemoryData.put(device, new DeviceMemoryData());
            this.mPssMemoryPerProcess.put(device, new HashMap());
            this.mUssMemoryPerProcess.put(device, new HashMap());
        }
    }

    @Override
    void collect(ITestDevice device, DeviceMetricData runData) throws InterruptedException {
        try {
            Map procPss = this.mMemoryData.get(device).mProcPss;
            Map procUss = this.mMemoryData.get(device).mProcUss;
            for (String proc : this.mProcessNames) {
                String dumpResult = device.executeShellCommand("dumpsys meminfo --checkin " + proc);
                if (dumpResult.startsWith("No process found")) continue;
                DumpsysProcessMeminfoItem item = new DumpsysProcessMeminfoParser().parse(Arrays.asList(dumpResult.split("\n")));
                Long pss = (Long)((Map)item.get((Object)"TOTAL")).get("PSS");
                Long uss = (Long)((Map)item.get((Object)"TOTAL")).get("PRIVATE_DIRTY");
                if (pss == null || uss == null) {
                    LogUtil.CLog.e((String)("Error parsing meminfo output: " + dumpResult));
                    continue;
                }
                if (this.mPssMemoryPerProcess.get(device) == null) {
                    this.mPssMemoryPerProcess.put(device, new HashMap());
                }
                if (this.mPssMemoryPerProcess.get(device).get(proc) == null) {
                    this.mPssMemoryPerProcess.get(device).put(proc, MetricMeasurement.NumericValues.newBuilder());
                }
                this.mPssMemoryPerProcess.get(device).get(proc).addNumericValue(pss.longValue());
                if (this.mUssMemoryPerProcess.get(device) == null) {
                    this.mUssMemoryPerProcess.put(device, new HashMap());
                }
                if (this.mUssMemoryPerProcess.get(device).get(proc) == null) {
                    this.mUssMemoryPerProcess.get(device).put(proc, MetricMeasurement.NumericValues.newBuilder());
                }
                this.mUssMemoryPerProcess.get(device).get(proc).addNumericValue(uss.longValue());
                if (procPss.getOrDefault(proc, 0L) < pss) {
                    procPss.put(proc, pss);
                }
                if (procUss.getOrDefault(proc, 0L) >= uss) continue;
                procUss.put(proc, uss);
            }
        }
        catch (DeviceNotAvailableException e) {
            LogUtil.CLog.e((Throwable)e);
        }
    }

    @Override
    void onEnd(DeviceMetricData runData) {
        for (ITestDevice device : this.getDevices()) {
            MetricMeasurement.Metric.Builder metric;
            MetricMeasurement.Metric.Builder metric2;
            for (Map.Entry<String, MetricMeasurement.NumericValues.Builder> values : this.mPssMemoryPerProcess.get(device).entrySet()) {
                metric2 = MetricMeasurement.Metric.newBuilder();
                metric2.setMeasurements(MetricMeasurement.Measurements.newBuilder().setNumericValues(values.getValue().build())).build();
                metric2.setUnit("kB").setType(MetricMeasurement.DataType.RAW);
                runData.addMetricForDevice(device, "PSS#" + values.getKey(), metric2);
            }
            for (Map.Entry<String, MetricMeasurement.NumericValues.Builder> values : this.mUssMemoryPerProcess.get(device).entrySet()) {
                metric2 = MetricMeasurement.Metric.newBuilder();
                metric2.setMeasurements(MetricMeasurement.Measurements.newBuilder().setNumericValues(values.getValue().build())).build();
                metric2.setUnit("kB").setType(MetricMeasurement.DataType.RAW);
                runData.addMetricForDevice(device, "USS#" + values.getKey(), metric2);
            }
            Map procPss = this.mMemoryData.get(device).mProcPss;
            Map procUss = this.mMemoryData.get(device).mProcUss;
            for (Map.Entry pss : procPss.entrySet()) {
                metric = MetricMeasurement.Metric.newBuilder();
                metric.setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleInt(((Long)pss.getValue()).longValue()).build());
                metric.setUnit("kB").setType(MetricMeasurement.DataType.PROCESSED);
                runData.addMetricForDevice(device, "MAX_PSS#" + (String)pss.getKey(), metric);
            }
            for (Map.Entry uss : procUss.entrySet()) {
                metric = MetricMeasurement.Metric.newBuilder();
                metric.setMeasurements(MetricMeasurement.Measurements.newBuilder().setSingleInt(((Long)uss.getValue()).longValue()).build());
                metric.setUnit("kB").setType(MetricMeasurement.DataType.PROCESSED);
                runData.addMetricForDevice(device, "MAX_USS#" + (String)uss.getKey(), metric);
            }
        }
    }

    private class DeviceMemoryData {
        private Map<String, Long> mProcPss = new HashMap<String, Long>();
        private Map<String, Long> mProcUss = new HashMap<String, Long>();

        private DeviceMemoryData() {
        }
    }
}

