/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device.metric;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.metric.DeviceMetricData;
import com.android.tradefed.device.metric.ScheduledDeviceMetricCollector;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;

public class GraphicsStatsMetricCollector
extends ScheduledDeviceMetricCollector {
    GraphicsStatsMetricCollector() {
        this.setTag("jank");
    }

    @Override
    public void collect(ITestDevice device, DeviceMetricData runData) throws InterruptedException {
        try {
            LogUtil.CLog.i((String)"Running graphicsstats...");
            String outputFileName = String.format("%s/graphics-%s", this.createTempDir(), this.getFileSuffix());
            File outputFile = this.saveProcessOutput(device, "dumpsys graphicsstats", outputFileName);
            try (FileInputStreamSource source = new FileInputStreamSource(outputFile, true);){
                this.getInvocationListener().testLog(Files.getNameWithoutExtension(outputFile.getName()), LogDataType.GFX_INFO, (InputStreamSource)source);
            }
        }
        catch (DeviceNotAvailableException | IOException e) {
            LogUtil.CLog.e((Throwable)e);
        }
    }
}

