/*
 * Decompiled with CFR 0.152.
 */
package android.host.test.longevity.listener;

import android.host.test.longevity.listener.RunTerminator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;

public class TimeoutTerminator
extends RunTerminator {
    public static final String OPTION = "suite-timeout_msec";
    protected static final long DEFAULT = TimeUnit.MINUTES.toMillis(30L);
    protected static final long UNSET_TIMESTAMP = -1L;
    protected long mStartTimestamp = -1L;
    protected long mSuiteTimeout;

    public TimeoutTerminator(RunNotifier notifier, Map<String, String> args) {
        super(notifier);
        this.mSuiteTimeout = args.containsKey(OPTION) ? Long.parseLong(args.get(OPTION)) : DEFAULT;
    }

    public void testStarted(Description description) {
        if (this.mStartTimestamp == -1L) {
            this.mStartTimestamp = this.getCurrentTimestamp();
        }
    }

    public void testFinished(Description description) {
        if (this.mStartTimestamp != -1L && this.getCurrentTimestamp() - this.mStartTimestamp > this.mSuiteTimeout) {
            this.kill("the suite timed out");
        }
    }

    public long getTotalSuiteTimeoutMs() {
        return this.mSuiteTimeout;
    }

    protected long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }
}

