/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.TestResultHistory;
import com.android.compatibility.common.util.TestStatus;
import java.util.List;

public class TestResult
implements ITestResult {
    private final ICaseResult mParent;
    private final String mTestName;
    private TestStatus mResult;
    private String mMessage;
    private String mStackTrace;
    private ReportLog mReport;
    private String mBugReport;
    private String mLog;
    private String mScreenshot;
    private boolean mIsRetry;
    private boolean mSkipped;
    private List<TestResultHistory> mTestResultHistories;

    public TestResult(ICaseResult parent, String name) {
        this.mParent = parent;
        this.mTestName = name;
        this.reset();
    }

    @Override
    public String getName() {
        return this.mTestName;
    }

    @Override
    public String getFullName() {
        return String.format("%s#%s", this.mParent.getName(), this.getName());
    }

    @Override
    public TestStatus getResultStatus() {
        return this.mResult;
    }

    @Override
    public void setResultStatus(TestStatus status) {
        this.mResult = status;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    @Override
    public void setMessage(String message) {
        this.mMessage = message;
    }

    @Override
    public String getStackTrace() {
        return this.mStackTrace;
    }

    @Override
    public void setStackTrace(String stackTrace) {
        this.mStackTrace = TestResult.sanitizeStackTrace(stackTrace);
    }

    @Override
    public ReportLog getReportLog() {
        return this.mReport;
    }

    @Override
    public void setReportLog(ReportLog report) {
        this.mReport = report;
    }

    @Override
    public String getBugReport() {
        return this.mBugReport;
    }

    @Override
    public void setBugReport(String path) {
        this.mBugReport = path;
    }

    @Override
    public String getLog() {
        return this.mLog;
    }

    @Override
    public void setLog(String path) {
        this.mLog = path;
    }

    @Override
    public String getScreenshot() {
        return this.mScreenshot;
    }

    @Override
    public void setScreenshot(String path) {
        this.mScreenshot = path;
    }

    @Override
    public void failed(String trace) {
        this.mSkipped = false;
        this.setResultStatus(TestStatus.FAIL);
        int index = trace.indexOf(10);
        if (index < 0) {
            this.setMessage(trace);
        } else {
            this.setMessage(trace.substring(0, index));
        }
        this.setStackTrace(trace);
    }

    @Override
    public void passed(ReportLog report) {
        this.mSkipped = false;
        if (this.getResultStatus() != TestStatus.FAIL) {
            this.setResultStatus(TestStatus.PASS);
            if (report != null) {
                this.setReportLog(report);
            }
        }
    }

    @Override
    public void skipped() {
        if (this.getResultStatus() == null) {
            this.mSkipped = true;
            this.setResultStatus(TestStatus.PASS);
        }
    }

    @Override
    public boolean isSkipped() {
        return this.mSkipped;
    }

    @Override
    public void reset() {
        this.mResult = null;
        this.mMessage = null;
        this.mStackTrace = null;
        this.mReport = null;
        this.mBugReport = null;
        this.mLog = null;
        this.mScreenshot = null;
        this.mIsRetry = false;
        this.mSkipped = false;
        this.mTestResultHistories = null;
    }

    @Override
    public void setRetry(boolean isRetry) {
        this.mIsRetry = isRetry;
    }

    @Override
    public boolean isRetry() {
        return this.mIsRetry;
    }

    @Override
    public void removeResult() {
        this.setResultStatus(TestStatus.FAIL);
        this.setStackTrace("");
    }

    @Override
    public int compareTo(ITestResult another) {
        return this.getName().compareTo(another.getName());
    }

    static String sanitizeStackTrace(String trace) {
        if (trace != null) {
            return trace.replaceAll("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD]", "");
        }
        return null;
    }

    @Override
    public List<TestResultHistory> getTestResultHistories() {
        return this.mTestResultHistories;
    }

    @Override
    public void setTestResultHistories(List<TestResultHistory> resultHistories) {
        this.mTestResultHistories = resultHistories;
    }
}

