/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReadElf
implements AutoCloseable {
    private static final byte[] ELFMAG = new byte[]{127, 69, 76, 70};
    private static final int EI_NIDENT = 16;
    private static final int EI_CLASS = 4;
    private static final int EI_DATA = 5;
    public static final int ET_DYN = 3;
    public static final int EM_386 = 3;
    public static final int EM_MIPS = 8;
    public static final int EM_ARM = 40;
    public static final int EM_X86_64 = 62;
    public static final int EM_QDSP6 = 164;
    public static final int EM_AARCH64 = 183;
    public static final String ARCH_ARM = "arm";
    public static final String ARCH_X86 = "x86";
    public static final String ARCH_MIPS = "mips";
    public static final String ARCH_UNKNOWN = "unknown";
    private static final String RODATA = ".rodata";
    private static final int ELFCLASS32 = 1;
    private static final int ELFCLASS64 = 2;
    private static final int ELFDATA2LSB = 1;
    private static final int ELFDATA2MSB = 2;
    private static final int EV_CURRENT = 1;
    private static final long PT_LOAD = 1L;
    private static final int SHT_PROGBITS = 1;
    private static final int SHT_SYMTAB = 2;
    private static final int SHT_STRTAB = 3;
    private static final int SHT_DYNAMIC = 6;
    private static final int SHT_DYNSYM = 11;
    private static final int SHT_GNU_VERDEF = 0x6FFFFFFD;
    private static final int SHT_GNU_VERNEED = 0x6FFFFFFE;
    private static final int SHT_GNU_VERSYM = 0x6FFFFFFF;
    private final String mPath;
    private final RandomAccessFile mFile;
    private final byte[] mBuffer = new byte[512];
    private int mEndian;
    private boolean mIsDynamic;
    private boolean mIsPIE;
    private int mType;
    private int mAddrSize;
    private int mMachine;
    private long mSymTabOffset;
    private long mSymTabSize;
    private int mSymEntCnt;
    private long mDynSymOffset;
    private long mDynSymSize;
    private int mDynSymEntCnt;
    private long mShStrTabOffset;
    private long mShStrTabSize;
    private long mStrTabOffset;
    private long mStrTabSize;
    private long mDynStrOffset;
    private long mDynStrSize;
    private long mDynamicTabOffset;
    private long mDynamicTabSize;
    private long mVerSymTabOffset;
    private long mVerSymTabSize;
    private long mVerNeedTabOffset;
    private long mVerNeedTabSize;
    private int mVerNeedEntryCnt;
    private long mVerDefTabOffset;
    private long mVerDefTabSize;
    private int mVerDefEntryCnt;
    private Map<String, Symbol> mSymbols;
    private Symbol[] mSymArr;
    private Map<String, Symbol> mDynamicSymbols;
    private Symbol[] mDynSymArr;
    private int[] mVerSym;
    private VerNeed[] mVerNeedArr;
    private VerDef[] mVerDefArr;
    private List<DynamicEntry> mDynamicArr;
    private boolean mHasRodata = false;
    private long mRodataOffset;
    private int mRodataSize;
    private List<String> mRoStrings;
    private byte[] mRoData = null;

    public static ReadElf read(File file) throws IOException {
        return new ReadElf(file);
    }

    public static void main(String[] args) throws IOException {
        for (String arg : args) {
            int i;
            ReadElf elf = ReadElf.read(new File(arg));
            elf.getDynamicSymbol("x");
            elf.getSymbol("x");
            System.out.println("===Symbol===");
            Symbol[] symArr = elf.getSymArr();
            for (i = 0; i < symArr.length; ++i) {
                System.out.println(String.format("%8x: %s", i, symArr[i].toString()));
            }
            System.out.println("===Dynamic Symbol===");
            symArr = elf.getDynSymArr();
            for (i = 0; i < symArr.length; ++i) {
                if (elf.mVerNeedEntryCnt > 0) {
                    System.out.println(String.format("%8x: %s, %s, %s - %d", i, symArr[i].toString(), symArr[i].getExternalLibName(), symArr[i].getExternalLibFileName(), symArr[i].getExternalLibVer()));
                    continue;
                }
                System.out.println(String.format("%8x: %s, %s - %d", i, symArr[i].toString(), symArr[i].getVerDefLibName(), symArr[i].getVerDefVersion()));
            }
            System.out.println("===Dynamic Dependencies===");
            for (String DynDepEntry : elf.getDynamicDependencies()) {
                System.out.println(DynDepEntry);
            }
            System.out.println("===Strings in Read Only(.rodata) section===");
            for (String roStr : elf.getRoStrings()) {
                System.out.println(roStr);
            }
            elf.close();
        }
    }

    public static boolean isElf(File file) {
        try {
            if (file.length() < 16L) {
                throw new IllegalArgumentException("Too small to be an ELF file: " + file.getCanonicalPath());
            }
            RandomAccessFile raFile = new RandomAccessFile(file, "r");
            byte[] buffer = new byte[512];
            raFile.seek(0L);
            raFile.readFully(buffer, 0, 16);
            if (buffer[0] != ELFMAG[0] || buffer[1] != ELFMAG[1] || buffer[2] != ELFMAG[2] || buffer[3] != ELFMAG[3]) {
                throw new IllegalArgumentException("Invalid ELF file: " + file.getCanonicalPath());
            }
            raFile.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public int getBits() {
        if (this.mMachine == 3 || this.mMachine == 8 || this.mMachine == 40 || this.mMachine == 164) {
            return 32;
        }
        if (this.mMachine == 183 || this.mMachine == 62) {
            return 64;
        }
        return -1;
    }

    public String getArchitecture() {
        if (this.mMachine == 40 || this.mMachine == 183) {
            return ARCH_ARM;
        }
        if (this.mMachine == 3 || this.mMachine == 62) {
            return ARCH_X86;
        }
        if (this.mMachine == 8) {
            return ARCH_MIPS;
        }
        return ARCH_UNKNOWN;
    }

    public Map<String, Symbol> getSymbols() throws IOException {
        if (this.mSymbols == null) {
            this.getSymbol("");
        }
        return this.mSymbols;
    }

    public Symbol[] getSymArr() throws IOException {
        if (this.mSymArr == null) {
            this.getSymbol("");
        }
        return this.mSymArr;
    }

    public Map<String, Symbol> getDynamicSymbols() throws IOException {
        if (this.mDynamicSymbols == null) {
            this.getDynamicSymbol("");
        }
        return this.mDynamicSymbols;
    }

    public Symbol[] getDynSymArr() throws IOException {
        if (this.mDynSymArr == null) {
            this.getDynamicSymbol("");
        }
        return this.mDynSymArr;
    }

    public boolean isDynamic() {
        return this.mIsDynamic;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isPIE() {
        return this.mIsPIE;
    }

    private ReadElf(File file) throws IOException {
        this.mPath = file.getPath();
        this.mFile = new RandomAccessFile(file, "r");
        if (this.mFile.length() < 16L) {
            throw new IllegalArgumentException("Too small to be an ELF file: " + file);
        }
        this.readHeader();
    }

    @Override
    public void close() {
        try {
            this.mFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private void readHeader() throws IOException {
        this.mFile.seek(0L);
        this.mFile.readFully(this.mBuffer, 0, 16);
        if (this.mBuffer[0] != ELFMAG[0] || this.mBuffer[1] != ELFMAG[1] || this.mBuffer[2] != ELFMAG[2] || this.mBuffer[3] != ELFMAG[3]) {
            throw new IllegalArgumentException("Invalid ELF file: " + this.mPath);
        }
        byte elfClass = this.mBuffer[4];
        if (elfClass == 1) {
            this.mAddrSize = 4;
        } else if (elfClass == 2) {
            this.mAddrSize = 8;
        } else {
            throw new IOException("Invalid ELF EI_CLASS: " + elfClass + ": " + this.mPath);
        }
        this.mEndian = this.mBuffer[5];
        if (this.mEndian != 1) {
            if (this.mEndian == 2) {
                throw new IOException("Unsupported ELFDATA2MSB file: " + this.mPath);
            }
            throw new IOException("Invalid ELF EI_DATA: " + this.mEndian + ": " + this.mPath);
        }
        this.mType = this.readHalf();
        int e_machine = this.readHalf();
        if (e_machine != 3 && e_machine != 62 && e_machine != 183 && e_machine != 40 && e_machine != 8 && e_machine != 164) {
            throw new IOException("Invalid ELF e_machine: " + e_machine + ": " + this.mPath);
        }
        if (e_machine == 3 && elfClass != 1 || e_machine == 62 && elfClass != 2 || e_machine == 183 && elfClass != 2 || e_machine == 40 && elfClass != 1 || e_machine == 164 && elfClass != 1) {
            throw new IOException("Invalid e_machine/EI_CLASS ELF combination: " + e_machine + "/" + elfClass + ": " + this.mPath);
        }
        this.mMachine = e_machine;
        long e_version = this.readWord();
        if (e_version != 1L) {
            throw new IOException("Invalid e_version: " + e_version + ": " + this.mPath);
        }
        long e_entry = this.readAddr();
        long ph_off = this.readOff();
        long sh_off = this.readOff();
        long e_flags = this.readWord();
        int e_ehsize = this.readHalf();
        int e_phentsize = this.readHalf();
        int e_phnum = this.readHalf();
        int e_shentsize = this.readHalf();
        int e_shnum = this.readHalf();
        int e_shstrndx = this.readHalf();
        this.readSectionHeaders(sh_off, e_shnum, e_shentsize, e_shstrndx);
        this.readProgramHeaders(ph_off, e_phnum, e_phentsize);
    }

    private void readSectionHeaders(long sh_off, int e_shnum, int e_shentsize, int e_shstrndx) throws IOException {
        this.mFile.seek(sh_off + (long)(e_shstrndx * e_shentsize));
        long sh_name = this.readWord();
        long sh_type = this.readWord();
        long sh_flags = this.readX(this.mAddrSize);
        long sh_addr = this.readAddr();
        long sh_offset = this.readOff();
        long sh_size = this.readX(this.mAddrSize);
        if (sh_type == 3L) {
            this.mShStrTabOffset = sh_offset;
            this.mShStrTabSize = sh_size;
        }
        for (int i = 0; i < e_shnum; ++i) {
            String strTabName;
            if (i == e_shstrndx) continue;
            this.mFile.seek(sh_off + (long)(i * e_shentsize));
            long sh_name2 = this.readWord();
            long sh_type2 = this.readWord();
            long sh_flags2 = this.readX(this.mAddrSize);
            long sh_addr2 = this.readAddr();
            long sh_offset2 = this.readOff();
            long sh_size2 = this.readX(this.mAddrSize);
            long sh_link = this.readWord();
            long sh_info = this.readWord();
            long sh_addralign = this.readX(this.mAddrSize);
            long sh_entsize = this.readX(this.mAddrSize);
            if (sh_type2 == 2L || sh_type2 == 11L) {
                String symTabName = this.readShStrTabEntry(sh_name2);
                if (".symtab".equals(symTabName)) {
                    this.mSymTabOffset = sh_offset2;
                    this.mSymTabSize = sh_size2;
                    this.mSymEntCnt = (int)(sh_size2 / sh_entsize);
                } else if (".dynsym".equals(symTabName)) {
                    this.mDynSymOffset = sh_offset2;
                    this.mDynSymSize = sh_size2;
                    this.mDynSymEntCnt = (int)(sh_size2 / sh_entsize);
                }
                System.out.println(String.format("%s, %d, %d, %d, %d, %d", symTabName, sh_offset2, sh_size2, sh_link, sh_info, sh_entsize));
                continue;
            }
            if (sh_type2 == 3L) {
                strTabName = this.readShStrTabEntry(sh_name2);
                if (".strtab".equals(strTabName)) {
                    this.mStrTabOffset = sh_offset2;
                    this.mStrTabSize = sh_size2;
                    System.out.println(String.format("%s, %d, %d, %d, %d", strTabName, sh_offset2, sh_size2, sh_link, sh_info));
                    continue;
                }
                if (!".dynstr".equals(strTabName)) continue;
                this.mDynStrOffset = sh_offset2;
                this.mDynStrSize = sh_size2;
                System.out.println(String.format("%s, %d, %d, %d, %d", strTabName, sh_offset2, sh_size2, sh_link, sh_info));
                continue;
            }
            if (sh_type2 == 6L) {
                this.mIsDynamic = true;
                strTabName = this.readShStrTabEntry(sh_name2);
                this.mDynamicTabOffset = sh_offset2;
                this.mDynamicTabSize = sh_size2;
                System.out.println(String.format("%s, %d, %d, %d, %d", strTabName, sh_offset2, sh_size2, sh_link, sh_info));
                continue;
            }
            if (sh_type2 == 0x6FFFFFFFL) {
                strTabName = this.readShStrTabEntry(sh_name2);
                if (".gnu.version".equals(strTabName)) {
                    this.mVerSymTabOffset = sh_offset2;
                    this.mVerSymTabSize = sh_size2;
                }
                System.out.println(String.format("%s, %d, %d, %d, %d", strTabName, sh_offset2, sh_size2, sh_link, sh_info));
                continue;
            }
            if (sh_type2 == 0x6FFFFFFEL) {
                strTabName = this.readShStrTabEntry(sh_name2);
                if (".gnu.version_r".equals(strTabName)) {
                    this.mVerNeedTabOffset = sh_offset2;
                    this.mVerNeedTabSize = sh_size2;
                    this.mVerNeedEntryCnt = (int)sh_info;
                }
                System.out.println(String.format("%s, %d, %d, %d, %d", strTabName, sh_offset2, sh_size2, sh_link, sh_info));
                continue;
            }
            if (sh_type2 == 0x6FFFFFFDL) {
                strTabName = this.readShStrTabEntry(sh_name2);
                if (".gnu.version_d".equals(strTabName)) {
                    this.mVerDefTabOffset = sh_offset2;
                    this.mVerDefTabSize = sh_size2;
                    this.mVerDefEntryCnt = (int)sh_info;
                }
                System.out.println(String.format("%s, %d, %d, %d, %d", strTabName, sh_offset2, sh_size2, sh_link, sh_info));
                continue;
            }
            if (sh_type2 != 1L) continue;
            strTabName = this.readShStrTabEntry(sh_name2);
            if (RODATA.equals(strTabName)) {
                this.mHasRodata = true;
                this.mRodataOffset = sh_offset2;
                this.mRodataSize = (int)sh_size2;
            }
            System.out.println(String.format("%s, %d, %d, %d, %d", strTabName, sh_offset2, sh_size2, sh_link, sh_info));
        }
    }

    private void readProgramHeaders(long ph_off, int e_phnum, int e_phentsize) throws IOException {
        for (int i = 0; i < e_phnum; ++i) {
            this.mFile.seek(ph_off + (long)(i * e_phentsize));
            long p_type = this.readWord();
            if (p_type != 1L) continue;
            if (this.mAddrSize == 8) {
                long l = this.readWord();
            }
            long p_offset = this.readOff();
            long p_vaddr = this.readAddr();
            if (p_vaddr != 0L) continue;
            this.mIsPIE = true;
        }
    }

    private HashMap<String, Symbol> readSymbolTable(Symbol[] symArr, boolean isDynSym, long symStrOffset, long symStrSize, long tableOffset, long tableSize) throws IOException {
        HashMap<String, Symbol> result = new HashMap<String, Symbol>();
        this.mFile.seek(tableOffset);
        int i = 0;
        while (this.mFile.getFilePointer() < tableOffset + tableSize) {
            long st_size;
            long st_value;
            int st_shndx;
            int st_other;
            int st_info;
            long st_name = this.readWord();
            if (this.mAddrSize == 8) {
                st_info = this.readByte();
                st_other = this.readByte();
                st_shndx = this.readHalf();
                st_value = this.readAddr();
                st_size = this.readX(this.mAddrSize);
            } else {
                st_value = this.readAddr();
                st_size = this.readWord();
                st_info = this.readByte();
                st_other = this.readByte();
                st_shndx = this.readHalf();
            }
            String symName = st_name == 0L ? "" : this.readStrTabEntry(symStrOffset, symStrSize, st_name);
            Symbol sym = new Symbol(symName, st_info, st_shndx, st_value, st_size, st_other);
            if (!symName.equals("")) {
                result.put(symName, sym);
            }
            if (isDynSym) {
                if (this.mVerNeedEntryCnt > 0) {
                    sym.mVerNeed = sym.type == 0 ? this.mVerNeedArr[0] : this.getVerNeed(this.mVerSym[i]);
                } else if (this.mVerDefEntryCnt > 0) {
                    sym.mVerDef = this.mVerDefArr[this.mVerSym[i]];
                }
            }
            symArr[i] = sym;
            ++i;
        }
        System.out.println(String.format("Info readSymbolTable: %s, isDynSym %b, symbol# %d", this.mPath, isDynSym, symArr.length));
        return result;
    }

    private String readShStrTabEntry(long strOffset) throws IOException {
        if (this.mShStrTabOffset == 0L || strOffset < 0L || strOffset >= this.mShStrTabSize) {
            return null;
        }
        return this.readString(this.mShStrTabOffset + strOffset);
    }

    private String readStrTabEntry(long tableOffset, long tableSize, long strOffset) throws IOException {
        if (tableOffset == 0L || strOffset < 0L || strOffset >= tableSize) {
            return null;
        }
        return this.readString(tableOffset + strOffset);
    }

    private String readDynStrTabEntry(long strOffset) throws IOException {
        if (this.mDynStrOffset == 0L || strOffset < 0L || strOffset >= this.mDynStrSize) {
            return null;
        }
        return this.readString(this.mDynStrOffset + strOffset);
    }

    private int[] getVerSym() throws IOException {
        if (this.mVerSym == null) {
            this.mFile.seek(this.mVerSymTabOffset);
            int cnt = (int)this.mVerSymTabSize / 2;
            this.mVerSym = new int[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.mVerSym[i] = this.readHalf();
            }
        }
        return this.mVerSym;
    }

    public VerNeed getVerNeed(int ndx) throws IOException {
        if (ndx < 2) {
            return this.mVerNeedArr[ndx];
        }
        for (int i = 2; i < this.mVerNeedEntryCnt + 2; ++i) {
            for (int j = 0; j < this.mVerNeedArr[i].vn_cnt; ++j) {
                if (this.mVerNeedArr[i].vn_vernaux[j].vna_other != ndx) continue;
                return this.mVerNeedArr[i];
            }
        }
        System.out.println(String.format("no VerNeed found: %d", ndx));
        return null;
    }

    private VerNeed[] getVerNeedArr() throws IOException {
        if (this.mVerNeedArr == null) {
            this.mVerNeedArr = new VerNeed[this.mVerNeedEntryCnt + 2];
            this.mVerNeedArr[0] = new VerNeed("*local*", "*local*", 0);
            this.mVerNeedArr[1] = new VerNeed("*global*", "*global*", 1);
            long idx = this.mVerNeedTabOffset;
            for (int i = 2; i < this.mVerNeedEntryCnt + 2; ++i) {
                this.mFile.seek(idx);
                this.mVerNeedArr[i] = new VerNeed(this.readHalf(), this.readHalf(), this.readWord(), this.readWord(), this.readWord());
                this.mVerNeedArr[i].vn_file_name = this.readDynStrTabEntry(this.mVerNeedArr[i].vn_file).toLowerCase();
                this.mVerNeedArr[i].vn_vernaux = new VerNAux[this.mVerNeedArr[i].vn_cnt];
                long idxAux = idx + this.mVerNeedArr[i].vn_aux;
                for (int j = 0; j < this.mVerNeedArr[i].vn_cnt; ++j) {
                    this.mFile.seek(idxAux);
                    this.mVerNeedArr[i].vn_vernaux[j] = new VerNAux(this.readWord(), this.readHalf(), this.readHalf(), this.readWord(), this.readWord());
                    this.mVerNeedArr[i].vn_vernaux[j].vna_lib_name = this.readDynStrTabEntry(this.mVerNeedArr[i].vn_vernaux[j].vna_name);
                    idxAux += this.mVerNeedArr[i].vn_vernaux[j].vna_next;
                }
                idx += this.mVerNeedArr[i].vn_next;
                System.out.println(this.mVerNeedArr[i]);
            }
        }
        return this.mVerNeedArr;
    }

    private VerDef[] getVerDef() throws IOException {
        if (this.mVerDefArr == null) {
            this.mVerDefArr = new VerDef[this.mVerDefEntryCnt + 2];
            this.mVerDefArr[0] = new VerDef("*local*");
            this.mVerDefArr[1] = new VerDef("*global*");
            long idx = this.mVerDefTabOffset;
            for (int i = 2; i < this.mVerDefEntryCnt + 2; ++i) {
                this.mFile.seek(idx);
                this.mVerDefArr[i] = new VerDef(this.readHalf(), this.readHalf(), this.readHalf(), this.readHalf(), this.readWord(), this.readWord(), this.readWord());
                this.mVerDefArr[i].vd_verdaux = new VerDAux[this.mVerDefArr[i].vd_cnt];
                long idxAux = idx + this.mVerDefArr[i].vd_aux;
                for (int j = 0; j < this.mVerDefArr[i].vd_cnt; ++j) {
                    this.mFile.seek(idxAux);
                    this.mVerDefArr[i].vd_verdaux[j] = new VerDAux(this.readWord(), this.readWord());
                    this.mVerDefArr[i].vd_verdaux[j].vda_lib_name = this.readDynStrTabEntry(this.mVerDefArr[i].vd_verdaux[j].vda_name).toLowerCase();
                    idxAux += this.mVerDefArr[i].vd_verdaux[j].vda_next;
                }
                idx += this.mVerDefArr[i].vd_next;
                System.out.println(this.mVerDefArr[i]);
            }
        }
        return this.mVerDefArr;
    }

    private int readHalf() throws IOException {
        return (int)this.readX(2);
    }

    private long readWord() throws IOException {
        return this.readX(4);
    }

    private long readOff() throws IOException {
        return this.readX(this.mAddrSize);
    }

    private long readAddr() throws IOException {
        return this.readX(this.mAddrSize);
    }

    private long readX(int byteCount) throws IOException {
        this.mFile.readFully(this.mBuffer, 0, byteCount);
        int answer = 0;
        if (this.mEndian == 1) {
            for (int i = byteCount - 1; i >= 0; --i) {
                answer = answer << 8 | this.mBuffer[i] & 0xFF;
            }
        } else {
            int N = byteCount - 1;
            for (int i = 0; i <= N; ++i) {
                answer = answer << 8 | this.mBuffer[i] & 0xFF;
            }
        }
        return answer;
    }

    private String readString(long offset) throws IOException {
        long originalOffset = this.mFile.getFilePointer();
        this.mFile.seek(offset);
        this.mFile.readFully(this.mBuffer, 0, (int)Math.min((long)this.mBuffer.length, this.mFile.length() - offset));
        this.mFile.seek(originalOffset);
        for (int i = 0; i < this.mBuffer.length; ++i) {
            if (this.mBuffer[i] != 0) continue;
            return new String(this.mBuffer, 0, i);
        }
        return null;
    }

    private int readByte() throws IOException {
        return this.mFile.read() & 0xFF;
    }

    public Symbol getSymbol(String name) {
        if (this.mSymbols == null) {
            try {
                this.mSymArr = new Symbol[this.mSymEntCnt];
                this.mSymbols = this.readSymbolTable(this.mSymArr, false, this.mStrTabOffset, this.mStrTabSize, this.mSymTabOffset, this.mSymTabSize);
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.mSymbols.get(name);
    }

    public Symbol getDynamicSymbol(String name) throws IOException {
        if (this.mDynamicSymbols == null) {
            try {
                int[] verSmyArr = this.getVerSym();
                VerNeed[] verNeedArr = this.getVerNeedArr();
                VerDef[] verDefArr = this.getVerDef();
                this.mDynSymArr = new Symbol[this.mDynSymEntCnt];
                this.mDynamicSymbols = this.readSymbolTable(this.mDynSymArr, true, this.mDynStrOffset, this.mDynStrSize, this.mDynSymOffset, this.mDynSymSize);
            }
            catch (IOException e) {
                return null;
            }
        }
        return this.mDynamicSymbols.get(name);
    }

    public List<String> getDynamicDependencies() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (DynamicEntry entry : this.getDynamicList()) {
            if (!entry.isNeeded()) continue;
            result.add(this.readDynStr(entry.getValue()));
        }
        return result;
    }

    private List<DynamicEntry> getDynamicList() throws IOException {
        if (this.mDynamicArr == null) {
            int entryNo = 0;
            this.mDynamicArr = new ArrayList<DynamicEntry>();
            this.mFile.seek(this.mDynamicTabOffset);
            System.out.println(String.format("mDynamicTabOffset 0x%x, mDynamicTabSize %d", this.mDynamicTabOffset, this.mDynamicTabSize));
            while (true) {
                long tag = this.readX(this.mAddrSize);
                long value = this.readX(this.mAddrSize);
                this.mDynamicArr.add(new DynamicEntry(tag, value));
                if (tag == 0L) break;
                ++entryNo;
            }
        }
        return this.mDynamicArr;
    }

    private String readDynStr(long strOffset) throws IOException {
        int offset = (int)(strOffset & 0xFFFFFFFFFFFFFFFFL);
        if (this.mDynStrOffset == 0L || offset < 0 || (long)offset >= this.mDynStrSize) {
            System.err.println(String.format("err mDynStrOffset: %d,  mDynStrSize: %d, offset: %d", this.mDynStrOffset, this.mDynStrSize, offset));
            return String.format("%d", offset);
        }
        return this.readString(this.mDynStrOffset + (long)offset);
    }

    public List<String> getRoStrings() throws IOException {
        if (this.mRoStrings == null) {
            this.mRoStrings = new ArrayList<String>();
            byte[] byteArr = this.getRoData();
            if (byteArr != null) {
                int strOffset = 0;
                for (int i = 0; i < this.mRodataSize; ++i) {
                    if (byteArr[i] != 0) continue;
                    if (i != strOffset) {
                        String str = new String(byteArr, strOffset, i - strOffset);
                        this.mRoStrings.add(str);
                    }
                    strOffset = i + 1;
                }
            }
        }
        return this.mRoStrings;
    }

    public byte[] getRoData() throws IOException {
        if (this.mHasRodata && this.mRoData == null) {
            this.mRoData = new byte[this.mRodataSize];
            this.mFile.seek(this.mRodataOffset);
            this.mFile.readFully(this.mRoData);
        }
        return this.mRoData;
    }

    public static class DynamicEntry {
        private static final int DT_NEEDED = 1;
        public final long mTag;
        public final long mValue;

        DynamicEntry(long tag, long value) {
            this.mTag = tag;
            this.mValue = value;
        }

        public boolean isNeeded() {
            return this.mTag == 1L;
        }

        public long getValue() {
            return this.mValue;
        }

        public String toString() {
            return String.format("%d, %d", this.mTag, this.mValue);
        }
    }

    public static class VerDAux {
        public final long vda_name;
        public final long vda_next;
        public String vda_lib_name;

        VerDAux(String lib_name) {
            this.vda_lib_name = lib_name.toLowerCase();
            this.vda_name = 0L;
            this.vda_next = 0L;
        }

        VerDAux(long name, long next) {
            this.vda_name = name;
            this.vda_next = next;
        }

        public String toString() {
            return String.format("%s, %d, %d", this.vda_lib_name, this.vda_name, this.vda_next);
        }
    }

    public static class VerDef {
        public final int vd_version;
        public final int vd_flags;
        public final int vd_ndx;
        public final int vd_cnt;
        public final long vd_hash;
        public final long vd_aux;
        public final long vd_next;
        public VerDAux[] vd_verdaux;

        VerDef(String lib_name) {
            this.vd_verdaux = new VerDAux[1];
            this.vd_verdaux[0] = new VerDAux(lib_name);
            this.vd_version = 0;
            this.vd_flags = 0;
            this.vd_ndx = 0;
            this.vd_cnt = 0;
            this.vd_hash = 0L;
            this.vd_aux = 0L;
            this.vd_next = 0L;
        }

        VerDef(int ver, int flags, int ndx, int cnt, long hash, long aux, long next) {
            this.vd_version = ver;
            this.vd_flags = flags;
            this.vd_ndx = ndx;
            this.vd_cnt = cnt;
            this.vd_hash = hash;
            this.vd_aux = aux;
            this.vd_next = next;
        }

        public String toString() {
            String vStr = "";
            for (int i = 0; i < this.vd_cnt; ++i) {
                vStr = vStr + String.format("    %s\n", this.vd_verdaux[i].toString());
            }
            return String.format("%s, %d, %d, %d, %d, %d \n%s", this.vd_verdaux[0].vda_lib_name, this.vd_version, this.vd_flags, this.vd_ndx, this.vd_cnt, this.vd_hash, vStr);
        }
    }

    public static class VerNAux {
        public final long vna_hash;
        public final int vna_flags;
        public final int vna_other;
        public final long vna_name;
        public final long vna_next;
        public String vna_lib_name;

        VerNAux(String lib_name, int ndx) {
            this.vna_lib_name = lib_name;
            this.vna_hash = 0L;
            this.vna_flags = 0;
            this.vna_other = ndx;
            this.vna_name = 0L;
            this.vna_next = 0L;
        }

        VerNAux(long hash, int flags, int other, long name, long next) {
            this.vna_hash = hash;
            this.vna_flags = flags;
            this.vna_other = other;
            this.vna_name = name;
            this.vna_next = next;
        }

        public String toString() {
            return String.format("%s, %d, %d, %d, %d, %d", this.vna_lib_name, this.vna_hash, this.vna_flags, this.vna_other, this.vna_name, this.vna_next);
        }
    }

    public static class VerNeed {
        public final int vn_version;
        public final int vn_cnt;
        public final long vn_file;
        public final long vn_aux;
        public final long vn_next;
        public String vn_file_name;
        public VerNAux[] vn_vernaux;

        VerNeed(String file_name, String lib_name, int ndx) {
            this.vn_file_name = file_name.toLowerCase();
            this.vn_vernaux = new VerNAux[1];
            this.vn_vernaux[0] = new VerNAux(lib_name, ndx);
            this.vn_version = 0;
            this.vn_cnt = 0;
            this.vn_file = 0L;
            this.vn_aux = 0L;
            this.vn_next = 0L;
        }

        VerNeed(int ver, int cnt, long file, long aux, long next) {
            this.vn_version = ver;
            this.vn_cnt = cnt;
            this.vn_file = file;
            this.vn_aux = aux;
            this.vn_next = next;
        }

        public String toString() {
            String vernauxStr = "";
            for (int i = 0; i < this.vn_cnt; ++i) {
                vernauxStr = vernauxStr + String.format("    %s\n", this.vn_vernaux[i].toString());
            }
            return String.format("%s, %d, %d, %d, %d, %d \n%s", this.vn_file_name, this.vn_version, this.vn_cnt, this.vn_file, this.vn_aux, this.vn_next, vernauxStr);
        }
    }

    public static class SecHeader {
        public final long sh_name;
        public final long sh_type;
        public final long sh_flags;
        public final long sh_addr;
        public final long sh_offset;
        public final long sh_size;
        public final long sh_link;
        public final long sh_info;
        public final long sh_addralign;
        public final long sh_entsize;

        SecHeader(long name, long type, long flags, long addr, long offset, long size, long link, long info, long addralign, long entsize) {
            this.sh_name = name;
            this.sh_type = type;
            this.sh_flags = flags;
            this.sh_addr = addr;
            this.sh_offset = offset;
            this.sh_size = size;
            this.sh_link = link;
            this.sh_info = info;
            this.sh_addralign = addralign;
            this.sh_entsize = entsize;
        }

        public String toString() {
            return String.format("%d, %d, %d, %d, %d, %d, %d, %d, %d, %d", this.sh_name, this.sh_type, this.sh_flags, this.sh_addr, this.sh_offset, this.sh_size, this.sh_link, this.sh_info, this.sh_addralign, this.sh_entsize);
        }
    }

    public static class Symbol {
        public static final int STB_LOCAL = 0;
        public static final int STB_GLOBAL = 1;
        public static final int STB_WEAK = 2;
        public static final int STB_LOPROC = 13;
        public static final int STB_HIPROC = 15;
        public static final int STT_NOTYPE = 0;
        public static final int STT_OBJECT = 1;
        public static final int STT_FUNC = 2;
        public static final int STT_SECTION = 3;
        public static final int STT_FILE = 4;
        public static final int STT_COMMON = 5;
        public static final int STT_TLS = 6;
        public static final int SHN_UNDEF = 0;
        public static final int SHN_ABS = 65521;
        public final String name;
        public final int bind;
        public final int type;
        public final int shndx;
        public final long value;
        public final long size;
        public final int other;
        public VerNeed mVerNeed;
        public VerDef mVerDef;

        Symbol(String name, int st_info, int st_shndx, long st_value, long st_size, int st_other) {
            this.name = name;
            this.bind = st_info >> 4 & 0xF;
            this.type = st_info & 0xF;
            this.shndx = st_shndx;
            this.value = st_value;
            this.size = st_size;
            this.other = st_other;
        }

        public String toString() {
            return String.format("%s, %s, %s, %s, %s, %s", this.name, this.toBind(), this.toType(), this.toShndx(), this.getExternalLibFileName(), this.getExternalLibName());
        }

        public String toBind() {
            switch (this.bind) {
                case 0: {
                    return "LOCAL";
                }
                case 1: {
                    return "GLOBAL";
                }
                case 2: {
                    return "WEAK";
                }
            }
            return "STB_??? (" + this.bind + ")";
        }

        public String toType() {
            switch (this.type) {
                case 0: {
                    return "NOTYPE";
                }
                case 1: {
                    return "OBJECT";
                }
                case 2: {
                    return "FUNC";
                }
                case 3: {
                    return "SECTION";
                }
                case 4: {
                    return "FILE";
                }
                case 5: {
                    return "COMMON";
                }
                case 6: {
                    return "TLS";
                }
            }
            return "STT_??? (" + this.type + ")";
        }

        public String toShndx() {
            switch (this.shndx) {
                case 65521: {
                    return "ABS";
                }
                case 0: {
                    return "UND";
                }
            }
            return String.valueOf(this.shndx);
        }

        public boolean isGlobalUnd() {
            return this.bind != 0 && this.shndx == 0;
        }

        public boolean isExtern() {
            return this.bind != 0 && this.shndx != 0;
        }

        public String getExternalLibFileName() {
            if (this.mVerNeed != null) {
                return this.mVerNeed.vn_file_name;
            }
            return null;
        }

        public String getExternalLibName() {
            if (this.mVerNeed != null) {
                return this.mVerNeed.vn_vernaux[0].vna_lib_name;
            }
            return null;
        }

        public int getExternalLibVer() {
            if (this.mVerNeed != null) {
                return this.mVerNeed.vn_vernaux[0].vna_other;
            }
            return -1;
        }

        public String getVerDefLibName() {
            if (this.mVerDef != null) {
                return this.mVerDef.vd_verdaux[0].vda_lib_name;
            }
            return null;
        }

        public int getVerDefVersion() {
            if (this.mVerDef != null) {
                return this.mVerDef.vd_version;
            }
            return -1;
        }
    }
}

