/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.device.PackageInfo;

public class PackageUtil {
    public static boolean exists(ITestDevice device, String packageName) throws DeviceNotAvailableException {
        return device.getInstalledPackageNames().contains(packageName);
    }

    public static boolean isSystemApp(ITestDevice device, String packageName) throws DeviceNotAvailableException {
        PackageInfo info = device.getAppPackageInfo(packageName);
        return info != null && info.isSystemApp();
    }

    public static String getVersionString(ITestDevice device, String packageName) throws DeviceNotAvailableException {
        PackageInfo info = device.getAppPackageInfo(packageName);
        return info != null ? info.getVersionName() : null;
    }
}

