/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class MultipartForm {
    private static final String FORM_DATA_BOUNDARY = "C75I55u3R3p0r73r";
    final String mServerUrl;
    final Map<String, String> mFormValues = new HashMap<String, String>();
    String mName;
    String mFileName;
    byte[] mData;

    public MultipartForm(String serverUrl) {
        this.mServerUrl = serverUrl;
    }

    public MultipartForm addFormValue(String name, String value) {
        this.mFormValues.put(name, value);
        return this;
    }

    public MultipartForm addFormFile(String name, String fileName, byte[] data) {
        this.mName = name;
        this.mFileName = fileName;
        this.mData = data;
        return this;
    }

    public int submit() throws IOException {
        return this.submitForm(this.mServerUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submitForm(String serverUrl) throws IOException {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(serverUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=C75I55u3R3p0r73r");
            byte[] body = this.getContentBody();
            connection.setRequestProperty("Content-Length", Integer.toString(body.length));
            try (OutputStream output = connection.getOutputStream();){
                output.write(body);
            }
            InputStream input = connection.getInputStream();
            input.close();
            int response = connection.getResponseCode();
            if (response == 302) {
                int n = this.submitForm(connection.getHeaderField("Location"));
                return n;
            }
            int n = response;
            return n;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    byte[] getContentBody() throws IOException {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(byteOutput));
        writer.println();
        for (Map.Entry<String, String> formValue : this.mFormValues.entrySet()) {
            this.writeFormField(writer, formValue.getKey(), formValue.getValue());
        }
        if (this.mData != null) {
            this.writeFormFileHeader(writer, this.mName, this.mFileName);
            writer.flush();
            byteOutput.write(this.mData);
            writer.println();
        }
        writer.append("--").append(FORM_DATA_BOUNDARY).println("--");
        writer.flush();
        writer.close();
        return byteOutput.toByteArray();
    }

    private void writeFormField(PrintWriter writer, String name, String value) {
        writer.append("--").println(FORM_DATA_BOUNDARY);
        writer.append("Content-Disposition: form-data; name=\"").append(name).println("\"");
        writer.println();
        writer.println(value);
    }

    private void writeFormFileHeader(PrintWriter writer, String name, String fileName) {
        writer.append("--").println(FORM_DATA_BOUNDARY);
        writer.append("Content-Disposition: form-data; name=\"").append(name);
        writer.append("\"; filename=\"").append(fileName).println("\"");
        writer.println("Content-Type: application/x-gzip");
        writer.println("Content-Transfer-Encoding: binary");
        writer.println();
    }
}

