/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.ddmlib.Log;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.util.RunUtil;

public class MonitoringUtils {
    private static final long CONNECTIVITY_CHECK_TIME_MS = 20000L;
    private static final long CONNECTIVITY_CHECK_INTERVAL_MS = 5000L;

    public static boolean checkDeviceConnectivity(ITestDevice device) throws DeviceNotAvailableException {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < 20000L) {
            if (device.checkConnectivity()) {
                LogUtil.CLog.i((String)"Wifi Connectivity: passed check.");
                return true;
            }
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Wifi Connectivity check failed on %s. (Is your device connected to Wifi?), retrying in %dms", (Object[])new Object[]{device.getSerialNumber(), 5000L});
            RunUtil.getDefault().sleep(5000L);
        }
        return false;
    }

    public static void checkDeviceConnectivity(ITestDevice device, ITestInvocationListener listener, String tag) throws DeviceNotAvailableException {
        if (!MonitoringUtils.checkDeviceConnectivity(device)) {
            LogUtil.CLog.w((String)"Wifi Connectivity: check failed. (Is your device connected to Wifi?)");
            device.logBugreport(String.format("bugreport-connectivity-%s", tag), (ITestLogger)listener);
        }
    }
}

