/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ReportLog;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public final class MetricsXmlSerializer {
    private final XmlSerializer mXmlSerializer;

    public MetricsXmlSerializer(XmlSerializer xmlSerializer) {
        this.mXmlSerializer = xmlSerializer;
    }

    public void serialize(ReportLog reportLog) throws IOException {
        if (reportLog == null) {
            return;
        }
        ReportLog.Metric summary = reportLog.getSummary();
        if (summary != null) {
            this.mXmlSerializer.startTag(null, "Summary");
            this.mXmlSerializer.attribute(null, "message", summary.getMessage());
            this.mXmlSerializer.attribute(null, "scoreType", summary.getType().toReportString());
            this.mXmlSerializer.attribute(null, "unit", summary.getUnit().toReportString());
            this.mXmlSerializer.text(Double.toString(summary.getValues()[0]));
            this.mXmlSerializer.endTag(null, "Summary");
        }
    }
}

