/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public abstract class InfoStore
implements AutoCloseable {
    protected static final int MAX_STRING_LENGTH = 1000;
    protected static final int MAX_ARRAY_LENGTH = 1000;
    protected static final int MAX_LIST_LENGTH = 1000;

    abstract void open() throws IOException;

    @Override
    public abstract void close() throws Exception;

    abstract void startGroup() throws IOException;

    abstract void startGroup(String var1) throws IOException;

    abstract void endGroup() throws IOException;

    abstract void startArray() throws IOException;

    abstract void startArray(String var1) throws IOException;

    abstract void endArray() throws IOException;

    abstract void addResult(String var1, int var2) throws IOException;

    abstract void addResult(String var1, long var2) throws IOException;

    abstract void addResult(String var1, float var2) throws IOException;

    abstract void addResult(String var1, double var2) throws IOException;

    abstract void addResult(String var1, boolean var2) throws IOException;

    abstract void addResult(String var1, String var2) throws IOException;

    abstract void addArrayResult(String var1, int[] var2) throws IOException;

    abstract void addArrayResult(String var1, long[] var2) throws IOException;

    abstract void addArrayResult(String var1, float[] var2) throws IOException;

    abstract void addArrayResult(String var1, double[] var2) throws IOException;

    abstract void addArrayResult(String var1, boolean[] var2) throws IOException;

    abstract void addListResult(String var1, List<String> var2) throws IOException;

    protected static int[] checkArray(int[] values) {
        if (values.length > 1000) {
            return Arrays.copyOf(values, 1000);
        }
        return values;
    }

    protected static long[] checkArray(long[] values) {
        if (values.length > 1000) {
            return Arrays.copyOf(values, 1000);
        }
        return values;
    }

    protected static float[] checkArray(float[] values) {
        if (values.length > 1000) {
            return Arrays.copyOf(values, 1000);
        }
        return values;
    }

    protected static double[] checkArray(double[] values) {
        if (values.length > 1000) {
            return Arrays.copyOf(values, 1000);
        }
        return values;
    }

    protected static boolean[] checkArray(boolean[] values) {
        if (values.length > 1000) {
            return Arrays.copyOf(values, 1000);
        }
        return values;
    }

    protected static List<String> checkStringList(List<String> list) {
        if (list.size() > 1000) {
            return list.subList(0, 1000);
        }
        return list;
    }

    protected static String checkString(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        if (value.length() > 1000) {
            return value.substring(0, 1000);
        }
        return value;
    }

    protected static String checkName(String value) {
        if (value == null || value.isEmpty()) {
            throw new NullPointerException();
        }
        return value;
    }

    protected static boolean isDoubleNaNOrInfinite(Double value) {
        return Double.isNaN(value) || Double.isInfinite(value);
    }
}

