/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.DynamicConfig;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

public class DynamicConfigHandler {
    private static final String FILE_EXT = ".dynamic";
    private static final String NS = null;
    private static final String ENCODING = "UTF-8";

    public static File getMergedDynamicConfigFile(File localConfigFile, String apbsConfigJson, String moduleName) throws IOException, XmlPullParserException, JSONException {
        Map<String, List<String>> localConfig = DynamicConfig.createConfigMap(localConfigFile);
        Map<String, List<String>> apbsConfig = DynamicConfigHandler.parseJsonToConfigMap(apbsConfigJson);
        localConfig.putAll(apbsConfig);
        DynamicConfigHandler.setRemoteConfigRetrieved(localConfig, apbsConfigJson != null);
        return DynamicConfigHandler.storeMergedConfigFile(localConfig, moduleName);
    }

    private static void setRemoteConfigRetrieved(Map<String, List<String>> config, boolean retrieved) {
        List<String> val = Collections.singletonList(Boolean.toString(retrieved));
        config.put("remote_config_retrieved", val);
    }

    private static Map<String, List<String>> parseJsonToConfigMap(String apbsConfigJson) throws JSONException {
        HashMap<String, List<String>> configMap = new HashMap<String, List<String>>();
        if (apbsConfigJson == null) {
            return configMap;
        }
        JSONObject rootObj = new JSONObject(new JSONTokener(apbsConfigJson));
        JSONObject configObject = null;
        try {
            configObject = rootObj.getJSONObject("dynamicConfigEntries");
        }
        catch (JSONException e) {
            return configMap;
        }
        JSONArray keys = configObject.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(i);
            JSONArray jsonValues = configObject.getJSONObject(key).getJSONArray("configValues");
            ArrayList<String> values = new ArrayList<String>();
            for (int j = 0; j < jsonValues.length(); ++j) {
                values.add(jsonValues.getString(j));
            }
            configMap.put(key, values);
        }
        return configMap;
    }

    private static File storeMergedConfigFile(Map<String, List<String>> configMap, String moduleName) throws XmlPullParserException, IOException {
        File mergedConfigFile = FileUtil.createTempFile((String)moduleName, (String)FILE_EXT);
        FileOutputStream stream = new FileOutputStream(mergedConfigFile);
        XmlSerializer serializer = XmlPullParserFactory.newInstance().newSerializer();
        serializer.setOutput((OutputStream)stream, ENCODING);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startDocument(ENCODING, Boolean.valueOf(false));
        serializer.startTag(NS, "dynamicConfig");
        for (String key : configMap.keySet()) {
            serializer.startTag(NS, "entry");
            serializer.attribute(NS, "key", key);
            for (String value : configMap.get(key)) {
                serializer.startTag(NS, "value");
                serializer.text(value);
                serializer.endTag(NS, "value");
            }
            serializer.endTag(NS, "entry");
        }
        serializer.endTag(NS, "dynamicConfig");
        serializer.endDocument();
        return mergedConfigFile;
    }
}

