/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.ddmlib.IShellOutputReceiver;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import java.util.regex.Pattern;

public class CpuFeatures {
    private static final String UNAME_OPTION_MACHINE_TYPE = "-m";
    private static final String UNAME_OPTION_KERNEL_RELEASE = "-r";

    private static String uname(ITestDevice device, String option) throws DeviceNotAvailableException {
        CollectingOutputReceiver Out = new CollectingOutputReceiver();
        device.executeShellCommand("uname " + option, (IShellOutputReceiver)Out);
        return Out.getOutput().trim();
    }

    public static boolean isArm64(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.uname(device, UNAME_OPTION_MACHINE_TYPE).contains("aarch64");
    }

    public static boolean isArm32(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.uname(device, UNAME_OPTION_MACHINE_TYPE).contains("armv7");
    }

    public static boolean isX86(ITestDevice device) throws DeviceNotAvailableException {
        return CpuFeatures.uname(device, UNAME_OPTION_MACHINE_TYPE).contains("x86");
    }

    public static boolean kernelVersionLessThan(ITestDevice device, int major, int minor) throws DeviceNotAvailableException {
        String[] kernelVersion = CpuFeatures.uname(device, UNAME_OPTION_KERNEL_RELEASE).split(Pattern.quote("."));
        int deviceMajor = Integer.parseInt(kernelVersion[0]);
        int deviceMinor = Integer.parseInt(kernelVersion[1]);
        return major > deviceMajor || major == deviceMajor && minor > deviceMinor;
    }
}

