/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.CommonTestUtils;
import com.android.compatibility.common.util.StreamUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;

public abstract class BackupUtils {
    private static final String LOCAL_TRANSPORT_NAME = "com.android.localtransport/.LocalTransport";
    private static final String LOCAL_TRANSPORT_NAME_PRE_Q = "android/com.android.internal.backup.LocalTransport";
    private static final String LOCAL_TRANSPORT_PACKAGE = "com.android.localtransport";
    public static final String LOCAL_TRANSPORT_TOKEN = "1";
    private static final int BACKUP_PROVISIONING_TIMEOUT_SECONDS = 30;
    private static final int BACKUP_PROVISIONING_POLL_INTERVAL_SECONDS = 1;
    private static final long BACKUP_SERVICE_INIT_TIMEOUT_SECS = TimeUnit.MINUTES.toSeconds(2L);
    private static final Pattern BACKUP_MANAGER_CURRENTLY_ENABLE_STATUS_PATTERN = Pattern.compile("^Backup Manager currently (enabled|disabled)$");
    private static final String MATCH_LINE_BACKUP_MANAGER_IS_NOT_PENDING_INIT = "(?s)^Backup Manager is .* not pending init.*";
    private static final String BACKUP_DUMPSYS_CURRENT_TOKEN_FIELD = "Current:";

    protected abstract InputStream executeShellCommand(String var1) throws IOException;

    public void executeShellCommandSync(String command) throws IOException {
        StreamUtil.drainAndClose(new InputStreamReader(this.executeShellCommand(command)));
    }

    public String getShellCommandOutput(String command) throws IOException {
        return StreamUtil.readInputStream(this.executeShellCommand(command));
    }

    public void backupNowAndAssertSuccess(String packageName) throws IOException {
        this.assertBackupIsSuccessful(packageName, this.backupNow(packageName));
    }

    public void backupNowAndAssertSuccessForUser(String packageName, int userId) throws IOException {
        this.assertBackupIsSuccessful(packageName, this.backupNowForUser(packageName, userId));
    }

    public void backupNowAndAssertBackupNotAllowed(String packageName) throws IOException {
        this.assertBackupNotAllowed(packageName, this.getBackupNowOutput(packageName));
    }

    public void backupNowSync(String packageName) throws IOException {
        StreamUtil.drainAndClose(new InputStreamReader(this.backupNow(packageName)));
    }

    public String getBackupNowOutput(String packageName) throws IOException {
        return StreamUtil.readInputStream(this.backupNow(packageName));
    }

    public void restoreAndAssertSuccess(String token, String packageName) throws IOException {
        this.assertRestoreIsSuccessful(this.restore(token, packageName));
    }

    public void restoreAndAssertSuccessForUser(String token, String packageName, int userId) throws IOException {
        this.assertRestoreIsSuccessful(this.restoreForUser(token, packageName, userId));
    }

    public void restoreSync(String token, String packageName) throws IOException {
        StreamUtil.drainAndClose(new InputStreamReader(this.restore(token, packageName)));
    }

    public String getRestoreOutput(String token, String packageName) throws IOException {
        return StreamUtil.readInputStream(this.restore(token, packageName));
    }

    public boolean isLocalTransportSelected() throws IOException {
        return this.getShellCommandOutput("bmgr list transports").contains("* " + this.getLocalTransportName());
    }

    public boolean isLocalTransportSelectedForUser(int userId) throws IOException {
        return this.getShellCommandOutput(String.format("bmgr --user %d list transports", userId)).contains("* " + this.getLocalTransportName());
    }

    public boolean isBackupEnabled() throws IOException {
        return this.getShellCommandOutput("bmgr enabled").contains("currently enabled");
    }

    public boolean isBackupEnabledForUser(int userId) throws IOException {
        return this.getShellCommandOutput(String.format("bmgr --user %d enabled", userId)).contains("currently enabled");
    }

    public void wakeAndUnlockDevice() throws IOException {
        this.executeShellCommandSync("input keyevent KEYCODE_WAKEUP");
        this.executeShellCommandSync("wm dismiss-keyguard");
    }

    public String getLocalTransportName() throws IOException {
        return this.getShellCommandOutput("pm list packages").contains(LOCAL_TRANSPORT_PACKAGE) ? LOCAL_TRANSPORT_NAME : LOCAL_TRANSPORT_NAME_PRE_Q;
    }

    private InputStream backupNow(String packageName) throws IOException {
        return this.executeShellCommand("bmgr backupnow " + packageName);
    }

    private InputStream backupNowForUser(String packageName, int userId) throws IOException {
        return this.executeShellCommand(String.format("bmgr --user %d backupnow %s", userId, packageName));
    }

    private void assertBackupNotAllowed(String packageName, String backupNowOutput) {
        Scanner in = new Scanner(backupNowOutput);
        boolean found = false;
        while (in.hasNextLine()) {
            String result;
            String line = in.nextLine();
            if (!line.contains(packageName) || !"Backup is not allowed".equals(result = line.split(":")[1].trim())) continue;
            found = true;
        }
        in.close();
        Assert.assertTrue((String)"Didn't find 'Backup not allowed' in the output", (boolean)found);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertBackupIsSuccessful(String packageName, InputStream backupNowOutput) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(backupNowOutput, StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(packageName)) continue;
                String result = line.split(":")[1].trim().toLowerCase();
                if (!"success".equals(result)) continue;
                return;
            }
            Assert.fail((String)"Couldn't find package in output or backup wasn't successful");
        }
        finally {
            StreamUtil.drainAndClose(reader);
        }
    }

    private InputStream restore(String token, String packageName) throws IOException {
        return this.executeShellCommand(String.format("bmgr restore %s %s", token, packageName));
    }

    private InputStream restoreForUser(String token, String packageName, int userId) throws IOException {
        return this.executeShellCommand(String.format("bmgr --user %d restore %s %s", userId, token, packageName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertRestoreIsSuccessful(InputStream restoreOutput) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(restoreOutput, StandardCharsets.UTF_8));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("restoreFinished: 0")) continue;
                return;
            }
            Assert.fail((String)"Restore not successful");
        }
        finally {
            StreamUtil.drainAndClose(reader);
        }
    }

    public String executeShellCommandAndReturnOutput(String command) throws IOException {
        String str;
        InputStream in = this.executeShellCommand(command);
        BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        StringBuilder out = new StringBuilder();
        while ((str = br.readLine()) != null) {
            out.append(str).append("\n");
        }
        return out.toString();
    }

    public boolean enableBackup(boolean enable) throws Exception {
        String output = this.getLineString(this.executeShellCommand("bmgr enabled"));
        Matcher matcher = BACKUP_MANAGER_CURRENTLY_ENABLE_STATUS_PATTERN.matcher(output.trim());
        if (!matcher.find()) {
            throw new RuntimeException("non-parsable output setting bmgr enabled: " + output);
        }
        boolean previouslyEnabled = "enabled".equals(matcher.group(1));
        this.executeShellCommand("bmgr enable " + enable);
        return previouslyEnabled;
    }

    public boolean enableBackupForUser(boolean enable, int userId) throws IOException {
        boolean previouslyEnabled = this.isBackupEnabledForUser(userId);
        this.executeShellCommand(String.format("bmgr --user %d enable %b", userId, enable));
        return previouslyEnabled;
    }

    public boolean activateBackupForUser(boolean activate, int userId) throws IOException {
        boolean previouslyActivated = this.isBackupActivatedForUser(userId);
        this.executeShellCommandSync(String.format("bmgr --user %d activate %b", userId, activate));
        return previouslyActivated;
    }

    public boolean isBackupActivatedForUser(int userId) throws IOException {
        return this.getShellCommandOutput(String.format("bmgr --user %d activated", userId)).contains("currently activated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLineString(InputStream inputStream) throws IOException {
        String str;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        try {
            str = reader.readLine();
        }
        finally {
            StreamUtil.drainAndClose(reader);
        }
        return str;
    }

    public void waitForBackupInitialization() throws IOException {
        long tryUntilNanos = System.nanoTime() + TimeUnit.SECONDS.toNanos(30L);
        while (System.nanoTime() < tryUntilNanos) {
            String output = this.getLineString(this.executeShellCommand("dumpsys backup"));
            if (output.matches(MATCH_LINE_BACKUP_MANAGER_IS_NOT_PENDING_INIT)) {
                return;
            }
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        throw new IOException("Timed out waiting for backup initialization");
    }

    public void waitUntilBackupServiceIsRunning(int userId) throws IOException, InterruptedException {
        this.waitUntilBackupServiceIsRunning(userId, BACKUP_SERVICE_INIT_TIMEOUT_SECS);
    }

    @VisibleForTesting
    void waitUntilBackupServiceIsRunning(int userId, long timeout) throws IOException, InterruptedException {
        CommonTestUtils.waitUntil("Backup Manager init timed out", timeout, () -> {
            String output = this.getLineString(this.executeShellCommand("dumpsys backup users"));
            return output.matches("Backup Manager is running for users:.* " + userId + "( .*)?");
        });
    }

    public boolean userHasBackupTransport(String transport, int userId) throws IOException {
        String output = this.getLineString(this.executeShellCommand(String.format("bmgr --user %d list transports", userId)));
        for (String t : output.split("\n")) {
            if (!transport.equals(t = t.replace("*", "").trim())) continue;
            return true;
        }
        return false;
    }

    public String setBackupTransportForUser(String transport, int userId) throws IOException {
        String output = this.executeShellCommandAndReturnOutput(String.format("bmgr --user %d transport %s", userId, transport));
        Pattern pattern = Pattern.compile("\\(formerly (.*)\\)$");
        Matcher matcher = pattern.matcher(output);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new RuntimeException("Non-parsable output setting bmgr transport: " + output);
    }
}

