/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.rule;

import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.WakelockItem;
import com.android.loganalysis.rule.AbstractPowerRule;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WakelockRule
extends AbstractPowerRule {
    private static final String WAKELOCK_ANALYSIS = "WAKELOCK_ANALYSIS";
    private static final float WAKELOCK_HELD_TIME_THRESHOLD_PERCENTAGE = 0.1f;
    private List<WakelockItem.WakelockInfoItem> mOffendingWakelockList;

    public WakelockRule(BugreportItem bugreportItem) {
        super(bugreportItem);
    }

    @Override
    public void applyRule() {
        this.mOffendingWakelockList = new ArrayList<WakelockItem.WakelockInfoItem>();
        WakelockItem wakelockItem = this.getDetailedAnalysisItem().getWakelockItem();
        if (wakelockItem != null && this.getTimeOnBattery() > 0L) {
            long wakelockThreshold = (long)((float)this.getTimeOnBattery() * 0.1f);
            for (WakelockItem.WakelockInfoItem wakelocks : wakelockItem.getWakeLocks()) {
                if (wakelocks.getHeldTime() <= wakelockThreshold) continue;
                this.mOffendingWakelockList.add(wakelocks);
            }
        }
    }

    @Override
    public JSONObject getAnalysis() {
        JSONObject wakelockAnalysis = new JSONObject();
        StringBuilder analysis = new StringBuilder();
        if (this.mOffendingWakelockList == null || this.mOffendingWakelockList.size() <= 0) {
            analysis.append("No wakelocks were held for more than 10% of time on battery.");
        } else {
            for (WakelockItem.WakelockInfoItem wakelocks : this.mOffendingWakelockList) {
                analysis.append(String.format("%s %s is held for %s. ", new Object[]{wakelocks.getName(), wakelocks.getCategory(), NumberFormattingUtil.getDuration(wakelocks.getHeldTime())}));
            }
        }
        try {
            wakelockAnalysis.put(WAKELOCK_ANALYSIS, (Object)analysis.toString().trim());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return wakelockAnalysis;
    }
}

