/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.rule;

import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.ProcessUsageItem;
import com.android.loganalysis.rule.AbstractPowerRule;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ProcessUsageRule
extends AbstractPowerRule {
    private static final String ALARM_USAGE_ANALYSIS = "ALARM_USAGE_ANALYSIS";
    private static final String SENSOR_USAGE_ANALYSIS = "SENSOR_USAGE_ANALYSIS";
    private static final long ALARM_THRESHOLD = 60000L;
    private static final float SENSOR_ACTIVE_TIME_THRESHOLD_PERCENTAGE = 0.1f;
    private List<ProcessUsageItem.ProcessUsageInfoItem> mOffendingAlarmList;
    private List<ProcessUsageItem.ProcessUsageInfoItem> mOffendingSensorList;

    public ProcessUsageRule(BugreportItem bugreportItem) {
        super(bugreportItem);
    }

    @Override
    public void applyRule() {
        this.mOffendingAlarmList = new ArrayList<ProcessUsageItem.ProcessUsageInfoItem>();
        this.mOffendingSensorList = new ArrayList<ProcessUsageItem.ProcessUsageInfoItem>();
        ProcessUsageItem processUsageItem = this.getDetailedAnalysisItem().getProcessUsageItem();
        if (processUsageItem != null && this.getTimeOnBattery() > 0L) {
            for (ProcessUsageItem.ProcessUsageInfoItem usage : processUsageItem.getProcessUsage()) {
                if (usage.getAlarmWakeups() > 0) {
                    this.addAlarmAnalysis(usage);
                }
                if (usage.getSensorUsage() == null || usage.getSensorUsage().size() <= 0) continue;
                this.addSensorAnalysis(usage);
            }
        }
    }

    private void addAlarmAnalysis(ProcessUsageItem.ProcessUsageInfoItem usage) {
        long alarmsPerMs = this.getTimeOnBattery() / (long)usage.getAlarmWakeups();
        if (alarmsPerMs < 60000L) {
            this.mOffendingAlarmList.add(usage);
        }
    }

    private void addSensorAnalysis(ProcessUsageItem.ProcessUsageInfoItem usage) {
        long sensorUsageThresholdMs = (long)((float)this.getTimeOnBattery() * 0.1f);
        for (ProcessUsageItem.SensorInfoItem sensorInfo : usage.getSensorUsage()) {
            if (sensorInfo.getUsageDurationMs() <= sensorUsageThresholdMs) continue;
            this.mOffendingSensorList.add(usage);
        }
    }

    @Override
    public JSONObject getAnalysis() {
        JSONObject usageAnalysis = new JSONObject();
        StringBuilder alarmAnalysis = new StringBuilder();
        if (this.mOffendingAlarmList == null || this.mOffendingAlarmList.size() <= 0) {
            alarmAnalysis.append("No apps requested for alarms more frequent than 60 secs.");
        } else {
            for (ProcessUsageItem.ProcessUsageInfoItem alarmInfo : this.mOffendingAlarmList) {
                alarmAnalysis.append(String.format("UID %s has requested frequent repeating alarms. ", alarmInfo.getProcessUID()));
            }
        }
        StringBuilder sensorAnalysis = new StringBuilder();
        if (this.mOffendingSensorList == null || this.mOffendingSensorList.size() <= 0) {
            sensorAnalysis.append("No apps used sensors more than 10% time on battery.");
        } else {
            for (ProcessUsageItem.ProcessUsageInfoItem sensorInfo : this.mOffendingSensorList) {
                for (ProcessUsageItem.SensorInfoItem sensors : sensorInfo.getSensorUsage()) {
                    sensorAnalysis.append(String.format("sensor %s was used for %s by UID %s. ", sensors.getSensorName(), NumberFormattingUtil.getDuration(sensors.getUsageDurationMs()), sensorInfo.getProcessUID()));
                }
            }
        }
        try {
            usageAnalysis.put(ALARM_USAGE_ANALYSIS, (Object)alarmAnalysis.toString().trim());
            usageAnalysis.put(SENSOR_USAGE_ANALYSIS, (Object)sensorAnalysis.toString().trim());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return usageAnalysis;
    }
}

