/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.rule;

import com.android.loganalysis.item.BatteryStatsDetailedInfoItem;
import com.android.loganalysis.item.BatteryStatsSummaryInfoItem;
import com.android.loganalysis.item.BugreportItem;
import com.android.loganalysis.item.DumpsysProcStatsItem;
import com.android.loganalysis.item.DumpsysWifiStatsItem;
import com.android.loganalysis.rule.IRule;
import org.json.JSONObject;

public abstract class AbstractPowerRule
implements IRule {
    private BugreportItem mBugreportItem;
    private BatteryStatsSummaryInfoItem mPowerSummaryAnalysisItem;
    private BatteryStatsDetailedInfoItem mPowerDetailedAnalysisItem;
    private DumpsysProcStatsItem mProcStatsItem;
    private DumpsysWifiStatsItem mWifiStatsItem;

    public AbstractPowerRule(BugreportItem bugreportItem) {
        this.mBugreportItem = bugreportItem;
        this.mPowerSummaryAnalysisItem = this.mBugreportItem.getDumpsys().getBatteryStats().getBatteryStatsSummaryItem();
        this.mPowerDetailedAnalysisItem = this.mBugreportItem.getDumpsys().getBatteryStats().getDetailedBatteryStatsItem();
        this.mProcStatsItem = this.mBugreportItem.getDumpsys().getProcStats();
        this.mWifiStatsItem = this.mBugreportItem.getDumpsys().getWifiStats();
    }

    protected long getTimeOnBattery() {
        return this.mPowerDetailedAnalysisItem.getTimeOnBattery();
    }

    protected BatteryStatsSummaryInfoItem getSummaryItem() {
        return this.mPowerSummaryAnalysisItem;
    }

    protected BatteryStatsDetailedInfoItem getDetailedAnalysisItem() {
        return this.mPowerDetailedAnalysisItem;
    }

    protected DumpsysProcStatsItem getProcStatsItem() {
        return this.mProcStatsItem;
    }

    protected DumpsysWifiStatsItem getWifiStatsItem() {
        return this.mWifiStatsItem;
    }

    @Override
    public abstract void applyRule();

    @Override
    public abstract JSONObject getAnalysis();
}

