/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.ProcessUsageItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessUsageParser
implements IParser {
    private ProcessUsageItem mItem = new ProcessUsageItem();
    private LinkedList<ProcessUsageItem.SensorInfoItem> mSensorUsage = new LinkedList();
    private static final Pattern UID_PATTERN = Pattern.compile("^\\s*(\\w+):$");
    private static final Pattern SENSOR_PATTERN = Pattern.compile("^\\s*Sensor (\\d+): (?:(\\d+)d\\s)?(?:(\\d+)h\\s)?(?:(\\d+)m\\s)?(?:(\\d+)s\\s)?(\\d+)ms realtime \\((\\d+) times\\)$");
    private static final Pattern ALARM_PATTERN = Pattern.compile("^\\s*(\\d+) wakeup alarms$");

    @Override
    public ProcessUsageItem parse(List<String> lines) {
        String processUid = null;
        int alarmWakeups = 0;
        for (String line : lines) {
            Matcher m = UID_PATTERN.matcher(line);
            if (m.matches()) {
                if (processUid != null) {
                    this.mItem.addProcessUsage(processUid, alarmWakeups, this.mSensorUsage);
                }
                processUid = m.group(1);
                this.mSensorUsage = new LinkedList();
                continue;
            }
            m = SENSOR_PATTERN.matcher(line);
            if (m.matches()) {
                long duration = NumberFormattingUtil.getMs(NumberFormattingUtil.parseIntOrZero(m.group(2)), NumberFormattingUtil.parseIntOrZero(m.group(3)), NumberFormattingUtil.parseIntOrZero(m.group(4)), NumberFormattingUtil.parseIntOrZero(m.group(5)), NumberFormattingUtil.parseIntOrZero(m.group(6)));
                this.mSensorUsage.add(new ProcessUsageItem.SensorInfoItem(m.group(1), duration));
                continue;
            }
            m = ALARM_PATTERN.matcher(line);
            if (!m.matches()) continue;
            alarmWakeups = Integer.parseInt(m.group(1));
        }
        if (processUid != null) {
            this.mItem.addProcessUsage(processUid, alarmWakeups, this.mSensorUsage);
        }
        return this.mItem;
    }

    ProcessUsageItem getItem() {
        return this.mItem;
    }
}

