/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.IItem;
import com.android.loganalysis.item.LogcatItem;
import com.android.loganalysis.item.MiscLogcatItem;
import com.android.loganalysis.parser.AnrParser;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.parser.JavaCrashParser;
import com.android.loganalysis.parser.NativeCrashParser;
import com.android.loganalysis.util.ArrayUtil;
import com.android.loganalysis.util.LogPatternUtil;
import com.android.loganalysis.util.LogTailUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogcatParser
implements IParser {
    public static final String ANR = "ANR";
    public static final String JAVA_CRASH = "JAVA_CRASH";
    public static final String NATIVE_CRASH = "NATIVE_CRASH";
    public static final String HIGH_CPU_USAGE = "HIGH_CPU_USAGE";
    public static final String HIGH_MEMORY_USAGE = "HIGH_MEMORY_USAGE";
    public static final String RUNTIME_RESTART = "RUNTIME_RESTART";
    private static final Pattern THREADTIME_LINE = Pattern.compile("^(\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3})(?:\\s+[0-9A-Za-z]+)?\\s+(\\d+)\\s+(\\d+)\\s+([A-Z])\\s+(.+?)\\s*: (.*)$");
    private static final Pattern TIME_LINE = Pattern.compile("^(\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}.\\d{3})\\s+(\\w)/(.+?)\\(\\s*(\\d+)\\): (.*)$");
    private static final Pattern SYSTEM_SERVER_CRASH = Pattern.compile("\\*\\*\\* FATAL EXCEPTION IN SYSTEM PROCESS:.*");
    private static final Pattern JAVA_CRASH_PROCESS_PID = Pattern.compile("^(Process: (\\S+), )?PID: (\\d+)$");
    private static final Pattern JAVA_PROC_START = Pattern.compile("Calling main entry (.+)");
    private LogPatternUtil mPatternUtil = new LogPatternUtil();
    private LogTailUtil mPreambleUtil = new LogTailUtil();
    private String mYear = null;
    LogcatItem mLogcat = null;
    Map<String, LogcatData> mDataMap = new HashMap<String, LogcatData>();
    List<LogcatData> mDataList = new LinkedList<LogcatData>();
    private Date mStartTime = null;
    private Date mStopTime = null;
    private boolean mIsParsing = true;
    private Map<Integer, String> mPids = new HashMap<Integer, String>();
    private List<CrashTag> mJavaCrashTags = new ArrayList<CrashTag>();
    private List<CrashTag> mNativeCrashTags = new ArrayList<CrashTag>();

    public LogcatParser() {
        this.addJavaCrashTag("E", "AndroidRuntime", JAVA_CRASH);
        this.addNativeCrashTag("I", "DEBUG");
        this.addNativeCrashTag("F", "DEBUG");
        this.initPatterns();
    }

    public LogcatParser(String year) {
        this();
        this.setYear(year);
    }

    public void setYear(String year) {
        this.mYear = year;
    }

    public LogcatItem parse(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            this.parseLine(line);
        }
        this.commit();
        return this.mLogcat;
    }

    @Override
    public LogcatItem parse(List<String> lines) {
        for (String line : lines) {
            this.parseLine(line);
        }
        this.commit();
        return this.mLogcat;
    }

    public void clear() {
        this.mLogcat = null;
        this.mDataList.clear();
        this.mDataMap.clear();
    }

    private void parseLine(String line) {
        LogcatData data;
        String key;
        if ("".equals(line.trim())) {
            return;
        }
        if (this.mLogcat == null) {
            this.mLogcat = new LogcatItem();
        }
        Integer pid = null;
        Integer tid = null;
        Date time = null;
        String level = null;
        String tag = null;
        String msg = null;
        Matcher m = THREADTIME_LINE.matcher(line);
        Matcher tm = TIME_LINE.matcher(line);
        if (m.matches()) {
            time = this.parseTime(m.group(1));
            pid = Integer.parseInt(m.group(2));
            tid = Integer.parseInt(m.group(3));
            level = m.group(4);
            tag = m.group(5);
            msg = m.group(6);
        } else if (tm.matches()) {
            time = this.parseTime(tm.group(1));
            level = tm.group(2);
            tag = tm.group(3);
            pid = Integer.parseInt(tm.group(4));
            msg = tm.group(5);
        }
        if (time != null) {
            if (this.mStartTime == null) {
                this.mStartTime = time;
            }
            this.mStopTime = time;
        }
        if ("I".equals(level) && "ShutdownThread".equals(tag) && Pattern.matches("Rebooting, reason: .*", msg)) {
            this.mIsParsing = false;
        }
        if (Pattern.matches(".*--------- beginning of .*", line)) {
            this.mIsParsing = true;
        }
        if (!this.mIsParsing || !m.matches() && !tm.matches()) {
            return;
        }
        Matcher pidMatcher = JAVA_PROC_START.matcher(msg);
        if (pidMatcher.matches()) {
            String name = pidMatcher.group(1);
            this.mPids.put(pid, name);
        }
        if ("E".equals(level) && "ActivityManager".equals(tag)) {
            key = LogcatParser.encodeLine(pid, tid, level, tag);
            if (!this.mDataMap.containsKey(key) || AnrParser.START.matcher(msg).matches()) {
                data = new LogcatData(pid, tid, time, level, tag, this.mPreambleUtil.getLastTail(), this.mPreambleUtil.getIdTail(pid));
                this.mDataMap.put(key, data);
                this.mDataList.add(data);
            } else {
                data = this.mDataMap.get(key);
            }
            data.mLines.add(msg);
        }
        if (this.anyNativeCrashTagMatches(level, tag)) {
            key = LogcatParser.encodeLine(pid, tid, level, tag);
            if (!this.mDataMap.containsKey(key) || NativeCrashParser.FINGERPRINT.matcher(msg).matches()) {
                data = new LogcatData(pid, tid, time, level, tag, this.mPreambleUtil.getLastTail(), this.mPreambleUtil.getIdTail(pid));
                this.mDataMap.put(key, data);
                this.mDataList.add(data);
            } else {
                data = this.mDataMap.get(key);
            }
            data.mLines.add(msg);
        }
        if (this.anyJavaCrashTagMatches(level, tag)) {
            key = LogcatParser.encodeLine(pid, tid, level, tag);
            if (!this.mDataMap.containsKey(key)) {
                data = new LogcatData(pid, tid, time, level, tag, this.mPreambleUtil.getLastTail(), this.mPreambleUtil.getIdTail(pid));
                this.mDataMap.put(key, data);
                this.mDataList.add(data);
            } else {
                data = this.mDataMap.get(key);
            }
            data.mLines.add(msg);
        }
        if (this.mPatternUtil.checkMessage(msg, new ExtrasPattern(level, tag)) != null) {
            LogcatData data2 = new LogcatData(pid, tid, time, level, tag, this.mPreambleUtil.getLastTail(), this.mPreambleUtil.getIdTail(pid));
            data2.mLines.add(msg);
            this.mDataList.add(data2);
        }
        this.mPreambleUtil.addLine(pid, line);
    }

    private void commit() {
        if (this.mLogcat == null) {
            return;
        }
        for (LogcatData data : this.mDataList) {
            IItem item = null;
            if ("E".equals(data.mLevel) && "ActivityManager".equals(data.mTag)) {
                item = new AnrParser().parse((List)data.mLines);
            } else if (this.anyJavaCrashTagMatches(data.mLevel, data.mTag)) {
                Integer pid = null;
                String app = null;
                for (int i = 0; i < data.mLines.size(); ++i) {
                    String line = data.mLines.get(i);
                    Matcher m = JAVA_CRASH_PROCESS_PID.matcher(line);
                    if (m.matches()) {
                        app = m.group(2);
                        pid = Integer.valueOf(m.group(3));
                        data.mLines = data.mLines.subList(i + 1, data.mLines.size());
                        break;
                    }
                    m = SYSTEM_SERVER_CRASH.matcher(line);
                    if (!m.matches()) continue;
                    app = this.mPids.get(data.mPid);
                    if (app == null) {
                        app = "system_server";
                    }
                    data.mLines = data.mLines.subList(i + 1, data.mLines.size());
                    break;
                }
                if ((item = new JavaCrashParser().parse((List)data.mLines)) != null) {
                    ((MiscLogcatItem)item).setApp(app);
                    ((MiscLogcatItem)item).setPid(pid);
                    ((MiscLogcatItem)item).setCategory(this.getJavaCrashCategory(data.mLevel, data.mTag));
                }
            } else if (this.anyNativeCrashTagMatches(data.mLevel, data.mTag)) {
                item = new NativeCrashParser().parse((List)data.mLines);
            } else {
                String msg = ArrayUtil.join("\n", data.mLines);
                String category = this.mPatternUtil.checkMessage(msg, new ExtrasPattern(data.mLevel, data.mTag));
                if (category != null) {
                    MiscLogcatItem logcatItem = new MiscLogcatItem();
                    logcatItem.setCategory(category);
                    logcatItem.setStack(msg);
                    item = logcatItem;
                }
            }
            if (item == null) continue;
            ((MiscLogcatItem)item).setEventTime(data.mTime);
            if (((MiscLogcatItem)item).getPid() == null) {
                ((MiscLogcatItem)item).setPid(data.mPid);
                ((MiscLogcatItem)item).setTid(data.mTid);
            }
            ((MiscLogcatItem)item).setLastPreamble(data.mLastPreamble);
            ((MiscLogcatItem)item).setProcessPreamble(data.mProcPreamble);
            ((MiscLogcatItem)item).setTag(data.mTag);
            this.mLogcat.addEvent((MiscLogcatItem)item);
        }
        this.mLogcat.setStartTime(this.mStartTime);
        this.mLogcat.setStopTime(this.mStopTime);
    }

    private static String encodeLine(Integer pid, Integer tid, String level, String tag) {
        if (tid == null) {
            return String.format("%d|%s|%s", pid, level, tag);
        }
        return String.format("%d|%d|%s|%s", pid, tid, level, tag);
    }

    private Date parseTime(String timeStr) {
        if (this.mYear == null) {
            SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");
            this.mYear = yearFormatter.format(new Date());
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        try {
            return formatter.parse(String.format("%s-%s", this.mYear, timeStr));
        }
        catch (ParseException e) {
            return null;
        }
    }

    private void initPatterns() {
        this.mPatternUtil.addPattern(Pattern.compile(".* timed out \\(is the CPU pegged\\?\\).*"), HIGH_CPU_USAGE);
        this.mPatternUtil.addPattern(Pattern.compile("GetBufferLock timed out for thread \\d+ buffer .*"), HIGH_MEMORY_USAGE);
        this.mPatternUtil.addPattern(Pattern.compile("\\*\\*\\* WATCHDOG KILLING SYSTEM PROCESS.*"), RUNTIME_RESTART);
    }

    public void addPattern(Pattern pattern, String level, String tag, String category) {
        if (pattern == null) {
            pattern = Pattern.compile(".*");
        }
        this.mPatternUtil.addPattern(pattern, new ExtrasPattern(level, tag), category);
    }

    public void addJavaCrashTag(String level, String tag, String category) {
        this.mJavaCrashTags.add(new CrashTag(level, tag, category));
    }

    private void addNativeCrashTag(String level, String tag) {
        this.mNativeCrashTags.add(new CrashTag(level, tag, NATIVE_CRASH));
    }

    private boolean anyJavaCrashTagMatches(String level, String tag) {
        return this.findCrashTag(this.mJavaCrashTags, level, tag) != null;
    }

    private boolean anyNativeCrashTagMatches(String level, String tag) {
        return this.findCrashTag(this.mNativeCrashTags, level, tag) != null;
    }

    private CrashTag findCrashTag(List<CrashTag> crashTags, String level, String tag) {
        for (CrashTag t : crashTags) {
            if (!t.matches(level, tag)) continue;
            return t;
        }
        return null;
    }

    private String getJavaCrashCategory(String level, String tag) {
        CrashTag crashTag = this.findCrashTag(this.mJavaCrashTags, level, tag);
        if (crashTag == null) {
            return JAVA_CRASH;
        }
        return crashTag.getCategory();
    }

    private class CrashTag {
        private String mLevel;
        private String mTag;
        private String mCategory;

        public CrashTag(String level, String tag, String category) {
            this.mLevel = level;
            this.mTag = tag;
            this.mCategory = category;
        }

        public boolean matches(String level, String tag) {
            return this.mLevel.equals(level) && this.mTag.equals(tag);
        }

        public String getCategory() {
            return this.mCategory;
        }
    }

    private class ExtrasPattern {
        public String mLevel;
        public String mTag;

        public ExtrasPattern(String level, String tag) {
            this.mLevel = level;
            this.mTag = tag;
        }

        public boolean equals(Object otherObj) {
            if (otherObj instanceof ExtrasPattern) {
                ExtrasPattern other = (ExtrasPattern)otherObj;
                if ((this.mLevel == null || other.mLevel == null || this.mLevel.equals(other.mLevel)) && (this.mTag == null || other.mTag == null || this.mTag.equals(other.mTag))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return 145800969;
        }
    }

    private class LogcatData {
        public Integer mPid = null;
        public Integer mTid = null;
        public Date mTime = null;
        public String mLevel = null;
        public String mTag = null;
        public String mLastPreamble = null;
        public String mProcPreamble = null;
        public List<String> mLines = new LinkedList<String>();

        public LogcatData(Integer pid, Integer tid, Date time, String level, String tag, String lastPreamble, String procPreamble) {
            this.mPid = pid;
            this.mTid = tid;
            this.mTime = time;
            this.mLevel = level;
            this.mTag = tag;
            this.mLastPreamble = lastPreamble;
            this.mProcPreamble = procPreamble;
        }
    }
}

