/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.KernelLogItem;
import com.android.loganalysis.item.LowMemoryKillerItem;
import com.android.loganalysis.item.MiscKernelLogItem;
import com.android.loganalysis.item.PageAllocationFailureItem;
import com.android.loganalysis.item.SELinuxItem;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.util.LogPatternUtil;
import com.android.loganalysis.util.LogTailUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KernelLogParser
implements IParser {
    public static final String KERNEL_RESET = "KERNEL_RESET";
    public static final String KERNEL_ERROR = "KERNEL_ERROR";
    public static final String SELINUX_DENIAL = "SELINUX_DENIAL";
    public static final String NORMAL_REBOOT = "NORMAL_REBOOT";
    public static final String PAGE_ALLOC_FAILURE = "PAGE_ALLOC_FAILURE";
    public static final String LOW_MEMORY_KILLER = "LOW_MEMORY_KILLER";
    private static final Pattern LOG_LINE = Pattern.compile("^(<\\d+>)?\\[\\s*(\\d+\\.\\d{6})\\] (.*)$");
    private static final Pattern SELINUX_DENIAL_PATTERN = Pattern.compile(".*avc:\\s.*scontext=\\w*:\\w*:([\\w\\s]*):\\w*\\s.*");
    private static final Pattern PAGE_ALLOC_FAILURE_PATTERN = Pattern.compile(".*page\\s+allocation\\s+failure:\\s+order:(\\d+).*");
    private static final Pattern LOW_MEMORY_KILLER_PATTERN = Pattern.compile(".*Killing\\s+'(.*)'\\s+\\((\\d+)\\),.*adj\\s+(\\d+).*");
    public static final Pattern BAD_BOOTREASONS = Pattern.compile("(?:kernel_panic.*|rpm_err|hw_reset(?:$|\\n)|wdog_.*|tz_err|adsp_err|modem_err|mba_err|watchdog.*|Watchdog|Panic|srto:.*|oemerr.*)");
    public static final Pattern GOOD_BOOTREASONS = Pattern.compile("(?:PowerKey|normal|recovery|reboot.*)");
    private boolean mAddUnknownBootreason = true;
    private KernelLogItem mKernelLog = null;
    private Double mStartTime = null;
    private Double mStopTime = null;
    private LogPatternUtil mPatternUtil = new LogPatternUtil();
    private LogTailUtil mPreambleUtil = new LogTailUtil(500, 50, 50);
    private boolean mBootreasonFound = false;

    public KernelLogParser() {
        this.initPatterns();
    }

    public void setAddUnknownBootreason(boolean enable) {
        this.mAddUnknownBootreason = enable;
    }

    public KernelLogItem parse(BufferedReader input) throws IOException {
        String line;
        while ((line = input.readLine()) != null) {
            this.parseLine(line);
        }
        this.commit();
        return this.mKernelLog;
    }

    @Override
    public KernelLogItem parse(List<String> lines) {
        this.mBootreasonFound = false;
        for (String line : lines) {
            this.parseLine(line);
        }
        this.commit();
        return this.mKernelLog;
    }

    private void parseLine(String line) {
        Matcher m;
        if ("".equals(line.trim())) {
            return;
        }
        if (this.mKernelLog == null) {
            this.mKernelLog = new KernelLogItem();
        }
        if ((m = LOG_LINE.matcher(line)).matches()) {
            Double time = Double.parseDouble(m.group(2));
            String msg = m.group(3);
            if (this.mStartTime == null) {
                this.mStartTime = time;
            }
            this.mStopTime = time;
            this.checkAndAddKernelEvent(msg);
            this.mPreambleUtil.addLine(null, line);
        } else {
            this.checkAndAddKernelEvent(line);
        }
    }

    private void checkAndAddKernelEvent(String message) {
        MiscKernelLogItem kernelLogItem;
        String category = this.mPatternUtil.checkMessage(message);
        if (category == null) {
            return;
        }
        if (category.equals(KERNEL_RESET) || category.equals(NORMAL_REBOOT)) {
            this.mBootreasonFound = true;
        }
        if (category.equals(NORMAL_REBOOT)) {
            return;
        }
        if (category.equals(SELINUX_DENIAL)) {
            SELinuxItem selinuxItem = new SELinuxItem();
            Matcher m = SELINUX_DENIAL_PATTERN.matcher(message);
            if (m.matches()) {
                selinuxItem.setSContext(m.group(1));
            }
            kernelLogItem = selinuxItem;
        } else if (category.equals(PAGE_ALLOC_FAILURE)) {
            PageAllocationFailureItem allocItem = new PageAllocationFailureItem();
            Matcher m = PAGE_ALLOC_FAILURE_PATTERN.matcher(message);
            if (m.matches()) {
                allocItem.setOrder(Integer.parseInt(m.group(1)));
            }
            kernelLogItem = allocItem;
        } else if (category.equals(LOW_MEMORY_KILLER)) {
            LowMemoryKillerItem lmkItem = new LowMemoryKillerItem();
            Matcher m = LOW_MEMORY_KILLER_PATTERN.matcher(message);
            if (m.matches()) {
                lmkItem.setProcessName(m.group(1));
                lmkItem.setPid(Integer.parseInt(m.group(2)));
                lmkItem.setAdjustment(Integer.parseInt(m.group(3)));
            }
            kernelLogItem = lmkItem;
        } else {
            kernelLogItem = new MiscKernelLogItem();
        }
        kernelLogItem.setEventTime(this.mStopTime);
        kernelLogItem.setPreamble(this.mPreambleUtil.getLastTail());
        kernelLogItem.setStack(message);
        kernelLogItem.setCategory(category);
        this.mKernelLog.addEvent(kernelLogItem);
    }

    private void commit() {
        if (this.mKernelLog == null) {
            return;
        }
        this.mKernelLog.setStartTime(this.mStartTime);
        this.mKernelLog.setStopTime(this.mStopTime);
        if (this.mAddUnknownBootreason && !this.mBootreasonFound) {
            MiscKernelLogItem unknownReset = new MiscKernelLogItem();
            unknownReset.setEventTime(this.mStopTime);
            unknownReset.setPreamble(this.mPreambleUtil.getLastTail());
            unknownReset.setCategory(KERNEL_RESET);
            unknownReset.setStack("Unknown reason");
            this.mKernelLog.addEvent(unknownReset);
        }
    }

    private void initPatterns() {
        String[] kernelResets = new String[]{"smem: DIAG.*", "smsm: AMSS FATAL ERROR.*", "kernel BUG at .*", "BUG: failure at .*", "PVR_K:\\(Fatal\\): Debug assertion failed! \\[.*\\]", "Kernel panic.*", "Unable to handle kernel paging request.*", "BP panicked", "WROTE DSP RAMDUMP", "tegra_wdt: last reset due to watchdog timeout.*", "tegra_wdt tegra_wdt.0: last reset is due to watchdog timeout.*", "Last reset was MPU Watchdog Timer reset.*", "\\[MODEM_IF\\].*CRASH.*", "Last boot reason: " + BAD_BOOTREASONS, "Last reset was system watchdog timer reset.*"};
        String[] goodSignatures = new String[]{"Restarting system.*", "Power down.*", "Last boot reason: " + GOOD_BOOTREASONS};
        for (String pattern : kernelResets) {
            this.mPatternUtil.addPattern(Pattern.compile(pattern), KERNEL_RESET);
        }
        for (String pattern : goodSignatures) {
            this.mPatternUtil.addPattern(Pattern.compile(pattern), NORMAL_REBOOT);
        }
        this.mPatternUtil.addPattern(Pattern.compile("Internal error:.*"), KERNEL_ERROR);
        this.mPatternUtil.addPattern(SELINUX_DENIAL_PATTERN, SELINUX_DENIAL);
        this.mPatternUtil.addPattern(PAGE_ALLOC_FAILURE_PATTERN, PAGE_ALLOC_FAILURE);
        this.mPatternUtil.addPattern(LOW_MEMORY_KILLER_PATTERN, LOW_MEMORY_KILLER);
    }

    LogPatternUtil getLogPatternUtil() {
        return this.mPatternUtil;
    }
}

