/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.JavaCrashItem;
import com.android.loganalysis.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaCrashParser
implements IParser {
    private static final Pattern EXCEPTION = Pattern.compile("^([^\\s:]+)(: (.*))?$");
    private static final Pattern CAUSEDBY = Pattern.compile("^Caused by: .+$");
    private static final Pattern AT = Pattern.compile("^\tat .+$");
    private static final String BEGIN_MARKER = "----- begin exception -----";
    private static final String END_MARKER = "----- end exception -----";

    @Override
    public JavaCrashItem parse(List<String> lines) {
        JavaCrashItem jc = null;
        StringBuilder stack = new StringBuilder();
        StringBuilder message = new StringBuilder();
        boolean inMessage = false;
        boolean inCausedBy = false;
        boolean inStack = false;
        for (String line : lines) {
            if (line.contains(BEGIN_MARKER)) {
                inMessage = false;
                inCausedBy = false;
                inStack = false;
                stack = new StringBuilder();
                message = new StringBuilder();
                jc = null;
                continue;
            }
            if (line.contains(END_MARKER)) break;
            if (!inStack) {
                Matcher exceptionMatch = EXCEPTION.matcher(line);
                if (exceptionMatch.matches()) {
                    inMessage = true;
                    inStack = true;
                    jc = new JavaCrashItem();
                    jc.setException(exceptionMatch.group(1));
                    if (exceptionMatch.group(3) != null) {
                        message.append(exceptionMatch.group(3));
                    }
                }
            } else {
                Matcher atMatch;
                Matcher causedByMatch = CAUSEDBY.matcher(line);
                if (causedByMatch.matches()) {
                    inMessage = false;
                    inCausedBy = true;
                }
                if ((atMatch = AT.matcher(line)).matches()) {
                    inMessage = false;
                    inCausedBy = false;
                }
                if (!causedByMatch.matches() && !atMatch.matches()) {
                    if (inMessage) {
                        message.append("\n");
                        message.append(line);
                    }
                    if (!inMessage && !inCausedBy) {
                        this.addMessageStack(jc, message.toString(), stack.toString());
                        return jc;
                    }
                }
            }
            if (!inStack) continue;
            stack.append(line);
            stack.append("\n");
        }
        this.addMessageStack(jc, message.toString(), stack.toString());
        return jc;
    }

    private void addMessageStack(JavaCrashItem jc, String message, String stack) {
        if (jc != null) {
            if (message.length() > 0) {
                jc.setMessage(message);
            }
            jc.setStack(stack.trim());
        }
    }
}

