/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.DmesgActionInfoItem;
import com.android.loganalysis.item.DmesgItem;
import com.android.loganalysis.item.DmesgServiceInfoItem;
import com.android.loganalysis.item.DmesgStageInfoItem;
import com.android.loganalysis.parser.IParser;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DmesgParser
implements IParser {
    private static final String SERVICENAME = "SERVICENAME";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String STAGE = "STAGE";
    private static final String ACTION = "ACTION";
    private static final String SOURCE = "SOURCE";
    private static final String DURATION = "DURATION";
    private static final String UEVENTD = "ueventd";
    private static final String INIT = "init";
    private static final String SERVICE_PREFIX = String.format("^\\[\\s+(?<%s>.*)\\] init:\\s+", "TIMESTAMP");
    private static final String UEVENTD_PREFIX = String.format("^\\[\\s+(?<%s>.*)\\] ueventd:\\s+", "TIMESTAMP");
    private static final String START_SERVICE_SUFFIX = String.format("starting service \\'(?<%s>.*)\\'...", "SERVICENAME");
    private static final String EXIT_SERVICE_SUFFIX = String.format("Service \\'(?<%s>.*)\\'\\s+\\((?<PID>.*)\\) exited with status 0.*", "SERVICENAME");
    private static final Pattern START_SERVICE = Pattern.compile(String.format("%s%s", SERVICE_PREFIX, START_SERVICE_SUFFIX));
    private static final Pattern EXIT_SERVICE = Pattern.compile(String.format("%s%s", SERVICE_PREFIX, EXIT_SERVICE_SUFFIX));
    private static final String START_STAGE_PREFIX = String.format("init (?<%s>.*) stage started!", "STAGE");
    private static final Pattern START_STAGE = Pattern.compile(String.format("%s%s", SERVICE_PREFIX, START_STAGE_PREFIX));
    private static final String START_PROCESSING_ACTION_PREFIX = String.format("processing action \\((?<%s>[^)]*)\\)( from \\((?<%s>.*)\\)|.*)$", "ACTION", "SOURCE");
    private static final Pattern START_PROCESSING_ACTION = Pattern.compile(String.format("%s%s", SERVICE_PREFIX, START_PROCESSING_ACTION_PREFIX));
    private static final String STAGE_SUFFIX = String.format("(?<%s>.*)\\s+took\\s+(?<%s>.*)\\s+seconds$", "STAGE", "DURATION");
    private static final Pattern UEVENTD_STAGE_INFO = Pattern.compile(String.format("%s%s", UEVENTD_PREFIX, STAGE_SUFFIX));
    private static final String PROPERTY_SUFFIX = String.format("(?<%s>.*)\\s+took\\s+(?<%s>.*)ms$", "STAGE", "DURATION");
    private static final Pattern WAIT_FOR_PROPERTY_INFO = Pattern.compile(String.format("%s%s", SERVICE_PREFIX, PROPERTY_SUFFIX));
    private DmesgItem mDmesgItem = new DmesgItem();

    @Override
    public DmesgItem parse(List<String> lines) {
        for (String line : lines) {
            this.parse(line);
        }
        return this.mDmesgItem;
    }

    public DmesgItem parseInfo(BufferedReader bufferedLog) throws IOException {
        String line;
        while ((line = bufferedLog.readLine()) != null) {
            this.parse(line);
        }
        return this.mDmesgItem;
    }

    private void parse(String line) {
        if (this.parseServiceInfo(line)) {
            return;
        }
        if (this.parseStageInfo(line)) {
            return;
        }
        if (this.parseActionInfo(line)) {
            return;
        }
    }

    @VisibleForTesting
    boolean parseServiceInfo(String line) {
        Matcher match = null;
        match = DmesgParser.matches(START_SERVICE, line);
        if (match != null) {
            DmesgServiceInfoItem serviceItem = new DmesgServiceInfoItem();
            serviceItem.setServiceName(match.group(SERVICENAME));
            serviceItem.setStartTime((long)(Double.parseDouble(match.group(TIMESTAMP)) * 1000.0));
            this.getServiceInfoItems().put(match.group(SERVICENAME), serviceItem);
            return true;
        }
        match = DmesgParser.matches(EXIT_SERVICE, line);
        if (match != null) {
            if (this.getServiceInfoItems().containsKey(match.group(SERVICENAME))) {
                DmesgServiceInfoItem serviceItem = this.getServiceInfoItems().get(match.group(SERVICENAME));
                serviceItem.setEndTime((long)(Double.parseDouble(match.group(TIMESTAMP)) * 1000.0));
            }
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean parseStageInfo(String line) {
        Matcher match = null;
        match = DmesgParser.matches(START_STAGE, line);
        if (match != null) {
            DmesgStageInfoItem stageInfoItem = new DmesgStageInfoItem();
            stageInfoItem.setStageName(match.group(STAGE));
            stageInfoItem.setStartTime((long)(Double.parseDouble(match.group(TIMESTAMP)) * 1000.0));
            this.mDmesgItem.addStageInfoItem(stageInfoItem);
            return true;
        }
        match = DmesgParser.matches(UEVENTD_STAGE_INFO, line);
        if (match != null) {
            DmesgStageInfoItem stageInfoItem = new DmesgStageInfoItem();
            stageInfoItem.setStageName(String.format("%s_%s", UEVENTD, match.group(STAGE)));
            stageInfoItem.setDuration((long)(Double.parseDouble(match.group(DURATION)) * 1000.0));
            this.mDmesgItem.addStageInfoItem(stageInfoItem);
            return true;
        }
        match = DmesgParser.matches(WAIT_FOR_PROPERTY_INFO, line);
        if (match != null) {
            DmesgStageInfoItem stageInfoItem = new DmesgStageInfoItem();
            stageInfoItem.setStageName(String.format("%s_%s", INIT, match.group(STAGE)));
            stageInfoItem.setDuration((long)Double.parseDouble(match.group(DURATION)));
            this.mDmesgItem.addStageInfoItem(stageInfoItem);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean parseActionInfo(String line) {
        Matcher match = null;
        match = DmesgParser.matches(START_PROCESSING_ACTION, line);
        if (match != null) {
            DmesgActionInfoItem actionInfoItem = new DmesgActionInfoItem();
            if (match.group(SOURCE) != null) {
                actionInfoItem.setSourceName(match.group(SOURCE));
            }
            actionInfoItem.setActionName(match.group(ACTION));
            actionInfoItem.setStartTime((long)(Double.parseDouble(match.group(TIMESTAMP)) * 1000.0));
            this.mDmesgItem.addActionInfoItem(actionInfoItem);
            return true;
        }
        return false;
    }

    private static Matcher matches(Pattern pattern, String line) {
        Matcher ret = pattern.matcher(line);
        return ret.matches() ? ret : null;
    }

    public Map<String, DmesgServiceInfoItem> getServiceInfoItems() {
        return this.mDmesgItem.getServiceInfoItems();
    }

    public void setServiceInfoItems(Map<String, DmesgServiceInfoItem> serviceInfoItems) {
        for (String key : serviceInfoItems.keySet()) {
            this.mDmesgItem.addServiceInfoItem(key, serviceInfoItems.get(key));
        }
    }

    public List<DmesgStageInfoItem> getStageInfoItems() {
        return this.mDmesgItem.getStageInfoItems();
    }

    public List<DmesgActionInfoItem> getActionInfoItems() {
        return this.mDmesgItem.getActionInfoItems();
    }
}

