/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.parser;

import com.android.loganalysis.item.BatteryStatsDetailedInfoItem;
import com.android.loganalysis.item.BatteryUsageItem;
import com.android.loganalysis.item.InterruptItem;
import com.android.loganalysis.item.ProcessUsageItem;
import com.android.loganalysis.item.WakelockItem;
import com.android.loganalysis.parser.AbstractSectionParser;
import com.android.loganalysis.parser.BatteryUsageParser;
import com.android.loganalysis.parser.IParser;
import com.android.loganalysis.parser.InterruptParser;
import com.android.loganalysis.parser.ProcessUsageParser;
import com.android.loganalysis.parser.WakelockParser;
import com.android.loganalysis.util.NumberFormattingUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatteryStatsDetailedInfoParser
extends AbstractSectionParser {
    private static final String BATTERY_USAGE_SECTION_REGEX = "^\\s*Estimated power use \\(mAh\\):$";
    private static final String KERNEL_WAKELOCK_SECTION_REGEX = "^\\s*All kernel wake locks:$";
    private static final String PARTIAL_WAKELOCK_SECTION_REGEX = "^\\s*All partial wake locks:$";
    private static final String INTERRUPT_SECTION_REGEX = "^\\s*All wakeup reasons:$";
    private static final String PROCESS_USAGE_SECTION_REGEX = "^\\s*0:$";
    private static final Pattern TIME_ON_BATTERY_PATTERN = Pattern.compile("^\\s*Time on battery: (?:(\\d+)d)?\\s?(?:(\\d+)h)?\\s?(?:(\\d+)m)?\\s?(?:(\\d+)s)?\\s?(?:(\\d+)ms)?.*");
    private static final Pattern SCREEN_OFF_TIME_PATTERN = Pattern.compile("^\\s*Time on battery screen off: (?:(\\d+)d)?\\s?(?:(\\d+)h)?\\s?(?:(\\d+)m)?\\s?(?:(\\d+)s)?\\s?(?:(\\d+)ms).*");
    private BatteryUsageParser mBatteryUsageParser = new BatteryUsageParser();
    private WakelockParser mWakelockParser = new WakelockParser();
    private InterruptParser mInterruptParser = new InterruptParser();
    private ProcessUsageParser mProcessUsageParser = new ProcessUsageParser();
    private IParser mBatteryTimeParser = new IParser(){

        @Override
        public BatteryStatsDetailedInfoItem parse(List<String> lines) {
            BatteryStatsDetailedInfoItem detailedInfo = null;
            long timeOnBattery = 0L;
            long screenOffTime = 0L;
            Matcher m = null;
            for (String line : lines) {
                if (detailedInfo == null && !"".equals(line.trim())) {
                    detailedInfo = new BatteryStatsDetailedInfoItem();
                }
                if ((m = TIME_ON_BATTERY_PATTERN.matcher(line)).matches()) {
                    timeOnBattery = NumberFormattingUtil.getMs(NumberFormattingUtil.parseIntOrZero(m.group(1)), NumberFormattingUtil.parseIntOrZero(m.group(2)), NumberFormattingUtil.parseIntOrZero(m.group(3)), NumberFormattingUtil.parseIntOrZero(m.group(4)), NumberFormattingUtil.parseIntOrZero(m.group(5)));
                    detailedInfo.setTimeOnBattery(timeOnBattery);
                    continue;
                }
                m = SCREEN_OFF_TIME_PATTERN.matcher(line);
                if (!m.matches()) continue;
                screenOffTime = NumberFormattingUtil.getMs(NumberFormattingUtil.parseIntOrZero(m.group(1)), NumberFormattingUtil.parseIntOrZero(m.group(2)), NumberFormattingUtil.parseIntOrZero(m.group(3)), NumberFormattingUtil.parseIntOrZero(m.group(4)), NumberFormattingUtil.parseIntOrZero(m.group(5)));
                detailedInfo.setScreenOnTime(this.getScreenOnTime(timeOnBattery, screenOffTime));
                return detailedInfo;
            }
            return detailedInfo;
        }

        private long getScreenOnTime(long timeOnBattery, long screenOffTime) {
            if (timeOnBattery > screenOffTime) {
                return timeOnBattery - screenOffTime;
            }
            return 0L;
        }
    };
    private BatteryStatsDetailedInfoItem mBatteryStatsDetailedInfoItem = null;
    private boolean mParsedInput = false;

    @Override
    public BatteryStatsDetailedInfoItem parse(List<String> lines) {
        this.setup();
        for (String line : lines) {
            if (!this.mParsedInput && !"".equals(line.trim())) {
                this.mParsedInput = true;
            }
            this.parseLine(line);
        }
        this.commit();
        return this.mBatteryStatsDetailedInfoItem;
    }

    protected void setup() {
        this.setParser(this.mBatteryTimeParser);
        this.addSectionParser(this.mBatteryUsageParser, BATTERY_USAGE_SECTION_REGEX);
        this.addSectionParser(this.mWakelockParser, KERNEL_WAKELOCK_SECTION_REGEX);
        this.addSectionParser(this.mWakelockParser, PARTIAL_WAKELOCK_SECTION_REGEX);
        this.addSectionParser(this.mInterruptParser, INTERRUPT_SECTION_REGEX);
        this.addSectionParser(this.mProcessUsageParser, PROCESS_USAGE_SECTION_REGEX);
    }

    @Override
    protected void onSwitchParser() {
        if (this.mBatteryStatsDetailedInfoItem == null) {
            this.mBatteryStatsDetailedInfoItem = (BatteryStatsDetailedInfoItem)this.getSection(this.mBatteryTimeParser);
        }
    }

    @Override
    protected void commit() {
        super.commit();
        if (this.mParsedInput && this.mBatteryStatsDetailedInfoItem == null) {
            this.mBatteryStatsDetailedInfoItem = new BatteryStatsDetailedInfoItem();
        }
        if (this.mBatteryStatsDetailedInfoItem != null) {
            this.mBatteryStatsDetailedInfoItem.setBatteryUsageItem((BatteryUsageItem)this.getSection(this.mBatteryUsageParser));
            this.mBatteryStatsDetailedInfoItem.setWakelockItem((WakelockItem)this.getSection(this.mWakelockParser));
            this.mBatteryStatsDetailedInfoItem.setInterruptItem((InterruptItem)this.getSection(this.mInterruptParser));
            this.mBatteryStatsDetailedInfoItem.setProcessUsageItem((ProcessUsageItem)this.getSection(this.mProcessUsageParser));
        }
    }
}

