/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.GenericItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SmartMonkeyLogItem
extends GenericItem {
    public static final String START_TIME = "START_TIME";
    public static final String STOP_TIME = "STOP_TIME";
    public static final String APPLICATIONS = "APPS";
    public static final String PACKAGES = "PACKAGES";
    public static final String THROTTLE = "THROTTLE";
    public static final String TARGET_INVOCATIONS = "TARGET_INVOCATIONS";
    public static final String TOTAL_DURATION = "TOTAL_TIME";
    public static final String START_UPTIME_DURATION = "START_UPTIME";
    public static final String STOP_UPTIME_DURATION = "STOP_UPTIME";
    public static final String IS_FINISHED = "IS_FINISHED";
    public static final String ABORTED = "ABORTED";
    public static final String INTERMEDIATE_COUNT = "INTERMEDIATE_COUNT";
    public static final String FINAL_COUNT = "FINAL_COUNT";
    public static final String ANR_TIMES = "ANR_TIMES";
    public static final String CRASH_TIMES = "CRASH_TIMES";
    public static final String INTERMEDIATE_TIME = "INTERMEDIATE_TIME";
    private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("START_TIME", "STOP_TIME", "PACKAGES", "THROTTLE", "TARGET_INVOCATIONS", "ABORTED", "TOTAL_TIME", "START_UPTIME", "STOP_UPTIME", "APPS", "IS_FINISHED", "INTERMEDIATE_COUNT", "FINAL_COUNT", "ANR_TIMES", "CRASH_TIMES", "INTERMEDIATE_TIME"));

    public SmartMonkeyLogItem() {
        super(ATTRIBUTES);
        this.setAttribute(APPLICATIONS, new ArrayList());
        this.setAttribute(PACKAGES, new ArrayList());
        this.setAttribute(CRASH_TIMES, new DateSet());
        this.setAttribute(ANR_TIMES, new DateSet());
        this.setAttribute(INTERMEDIATE_TIME, new DateSet());
        this.setAttribute(THROTTLE, 0);
        this.setAttribute(FINAL_COUNT, 0);
        this.setAttribute(IS_FINISHED, false);
        this.setAttribute(ABORTED, false);
        this.setAttribute(INTERMEDIATE_COUNT, 0);
        this.setAttribute(START_UPTIME_DURATION, 0L);
        this.setAttribute(STOP_UPTIME_DURATION, 0L);
    }

    public Date getStartTime() {
        return (Date)this.getAttribute(START_TIME);
    }

    public void setStartTime(Date time) {
        this.setAttribute(START_TIME, time);
    }

    public void setIntermediateTime(Date time) {
        this.setAttribute(INTERMEDIATE_TIME, time);
    }

    public Date getIntermediateTime() {
        return (Date)this.getAttribute(INTERMEDIATE_TIME);
    }

    public Date getStopTime() {
        return (Date)this.getAttribute(STOP_TIME);
    }

    public void setStopTime(Date time) {
        this.setAttribute(STOP_TIME, time);
    }

    public List<String> getPackages() {
        return (List)this.getAttribute(PACKAGES);
    }

    public void addPackage(String thePackage) {
        ((List)this.getAttribute(PACKAGES)).add(thePackage);
    }

    public List<String> getApplications() {
        return (List)this.getAttribute(APPLICATIONS);
    }

    public void addApplication(String theApp) {
        ((List)this.getAttribute(APPLICATIONS)).add(theApp);
    }

    public int getThrottle() {
        return (Integer)this.getAttribute(THROTTLE);
    }

    public void setThrottle(int throttle) {
        this.setAttribute(THROTTLE, throttle);
    }

    public int getTargetInvocations() {
        return (Integer)this.getAttribute(TARGET_INVOCATIONS);
    }

    public void setTargetInvocations(int count) {
        this.setAttribute(TARGET_INVOCATIONS, count);
    }

    public long getTotalDuration() {
        if (this.getIsFinished() || this.getIsAborted()) {
            return (Long)this.getAttribute(TOTAL_DURATION);
        }
        Date startTime = this.getStartTime();
        Date endTime = this.getIntermediateTime();
        return endTime.getTime() - startTime.getTime() / 1000L;
    }

    public void setTotalDuration(long time) {
        this.setAttribute(TOTAL_DURATION, time);
    }

    public long getStartUptimeDuration() {
        return (Long)this.getAttribute(START_UPTIME_DURATION);
    }

    public void setStartUptimeDuration(long uptime) {
        this.setAttribute(START_UPTIME_DURATION, uptime);
    }

    public long getStopUptimeDuration() {
        return (Long)this.getAttribute(STOP_UPTIME_DURATION);
    }

    public void setStopUptimeDuration(long uptime) {
        this.setAttribute(STOP_UPTIME_DURATION, uptime);
    }

    public boolean getIsFinished() {
        return (Boolean)this.getAttribute(IS_FINISHED);
    }

    public void setIsFinished(boolean finished) {
        this.setAttribute(IS_FINISHED, finished);
    }

    public int getIntermediateCount() {
        return (Integer)this.getAttribute(INTERMEDIATE_COUNT);
    }

    public void setIntermediateCount(int count) {
        this.setAttribute(INTERMEDIATE_COUNT, count);
    }

    public int getFinalCount() {
        if (this.getIsFinished()) {
            return (Integer)this.getAttribute(FINAL_COUNT);
        }
        return this.getIntermediateCount();
    }

    public void setFinalCount(int count) {
        this.setAttribute(FINAL_COUNT, count);
    }

    public Set<Date> getAnrTimes() {
        return (DateSet)this.getAttribute(ANR_TIMES);
    }

    public void addAnrTime(Date time) {
        ((DateSet)this.getAttribute(ANR_TIMES)).add(time);
    }

    public Set<Date> getCrashTimes() {
        return (DateSet)this.getAttribute(CRASH_TIMES);
    }

    public void addCrashTime(Date time) {
        ((DateSet)this.getAttribute(CRASH_TIMES)).add(time);
    }

    public boolean getIsAborted() {
        return (Boolean)this.getAttribute(ABORTED);
    }

    public void setIsAborted(boolean noSeq) {
        this.setAttribute(ABORTED, noSeq);
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = super.toJson();
        SmartMonkeyLogItem.put(object, APPLICATIONS, new JSONArray(this.getApplications()));
        SmartMonkeyLogItem.put(object, PACKAGES, new JSONArray(this.getPackages()));
        SmartMonkeyLogItem.put(object, ANR_TIMES, new JSONArray(this.getAnrTimes()));
        SmartMonkeyLogItem.put(object, CRASH_TIMES, new JSONArray(this.getCrashTimes()));
        return object;
    }

    private static void put(JSONObject object, String key, Object value) {
        try {
            object.put(key, value);
        }
        catch (JSONException e) {
            object.remove(key);
        }
    }

    private class DateSet
    extends HashSet<Date> {
        private DateSet() {
        }
    }
}

