/*
 * Decompiled with CFR 0.152.
 */
package com.android.loganalysis.item;

import com.android.loganalysis.item.ConflictingItemException;
import com.android.loganalysis.item.GenericItem;
import com.android.loganalysis.item.IItem;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationDumpsItem
implements IItem {
    public static final String LOCATION_CLIENTS = "LOCATION_CLIENTS";
    private Collection<LocationInfoItem> mLocationClients = new LinkedList<LocationInfoItem>();

    public void addLocationClient(String packageName, int effective, int min, int max, String priority, int duration) {
        this.mLocationClients.add(new LocationInfoItem(packageName, effective, min, max, priority, duration));
    }

    public Collection<LocationInfoItem> getLocationClients() {
        return this.mLocationClients;
    }

    @Override
    public IItem merge(IItem other) throws ConflictingItemException {
        throw new ConflictingItemException("Location dumps items cannot be merged");
    }

    @Override
    public boolean isConsistent(IItem other) {
        return false;
    }

    @Override
    public JSONObject toJson() {
        JSONObject object = new JSONObject();
        if (this.mLocationClients != null) {
            try {
                JSONArray locationClients = new JSONArray();
                for (LocationInfoItem locationClient : this.mLocationClients) {
                    locationClients.put((Object)locationClient.toJson());
                }
                object.put(LOCATION_CLIENTS, (Object)locationClients);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return object;
    }

    public static class LocationInfoItem
    extends GenericItem {
        public static final String PACKAGE = "PACKAGE";
        public static final String EFFECTIVE_INTERVAL = "EFFECTIVE_INTERVAL";
        public static final String MIN_INTERVAL = "MIN_INTERVAL";
        public static final String MAX_INTERVAL = "MAX_INTERVAL";
        public static final String REQUEST_PRIORITY = "PRIORITY";
        public static final String LOCATION_DURATION = "LOCATION_DURATION";
        private static final Set<String> ATTRIBUTES = new HashSet<String>(Arrays.asList("PACKAGE", "EFFECTIVE_INTERVAL", "MIN_INTERVAL", "MAX_INTERVAL", "PRIORITY", "LOCATION_DURATION"));

        public LocationInfoItem(String packageName, int effective, int min, int max, String priority, int duration) {
            super(ATTRIBUTES);
            this.setAttribute(PACKAGE, packageName);
            this.setAttribute(EFFECTIVE_INTERVAL, effective);
            this.setAttribute(MIN_INTERVAL, min);
            this.setAttribute(MAX_INTERVAL, max);
            this.setAttribute(REQUEST_PRIORITY, priority);
            this.setAttribute(LOCATION_DURATION, duration);
        }

        public String getPackage() {
            return (String)this.getAttribute(PACKAGE);
        }

        public int getEffectiveInterval() {
            return (Integer)this.getAttribute(EFFECTIVE_INTERVAL);
        }

        public int getMinInterval() {
            return (Integer)this.getAttribute(MIN_INTERVAL);
        }

        public int getMaxInterval() {
            return (Integer)this.getAttribute(MAX_INTERVAL);
        }

        public String getPriority() {
            return (String)this.getAttribute(REQUEST_PRIORITY);
        }

        public int getDuration() {
            return (Integer)this.getAttribute(LOCATION_DURATION);
        }
    }
}

