/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.InvocationResult;
import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.ResultHandler;
import com.android.compatibility.common.util.ResultType;
import com.android.compatibility.common.util.ResultUnit;
import com.android.compatibility.common.util.TestResultHistory;
import com.android.compatibility.common.util.TestStatus;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import junit.framework.TestCase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ResultHandlerTest
extends TestCase {
    private static final String SUITE_NAME = "CTS";
    private static final String SUITE_VERSION = "5.0";
    private static final String SUITE_PLAN = "cts";
    private static final String SUITE_BUILD = "12345";
    private static final String REPORT_VERSION = "5.0";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final String OS_VERSION = System.getProperty("os.version");
    private static final String OS_ARCH = System.getProperty("os.arch");
    private static final String JAVA_VENDOR = System.getProperty("java.vendor");
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String NAME_A = "ModuleA";
    private static final String NAME_B = "ModuleB";
    private static final String DONE_A = "false";
    private static final String DONE_B = "true";
    private static final String RUNTIME_A = "100";
    private static final String RUNTIME_B = "200";
    private static final String ABI = "mips64";
    private static final String ID_A = AbiUtils.createId((String)"mips64", (String)"ModuleA");
    private static final String ID_B = AbiUtils.createId((String)"mips64", (String)"ModuleB");
    private static final String BUILD_FINGERPRINT = "build_fingerprint";
    private static final String BUILD_FINGERPRINT_UNALTERED = "build_fingerprint_unaltered";
    private static final String BUILD_ID = "build_id";
    private static final String BUILD_PRODUCT = "build_product";
    private static final String RUN_HISTORY = "run_history";
    private static final String EXAMPLE_BUILD_ID = "XYZ";
    private static final String EXAMPLE_BUILD_PRODUCT = "wolverine";
    private static final String EXAMPLE_BUILD_FINGERPRINT = "example_build_fingerprint";
    private static final String EXAMPLE_BUILD_FINGERPRINT_UNALTERED = "example_build_fingerprint_unaltered";
    private static final String EXAMPLE_RUN_HISTORY = "[{\"startTime\":10000000000000,\"endTime\":10000000000001},{\"startTime\":10000000000002,\"endTime\":10000000000003}]";
    private static final String DEVICE_A = "device123";
    private static final String DEVICE_B = "device456";
    private static final String DEVICES = "device456,device123";
    private static final String CLASS_A = "android.test.Foor";
    private static final String CLASS_B = "android.test.Bar";
    private static final String METHOD_1 = "testBlah1";
    private static final String METHOD_2 = "testBlah2";
    private static final String METHOD_3 = "testBlah3";
    private static final String METHOD_4 = "testBlah4";
    private static final String METHOD_5 = "testBlah5";
    private static final String SUMMARY_SOURCE = String.format("%s#%s:20", "android.test.Bar", "testBlah4");
    private static final String SUMMARY_MESSAGE = "Headline";
    private static final double SUMMARY_VALUE = 9001.0;
    private static final String MESSAGE = "Something small is not alright";
    private static final String STACK_TRACE = "Something small is not alright\n at four.big.insects.Marley.sing(Marley.java:10)";
    private static final String BUG_REPORT = "https://cnsviewer.corp.google.com/cns/bugreport.txt";
    private static final String LOGCAT = "https://cnsviewer.corp.google.com/cns/logcat.gz";
    private static final String SCREENSHOT = "https://cnsviewer.corp.google.com/screenshot.png";
    private static final long START_MS = 1431586801000L;
    private static final long END_MS = 1431673199000L;
    private static final String START_DISPLAY = "Fri Aug 20 15:13:03 PDT 2010";
    private static final String END_DISPLAY = "Fri Aug 20 15:13:04 PDT 2010";
    private static final long TEST_START_MS = 1000000000011L;
    private static final long TEST_END_MS = 1000000000012L;
    private static final boolean TEST_IS_AUTOMATED = false;
    private static final String REFERENCE_URL = "http://android.com";
    private static final String LOG_URL = "file:///path/to/logs";
    private static final String COMMAND_LINE_ARGS = "cts -m CtsMyModuleTestCases";
    private static final String XML_BASE = "<?xml version='1.0' encoding='UTF-8' standalone='no' ?><?xml-stylesheet type=\"text/xsl\" href=\"compatibility_result.xsl\"?>\n<Result start=\"%d\" end=\"%d\" start_display=\"%s\"end_display=\"%s\" suite_name=\"%s\" suite_version=\"%s\" suite_plan=\"%s\" suite_build_number=\"%s\" report_version=\"%s\" devices=\"%s\" host_name=\"%s\"os_name=\"%s\" os_version=\"%s\" os_arch=\"%s\" java_vendor=\"%s\"java_version=\"%s\" reference_url=\"%s\" log_url=\"%s\"command_line_args=\"%s\">\n%s%s%s</Result>";
    private static final String XML_BUILD_INFO = "  <Build build_fingerprint=\"%s\" build_id=\"%s\" build_product=\"%s\"   />\n";
    private static final String XML_BUILD_INFO_WITH_UNALTERED_BUILD_FINGERPRINT = "  <Build build_fingerprint=\"%s\" build_fingerprint_unaltered=\"%s\" build_id=\"%s\" build_product=\"%s\"   />\n";
    private static final String XML_SUMMARY = "  <Summary pass=\"%d\" failed=\"%d\" modules_done=\"1\" modules_total=\"1\" />\n";
    private static final String XML_MODULE = "  <Module name=\"%s\" abi=\"%s\" device=\"%s\" runtime=\"%s\" done=\"%s\">\n%s  </Module>\n";
    private static final String XML_CASE = "    <TestCase name=\"%s\">\n%s    </TestCase>\n";
    private static final String XML_TEST_PASS = "      <Test result=\"pass\" name=\"%s\"/>\n";
    private static final String XML_TEST_SKIP = "      <Test result=\"pass\" name=\"%s\" skipped=\"true\"/>\n";
    private static final String XML_TEST_FAIL = "      <Test result=\"fail\" name=\"%s\">\n        <Failure message=\"%s\">\n          <StackTrace>%s</StackTrace>\n        </Failure>\n        <BugReport>%s</BugReport>\n        <Logcat>%s</Logcat>\n        <Screenshot>%s</Screenshot>\n      </Test>\n";
    private static final String XML_TEST_RESULT = "      <Test result=\"pass\" name=\"%s\">\n        <Summary>\n          <Metric source=\"%s\" message=\"%s\" score_type=\"%s\" score_unit=\"%s\">\n             <Value>%s</Value>\n          </Metric>\n        </Summary>\n      </Test>\n";
    private static final String NEW_XML_TEST_RESULT = "      <Test result=\"pass\" name=\"%s\">\n        <Metric key=\"%s\">%s</Metric>\n      </Test>\n";
    private File resultsDir = null;
    private File resultDir = null;

    public void setUp() throws Exception {
        this.resultsDir = FileUtil.createTempDir((String)"results");
        this.resultDir = FileUtil.createTempDir((String)SUITE_BUILD, (File)this.resultsDir);
    }

    public void tearDown() throws Exception {
        FileUtil.recursiveDelete((File)this.resultsDir);
    }

    public void testSerialization() throws Exception {
        InvocationResult result = new InvocationResult();
        result.setStartTime(1431586801000L);
        result.setTestPlan(SUITE_PLAN);
        result.addDeviceSerial(DEVICE_A);
        result.addDeviceSerial(DEVICE_B);
        result.addInvocationInfo(BUILD_FINGERPRINT, EXAMPLE_BUILD_FINGERPRINT);
        result.addInvocationInfo(BUILD_ID, EXAMPLE_BUILD_ID);
        result.addInvocationInfo(BUILD_PRODUCT, EXAMPLE_BUILD_PRODUCT);
        result.addInvocationInfo(RUN_HISTORY, EXAMPLE_RUN_HISTORY);
        Collection runHistories = result.getRunHistories();
        InvocationResult.RunHistory runHistory1 = new InvocationResult.RunHistory();
        runHistory1.startTime = 10000000000000L;
        runHistory1.endTime = 10000000000001L;
        runHistories.add(runHistory1);
        InvocationResult.RunHistory runHistory2 = new InvocationResult.RunHistory();
        runHistory2.startTime = 10000000000002L;
        runHistory2.endTime = 10000000000003L;
        runHistories.add(runHistory2);
        IModuleResult moduleA = result.getOrCreateModule(ID_A);
        moduleA.setDone(false);
        moduleA.addRuntime((long)Integer.parseInt(RUNTIME_A));
        ICaseResult moduleACase = moduleA.getOrCreateResult(CLASS_A);
        ITestResult moduleATest1 = moduleACase.getOrCreateResult(METHOD_1);
        moduleATest1.setResultStatus(TestStatus.PASS);
        ITestResult moduleATest2 = moduleACase.getOrCreateResult(METHOD_2);
        moduleATest2.setResultStatus(null);
        IModuleResult moduleB = result.getOrCreateModule(ID_B);
        moduleB.setDone(true);
        moduleB.addRuntime((long)Integer.parseInt(RUNTIME_B));
        ICaseResult moduleBCase = moduleB.getOrCreateResult(CLASS_B);
        ITestResult moduleBTest3 = moduleBCase.getOrCreateResult(METHOD_3);
        moduleBTest3.setResultStatus(TestStatus.FAIL);
        moduleBTest3.setMessage(MESSAGE);
        moduleBTest3.setStackTrace(STACK_TRACE);
        moduleBTest3.setBugReport(BUG_REPORT);
        moduleBTest3.setLog(LOGCAT);
        moduleBTest3.setScreenshot(SCREENSHOT);
        ITestResult moduleBTest4 = moduleBCase.getOrCreateResult(METHOD_4);
        moduleBTest4.setResultStatus(TestStatus.PASS);
        ReportLog report = new ReportLog();
        ReportLog.Metric summary = new ReportLog.Metric(SUMMARY_SOURCE, SUMMARY_MESSAGE, 9001.0, ResultType.HIGHER_BETTER, ResultUnit.SCORE);
        report.setSummary(summary);
        moduleBTest4.setReportLog(report);
        ITestResult moduleBTest5 = moduleBCase.getOrCreateResult(METHOD_5);
        moduleBTest5.skipped();
        HashMap<String, String> testAttributes = new HashMap<String, String>();
        testAttributes.put("foo1", "bar1");
        testAttributes.put("foo2", "bar2");
        File res = ResultHandler.writeResults((String)SUITE_NAME, (String)"5.0", (String)SUITE_PLAN, (String)SUITE_BUILD, (IInvocationResult)result, (File)this.resultDir, (long)1431586801000L, (long)1431673199000L, (String)REFERENCE_URL, (String)LOG_URL, (String)COMMAND_LINE_ARGS, testAttributes);
        String content = FileUtil.readStringFromFile((File)res);
        this.assertXmlContainsAttribute(content, "Result", "foo1", "bar1");
        this.assertXmlContainsAttribute(content, "Result", "foo2", "bar2");
        this.assertXmlContainsAttribute(content, "Result/Build", RUN_HISTORY, EXAMPLE_RUN_HISTORY);
        this.assertXmlContainsNode(content, "Result/RunHistory");
        this.assertXmlContainsAttribute(content, "Result/RunHistory/Run", "start", "10000000000000");
        this.assertXmlContainsAttribute(content, "Result/RunHistory/Run", "end", "10000000000001");
        this.assertXmlContainsAttribute(content, "Result/RunHistory/Run", "start", "10000000000002");
        this.assertXmlContainsAttribute(content, "Result/RunHistory/Run", "end", "10000000000003");
        result = ResultHandler.getResultFromDir((File)this.resultDir);
        ResultHandlerTest.checkResult((IInvocationResult)result, false);
        ResultHandlerTest.checkRunHistory((IInvocationResult)result);
    }

    public void testSerialization_whenTestResultWithTestResultHistoryWithoutParsing() throws Exception {
        InvocationResult result = new InvocationResult();
        result.setStartTime(1431586801000L);
        result.setTestPlan(SUITE_PLAN);
        result.addDeviceSerial(DEVICE_A);
        result.addDeviceSerial(DEVICE_B);
        result.addInvocationInfo(BUILD_FINGERPRINT, EXAMPLE_BUILD_FINGERPRINT);
        result.addInvocationInfo(BUILD_ID, EXAMPLE_BUILD_ID);
        result.addInvocationInfo(BUILD_PRODUCT, EXAMPLE_BUILD_PRODUCT);
        IModuleResult moduleA = result.getOrCreateModule(ID_A);
        moduleA.setDone(false);
        moduleA.addRuntime((long)Integer.parseInt(RUNTIME_A));
        ICaseResult moduleACase = moduleA.getOrCreateResult(CLASS_A);
        ITestResult moduleATest1 = moduleACase.getOrCreateResult(METHOD_1);
        moduleATest1.setResultStatus(TestStatus.PASS);
        IModuleResult moduleB = result.getOrCreateModule(ID_B);
        moduleB.setDone(true);
        moduleB.addRuntime((long)Integer.parseInt(RUNTIME_B));
        ICaseResult moduleBCase = moduleB.getOrCreateResult(CLASS_B);
        HashSet<TestResultHistory.ExecutionRecord> executionRecords = new HashSet<TestResultHistory.ExecutionRecord>();
        executionRecords.add(new TestResultHistory.ExecutionRecord(1000000000011L, 1000000000012L, false));
        ITestResult moduleBTest3 = moduleBCase.getOrCreateResult(METHOD_3);
        moduleBTest3.setResultStatus(TestStatus.FAIL);
        moduleBTest3.setMessage(MESSAGE);
        moduleBTest3.setStackTrace(STACK_TRACE);
        moduleBTest3.setBugReport(BUG_REPORT);
        moduleBTest3.setLog(LOGCAT);
        moduleBTest3.setScreenshot(SCREENSHOT);
        ArrayList<TestResultHistory> resultHistories = new ArrayList<TestResultHistory>();
        TestResultHistory resultHistory = new TestResultHistory(METHOD_3, executionRecords);
        resultHistories.add(resultHistory);
        moduleBTest3.setTestResultHistories(resultHistories);
        ITestResult moduleBTest4 = moduleBCase.getOrCreateResult(METHOD_4);
        moduleBTest4.setResultStatus(TestStatus.PASS);
        ReportLog report = new ReportLog();
        ReportLog.Metric summary = new ReportLog.Metric(SUMMARY_SOURCE, SUMMARY_MESSAGE, 9001.0, ResultType.HIGHER_BETTER, ResultUnit.SCORE);
        report.setSummary(summary);
        moduleBTest4.setReportLog(report);
        ITestResult moduleBTest5 = moduleBCase.getOrCreateResult(METHOD_5);
        moduleBTest5.skipped();
        File res = ResultHandler.writeResults((String)SUITE_NAME, (String)"5.0", (String)SUITE_PLAN, (String)SUITE_BUILD, (IInvocationResult)result, (File)this.resultDir, (long)1431586801000L, (long)1431673199000L, (String)REFERENCE_URL, (String)LOG_URL, (String)COMMAND_LINE_ARGS, null);
        String content = FileUtil.readStringFromFile((File)res);
        this.assertXmlContainsNode(content, "Result/Module/TestCase/Test/RunHistory");
        this.assertXmlContainsAttribute(content, "Result/Module/TestCase/Test/RunHistory/Run", "start", Long.toString(1000000000011L));
        this.assertXmlContainsAttribute(content, "Result/Module/TestCase/Test/RunHistory/Run", "end", Long.toString(1000000000012L));
        this.assertXmlContainsAttribute(content, "Result/Module/TestCase/Test/RunHistory/Run", "isAutomated", Boolean.toString(false));
        ResultHandlerTest.checkResult((IInvocationResult)result, EXAMPLE_BUILD_FINGERPRINT, false, false);
    }

    public void testParsing() throws Exception {
        File resultDir = ResultHandlerTest.writeResultDir(this.resultsDir, false);
        ResultHandlerTest.checkResult(ResultHandler.getResultFromDir((File)resultDir), false);
    }

    public void testParsing_newTestFormat() throws Exception {
        File resultDir = ResultHandlerTest.writeResultDir(this.resultsDir, true);
        ResultHandlerTest.checkResult(ResultHandler.getResultFromDir((File)resultDir), true);
    }

    public void testParsing_usesUnalteredBuildFingerprintWhenPresent() throws Exception {
        String buildInfo = String.format(XML_BUILD_INFO_WITH_UNALTERED_BUILD_FINGERPRINT, EXAMPLE_BUILD_FINGERPRINT, EXAMPLE_BUILD_FINGERPRINT_UNALTERED, EXAMPLE_BUILD_ID, EXAMPLE_BUILD_PRODUCT);
        File resultDir = ResultHandlerTest.writeResultDir(this.resultsDir, buildInfo, false);
        ResultHandlerTest.checkResult(ResultHandler.getResultFromDir((File)resultDir), EXAMPLE_BUILD_FINGERPRINT_UNALTERED, false, true);
    }

    public void testParsing_whenUnalteredBuildFingerprintIsEmpty_usesRegularBuildFingerprint() throws Exception {
        String buildInfo = String.format(XML_BUILD_INFO_WITH_UNALTERED_BUILD_FINGERPRINT, EXAMPLE_BUILD_FINGERPRINT, "", EXAMPLE_BUILD_ID, EXAMPLE_BUILD_PRODUCT);
        File resultDir = ResultHandlerTest.writeResultDir(this.resultsDir, buildInfo, false);
        ResultHandlerTest.checkResult(ResultHandler.getResultFromDir((File)resultDir), EXAMPLE_BUILD_FINGERPRINT, false, true);
    }

    public void testGetLightResults() throws Exception {
        File resultDir = ResultHandlerTest.writeResultDir(this.resultsDir, false);
        List lightResults = ResultHandler.getLightResults((File)this.resultsDir);
        ResultHandlerTest.assertEquals((String)"Expected one result", (int)1, (int)lightResults.size());
        IInvocationResult lightResult = (IInvocationResult)lightResults.get(0);
        ResultHandlerTest.checkLightResult(lightResult);
    }

    static File writeResultDir(File resultsDir, boolean newTestFormat) throws IOException {
        String buildInfo = String.format(XML_BUILD_INFO, EXAMPLE_BUILD_FINGERPRINT, EXAMPLE_BUILD_ID, EXAMPLE_BUILD_PRODUCT);
        return ResultHandlerTest.writeResultDir(resultsDir, buildInfo, newTestFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File writeResultDir(File resultsDir, String buildInfo, boolean newTestFormat) throws IOException {
        File resultDir = null;
        try (OutputStreamWriter writer = null;){
            resultDir = FileUtil.createTempDir((String)SUITE_BUILD, (File)resultsDir);
            File resultFile = new File(resultDir, "test_result.xml");
            writer = new FileWriter(resultFile);
            String summary = String.format(XML_SUMMARY, 2, 1);
            String moduleATest = String.format(XML_TEST_PASS, METHOD_1);
            String moduleACases = String.format(XML_CASE, CLASS_A, moduleATest);
            String moduleA = String.format(XML_MODULE, NAME_A, ABI, DEVICE_A, RUNTIME_A, DONE_A, moduleACases);
            String moduleBTest3 = String.format(XML_TEST_FAIL, METHOD_3, MESSAGE, STACK_TRACE, BUG_REPORT, LOGCAT, SCREENSHOT);
            String moduleBTest4 = "";
            moduleBTest4 = newTestFormat ? String.format(NEW_XML_TEST_RESULT, METHOD_4, SUMMARY_MESSAGE, Double.toString(9001.0)) : String.format(XML_TEST_RESULT, METHOD_4, SUMMARY_SOURCE, SUMMARY_MESSAGE, ResultType.HIGHER_BETTER.toReportString(), ResultUnit.SCORE.toReportString(), Double.toString(9001.0));
            String moduleBTest5 = String.format(XML_TEST_SKIP, METHOD_5);
            String moduleBTests = String.join((CharSequence)"", moduleBTest3, moduleBTest4, moduleBTest5);
            String moduleBCases = String.format(XML_CASE, CLASS_B, moduleBTests);
            String moduleB = String.format(XML_MODULE, NAME_B, ABI, DEVICE_B, RUNTIME_B, DONE_B, moduleBCases);
            String modules = String.join((CharSequence)"", moduleA, moduleB);
            String hostName = "";
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            String output = String.format(XML_BASE, 1431586801000L, 1431673199000L, START_DISPLAY, END_DISPLAY, SUITE_NAME, "5.0", SUITE_PLAN, SUITE_BUILD, "5.0", DEVICES, hostName, OS_NAME, OS_VERSION, OS_ARCH, JAVA_VENDOR, JAVA_VERSION, REFERENCE_URL, LOG_URL, COMMAND_LINE_ARGS, buildInfo, summary, modules);
            writer.write(output);
            writer.flush();
        }
        return resultDir;
    }

    static void checkLightResult(IInvocationResult lightResult) throws Exception {
        ResultHandlerTest.assertEquals((String)"Expected 3 passes", (int)3, (int)lightResult.countResults(TestStatus.PASS));
        ResultHandlerTest.assertEquals((String)"Expected 1 failure", (int)1, (int)lightResult.countResults(TestStatus.FAIL));
        Map buildInfo = lightResult.getInvocationInfo();
        ResultHandlerTest.assertEquals((String)"Incorrect Build ID", (String)EXAMPLE_BUILD_ID, (String)((String)buildInfo.get(BUILD_ID)));
        ResultHandlerTest.assertEquals((String)"Incorrect Build Product", (String)EXAMPLE_BUILD_PRODUCT, (String)((String)buildInfo.get(BUILD_PRODUCT)));
        Set serials = lightResult.getDeviceSerials();
        ResultHandlerTest.assertTrue((String)"Missing device", (boolean)serials.contains(DEVICE_A));
        ResultHandlerTest.assertTrue((String)"Missing device", (boolean)serials.contains(DEVICE_B));
        ResultHandlerTest.assertEquals((String)"Expected 2 devices", (int)2, (int)serials.size());
        ResultHandlerTest.assertTrue((String)"Incorrect devices", (serials.contains(DEVICE_A) && serials.contains(DEVICE_B) ? 1 : 0) != 0);
        ResultHandlerTest.assertEquals((String)"Incorrect start time", (long)1431586801000L, (long)lightResult.getStartTime());
        ResultHandlerTest.assertEquals((String)"Incorrect test plan", (String)SUITE_PLAN, (String)lightResult.getTestPlan());
        List modules = lightResult.getModules();
        ResultHandlerTest.assertEquals((String)"Expected 1 completed module", (int)1, (int)lightResult.getModuleCompleteCount());
        ResultHandlerTest.assertEquals((String)"Expected 2 total modules", (int)2, (int)modules.size());
    }

    static void checkResult(IInvocationResult result, boolean newTestFormat) throws Exception {
        ResultHandlerTest.checkResult(result, EXAMPLE_BUILD_FINGERPRINT, newTestFormat, true);
    }

    static void checkRunHistory(IInvocationResult result) {
        Map buildInfo = result.getInvocationInfo();
        ResultHandlerTest.assertEquals((String)"Incorrect run history", (String)EXAMPLE_RUN_HISTORY, (String)((String)buildInfo.get(RUN_HISTORY)));
    }

    static void checkResult(IInvocationResult result, String expectedBuildFingerprint, boolean newTestFormat, boolean checkResultHistories) throws Exception {
        ResultHandlerTest.assertEquals((String)"Expected 3 passes", (int)3, (int)result.countResults(TestStatus.PASS));
        ResultHandlerTest.assertEquals((String)"Expected 1 failure", (int)1, (int)result.countResults(TestStatus.FAIL));
        Map buildInfo = result.getInvocationInfo();
        ResultHandlerTest.assertEquals((String)"Incorrect Build Fingerprint", (String)expectedBuildFingerprint, (String)result.getBuildFingerprint());
        ResultHandlerTest.assertEquals((String)"Incorrect Build ID", (String)EXAMPLE_BUILD_ID, (String)((String)buildInfo.get(BUILD_ID)));
        ResultHandlerTest.assertEquals((String)"Incorrect Build Product", (String)EXAMPLE_BUILD_PRODUCT, (String)((String)buildInfo.get(BUILD_PRODUCT)));
        Set serials = result.getDeviceSerials();
        ResultHandlerTest.assertTrue((String)"Missing device", (boolean)serials.contains(DEVICE_A));
        ResultHandlerTest.assertTrue((String)"Missing device", (boolean)serials.contains(DEVICE_B));
        ResultHandlerTest.assertEquals((String)"Expected 2 devices", (int)2, (int)serials.size());
        ResultHandlerTest.assertTrue((String)"Incorrect devices", (serials.contains(DEVICE_A) && serials.contains(DEVICE_B) ? 1 : 0) != 0);
        ResultHandlerTest.assertEquals((String)"Incorrect start time", (long)1431586801000L, (long)result.getStartTime());
        ResultHandlerTest.assertEquals((String)"Incorrect test plan", (String)SUITE_PLAN, (String)result.getTestPlan());
        List modules = result.getModules();
        ResultHandlerTest.assertEquals((String)"Expected 2 modules", (int)2, (int)modules.size());
        IModuleResult moduleA = (IModuleResult)modules.get(0);
        ResultHandlerTest.assertEquals((String)"Expected 1 pass", (int)1, (int)moduleA.countResults(TestStatus.PASS));
        ResultHandlerTest.assertEquals((String)"Expected 0 failures", (int)0, (int)moduleA.countResults(TestStatus.FAIL));
        ResultHandlerTest.assertEquals((String)"Incorrect ABI", (String)ABI, (String)moduleA.getAbi());
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)NAME_A, (String)moduleA.getName());
        ResultHandlerTest.assertEquals((String)"Incorrect ID", (String)ID_A, (String)moduleA.getId());
        ResultHandlerTest.assertEquals((String)"Incorrect runtime", (long)Integer.parseInt(RUNTIME_A), (long)moduleA.getRuntime());
        List moduleACases = moduleA.getResults();
        ResultHandlerTest.assertEquals((String)"Expected 1 test case", (int)1, (int)moduleACases.size());
        ICaseResult moduleACase = (ICaseResult)moduleACases.get(0);
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)CLASS_A, (String)moduleACase.getName());
        List moduleAResults = moduleACase.getResults();
        ResultHandlerTest.assertEquals((String)"Expected 1 result", (int)1, (int)moduleAResults.size());
        ITestResult moduleATest1 = (ITestResult)moduleAResults.get(0);
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)METHOD_1, (String)moduleATest1.getName());
        ResultHandlerTest.assertEquals((String)"Incorrect result", (Object)TestStatus.PASS, (Object)moduleATest1.getResultStatus());
        ResultHandlerTest.assertNull((String)"Unexpected bugreport", (Object)moduleATest1.getBugReport());
        ResultHandlerTest.assertNull((String)"Unexpected log", (Object)moduleATest1.getLog());
        ResultHandlerTest.assertNull((String)"Unexpected screenshot", (Object)moduleATest1.getScreenshot());
        ResultHandlerTest.assertNull((String)"Unexpected message", (Object)moduleATest1.getMessage());
        ResultHandlerTest.assertNull((String)"Unexpected stack trace", (Object)moduleATest1.getStackTrace());
        ResultHandlerTest.assertNull((String)"Unexpected report", (Object)moduleATest1.getReportLog());
        IModuleResult moduleB = (IModuleResult)modules.get(1);
        ResultHandlerTest.assertEquals((String)"Expected 2 passes", (int)2, (int)moduleB.countResults(TestStatus.PASS));
        ResultHandlerTest.assertEquals((String)"Expected 1 failure", (int)1, (int)moduleB.countResults(TestStatus.FAIL));
        ResultHandlerTest.assertEquals((String)"Incorrect ABI", (String)ABI, (String)moduleB.getAbi());
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)NAME_B, (String)moduleB.getName());
        ResultHandlerTest.assertEquals((String)"Incorrect ID", (String)ID_B, (String)moduleB.getId());
        ResultHandlerTest.assertEquals((String)"Incorrect runtime", (long)Integer.parseInt(RUNTIME_B), (long)moduleB.getRuntime());
        List moduleBCases = moduleB.getResults();
        ResultHandlerTest.assertEquals((String)"Expected 1 test case", (int)1, (int)moduleBCases.size());
        ICaseResult moduleBCase = (ICaseResult)moduleBCases.get(0);
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)CLASS_B, (String)moduleBCase.getName());
        List moduleBResults = moduleBCase.getResults();
        ResultHandlerTest.assertEquals((String)"Expected 3 results", (int)3, (int)moduleBResults.size());
        ITestResult moduleBTest3 = (ITestResult)moduleBResults.get(0);
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)METHOD_3, (String)moduleBTest3.getName());
        ResultHandlerTest.assertEquals((String)"Incorrect result", (Object)TestStatus.FAIL, (Object)moduleBTest3.getResultStatus());
        ResultHandlerTest.assertEquals((String)"Incorrect bugreport", (String)BUG_REPORT, (String)moduleBTest3.getBugReport());
        ResultHandlerTest.assertEquals((String)"Incorrect log", (String)LOGCAT, (String)moduleBTest3.getLog());
        ResultHandlerTest.assertEquals((String)"Incorrect screenshot", (String)SCREENSHOT, (String)moduleBTest3.getScreenshot());
        ResultHandlerTest.assertEquals((String)"Incorrect message", (String)MESSAGE, (String)moduleBTest3.getMessage());
        ResultHandlerTest.assertEquals((String)"Incorrect stack trace", (String)STACK_TRACE, (String)moduleBTest3.getStackTrace());
        ResultHandlerTest.assertNull((String)"Unexpected report", (Object)moduleBTest3.getReportLog());
        List resultHistories = moduleBTest3.getTestResultHistories();
        if (checkResultHistories) {
            ResultHandlerTest.assertNull((String)"Unexpected test result history list", (Object)resultHistories);
        } else {
            ResultHandlerTest.assertNotNull((String)"Expected test result history list", (Object)resultHistories);
            ResultHandlerTest.assertEquals((String)"Expected 1 test result history", (int)1, (int)resultHistories.size());
            for (TestResultHistory resultHistory : resultHistories) {
                ResultHandlerTest.assertNotNull((String)"Expected test result history", (Object)resultHistory);
                ResultHandlerTest.assertEquals((String)"Incorrect test name", (String)METHOD_3, (String)resultHistory.getTestName());
                for (TestResultHistory.ExecutionRecord execRecord : resultHistory.getExecutionRecords()) {
                    ResultHandlerTest.assertEquals((String)"Incorrect test start time", (long)1000000000011L, (long)execRecord.getStartTime());
                    ResultHandlerTest.assertEquals((String)"Incorrect test end time", (long)1000000000012L, (long)execRecord.getEndTime());
                    ResultHandlerTest.assertEquals((String)"Incorrect test is automated", (boolean)false, (boolean)execRecord.getIsAutomated());
                }
            }
        }
        ITestResult moduleBTest4 = (ITestResult)moduleBResults.get(1);
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)METHOD_4, (String)moduleBTest4.getName());
        ResultHandlerTest.assertEquals((String)"Incorrect result", (Object)TestStatus.PASS, (Object)moduleBTest4.getResultStatus());
        ResultHandlerTest.assertNull((String)"Unexpected bugreport", (Object)moduleBTest4.getBugReport());
        ResultHandlerTest.assertNull((String)"Unexpected log", (Object)moduleBTest4.getLog());
        ResultHandlerTest.assertNull((String)"Unexpected screenshot", (Object)moduleBTest4.getScreenshot());
        ResultHandlerTest.assertNull((String)"Unexpected message", (Object)moduleBTest4.getMessage());
        ResultHandlerTest.assertNull((String)"Unexpected stack trace", (Object)moduleBTest4.getStackTrace());
        if (!newTestFormat) {
            ReportLog report = moduleBTest4.getReportLog();
            ResultHandlerTest.assertNotNull((String)"Expected report", (Object)report);
            ReportLog.Metric summary = report.getSummary();
            ResultHandlerTest.assertNotNull((String)"Expected report summary", (Object)summary);
            ResultHandlerTest.assertEquals((String)"Incorrect source", (String)SUMMARY_SOURCE, (String)summary.getSource());
            ResultHandlerTest.assertEquals((String)"Incorrect message", (String)SUMMARY_MESSAGE, (String)summary.getMessage());
            ResultHandlerTest.assertEquals((String)"Incorrect type", (Object)ResultType.HIGHER_BETTER, (Object)summary.getType());
            ResultHandlerTest.assertEquals((String)"Incorrect unit", (Object)ResultUnit.SCORE, (Object)summary.getUnit());
            ResultHandlerTest.assertTrue((String)"Incorrect values", (boolean)Arrays.equals(new double[]{9001.0}, summary.getValues()));
        }
        ITestResult moduleBTest5 = (ITestResult)moduleBResults.get(2);
        ResultHandlerTest.assertEquals((String)"Incorrect name", (String)METHOD_5, (String)moduleBTest5.getName());
        ResultHandlerTest.assertEquals((String)"Incorrect result", (Object)TestStatus.PASS, (Object)moduleBTest5.getResultStatus());
        ResultHandlerTest.assertTrue((String)"Expected skipped", (boolean)moduleBTest5.isSkipped());
        ResultHandlerTest.assertNull((String)"Unexpected bugreport", (Object)moduleBTest5.getBugReport());
        ResultHandlerTest.assertNull((String)"Unexpected log", (Object)moduleBTest5.getLog());
        ResultHandlerTest.assertNull((String)"Unexpected screenshot", (Object)moduleBTest5.getScreenshot());
        ResultHandlerTest.assertNull((String)"Unexpected message", (Object)moduleBTest5.getMessage());
        ResultHandlerTest.assertNull((String)"Unexpected stack trace", (Object)moduleBTest5.getStackTrace());
        ResultHandlerTest.assertNull((String)"Unexpected report", (Object)moduleBTest5.getReportLog());
    }

    private NodeList getXmlNodes(String xml, String xPathExpression) throws XPathExpressionException {
        InputSource inputSource = new InputSource(new StringReader(xml));
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (NodeList)xpath.evaluate(xPathExpression, inputSource, XPathConstants.NODESET);
    }

    private NodeList assertXmlContainsNode(String xml, String xPathExpression) throws XPathExpressionException {
        NodeList nodes = this.getXmlNodes(xml, xPathExpression);
        ResultHandlerTest.assertNotNull((String)String.format("XML '%s' returned null for xpath '%s'.", xml, xPathExpression), (Object)nodes);
        ResultHandlerTest.assertTrue((String)String.format("XML '%s' should have returned at least 1 node for xpath '%s', but returned %s nodes instead.", xml, xPathExpression, nodes.getLength()), (nodes.getLength() >= 1 ? 1 : 0) != 0);
        return nodes;
    }

    private void assertXmlContainsAttribute(String xml, String xPathExpression, String attributeName, String attributeValue) throws XPathExpressionException {
        NodeList nodes = this.assertXmlContainsNode(xml, xPathExpression);
        boolean found = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            String value = element.getAttribute(attributeName);
            if (!attributeValue.equals(value)) continue;
            found = true;
            break;
        }
        ResultHandlerTest.assertTrue((String)String.format("xPath '%s' should contain attribute '%s' but does not. XML: '%s'", xPathExpression, attributeName, xml), (boolean)found);
    }
}

