/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.ReadElf;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ReadElfTest {
    private static final String THIS_CLASS = "com.android.compatibility.common.util.ReadElfTest";
    private static final String TEST_SO_ARM32B = "arm32_libdl.so";
    private static final String TEST_SO_ARM32B_READELF = "arm32_libdl.txt";
    private static final String TEST_SO_ARM64B = "arm64_libdl.so";
    private static final String TEST_SO_ARM64B_READELF = "arm64_libdl.txt";
    private static final String TEST_EXE_X8664B = "x86app_process64";
    private static final String TEST_EXE_X8664B_READELF = "x86app_process64.txt";
    private static final String TEST_EXE_X8632B = "x86app_process32";
    private static final String TEST_EXE_X8632B_READELF = "x86app_process32.txt";

    @Test
    public void testReadElfArm32b() throws Exception {
        this.checkReadElf(TEST_SO_ARM32B, TEST_SO_ARM32B_READELF, "arm", 32, 3);
    }

    @Test
    public void testReadElfArm64b() throws Exception {
        this.checkReadElf(TEST_SO_ARM64B, TEST_SO_ARM64B_READELF, "arm", 64, 3);
    }

    @Test
    public void testReadElfX8632b() throws Exception {
        this.checkReadElf(TEST_EXE_X8632B, TEST_EXE_X8632B_READELF, "x86", 32, 3);
    }

    @Test
    public void testReadElfX8664b() throws Exception {
        this.checkReadElf(TEST_EXE_X8664B, TEST_EXE_X8664B_READELF, "x86", 64, 3);
    }

    private void checkReadElf(String elfFileName, String elfOutputFileName, String arch, int bits, int type) throws Exception {
        File targetFile = this.getResrouceFile(elfFileName);
        Assert.assertEquals((String)("ReadElf.isElf() " + elfFileName), (Object)true, (Object)ReadElf.isElf((File)targetFile));
        ReadElf elf = ReadElf.read((File)targetFile);
        Assert.assertEquals((String)"getBits() ", (long)bits, (long)elf.getBits());
        Assert.assertEquals((String)"getArchitecture() ", (Object)arch, (Object)elf.getArchitecture());
        Assert.assertEquals((String)"isDynamic() ", (Object)true, (Object)elf.isDynamic());
        Assert.assertEquals((String)"getType() ", (long)type, (long)elf.getType());
        File elfOutputFile = this.getResrouceFile(elfOutputFileName);
        Assert.assertEquals((String)("ReadElf.isElf() " + elfOutputFileName), (Object)false, (Object)ReadElf.isElf((File)elfOutputFile));
        ReadElf.Symbol[] dynSymbolArr = elf.getDynSymArr();
        this.chkDynSymbol(elfOutputFile, dynSymbolArr);
        Assert.assertEquals((String)("ReadElf.getDynamicDependencies() " + elfFileName), this.getDynamicDependencies(elfOutputFile), (Object)elf.getDynamicDependencies());
        Assert.assertEquals((String)("ReadElf.getRoStrings() " + elfFileName), this.getRoStrings(elfOutputFile), (Object)elf.getRoStrings());
    }

    private List<String> getDynamicDependencies(File elfOutputFile) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        FileReader fileReader = new FileReader(elfOutputFile);
        BufferedReader buffReader = new BufferedReader(fileReader);
        boolean keepGoing = true;
        block0: while ((line = buffReader.readLine()) != null && keepGoing) {
            String dsLine;
            if (!line.startsWith("Dynamic section")) continue;
            while ((dsLine = buffReader.readLine()) != null) {
                String trimLine = dsLine.trim();
                if (trimLine.isEmpty()) {
                    keepGoing = false;
                    continue block0;
                }
                if (!trimLine.contains("1 (NEEDED)")) continue;
                result.add(trimLine.substring(trimLine.indexOf("[") + 1, trimLine.indexOf("]")));
            }
        }
        fileReader.close();
        return result;
    }

    private void chkDynSymbol(File targetFile, ReadElf.Symbol[] dynSymbolArr) throws IOException {
        String line;
        FileReader fileReader = new FileReader(targetFile);
        BufferedReader buffReader = new BufferedReader(fileReader);
        boolean keepGoing = true;
        block0: while ((line = buffReader.readLine()) != null && keepGoing) {
            String dsLine;
            if (!line.startsWith("Symbol table '.dynsym'")) continue;
            buffReader.readLine();
            buffReader.readLine();
            int i = 1;
            while ((dsLine = buffReader.readLine()) != null) {
                String trimLine = dsLine.trim();
                if (trimLine.isEmpty()) {
                    keepGoing = false;
                    continue block0;
                }
                int idx = trimLine.indexOf("(");
                if (idx > 0) {
                    trimLine = trimLine.substring(0, idx);
                }
                String[] phases = trimLine.split("\\s+");
                String symName = dynSymbolArr[i].name;
                String name = phases[phases.length - 1].split("@")[0];
                Assert.assertTrue((String)String.format("chkDynSymbol name %d: %s vs %s", i, symName, name), (boolean)symName.startsWith(name));
                Assert.assertEquals((String)"chkDynSymbol type :", (Object)dynSymbolArr[i].toType(), (Object)phases[3]);
                Assert.assertEquals((String)"chkDynSymbol bind :", (Object)dynSymbolArr[i].toBind(), (Object)phases[4]);
                Assert.assertEquals((String)"chkDynSymbol ndx :", (Object)dynSymbolArr[i].toShndx(), (Object)phases[6]);
                ++i;
            }
        }
        fileReader.close();
    }

    private List<String> getRoStrings(File elfOutputFile) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        FileReader fileReader = new FileReader(elfOutputFile);
        BufferedReader buffReader = new BufferedReader(fileReader);
        boolean keepGoing = true;
        block0: while ((line = buffReader.readLine()) != null && keepGoing) {
            String dsLine;
            if (!line.startsWith("String dump of section '.rodata':")) continue;
            while ((dsLine = buffReader.readLine()) != null) {
                String trimLine = dsLine.trim();
                if (trimLine.isEmpty()) {
                    keepGoing = false;
                    continue block0;
                }
                if (!trimLine.contains("[")) continue;
                result.add(trimLine.substring(trimLine.indexOf("]") + 1, trimLine.length()).trim().replace("^J", "\n"));
            }
        }
        fileReader.close();
        return result;
    }

    private File getResrouceFile(String fileName) throws IOException {
        File tempFile = File.createTempFile(fileName, "tmp");
        tempFile.deleteOnExit();
        try (InputStream input = this.openResourceAsStream(fileName);
             FileOutputStream output = new FileOutputStream(tempFile);){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = input.read(buffer)) > 0) {
                ((OutputStream)output).write(buffer, 0, length);
            }
        }
        return tempFile;
    }

    private InputStream openResourceAsStream(String fileName) {
        InputStream input = this.getClass().getResourceAsStream("/" + fileName);
        Assert.assertNotNull((Object)input);
        return input;
    }
}

