/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.DynamicConfig;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.xmlpull.v1.XmlPullParserException;

public class DynamicConfigTest
extends TestCase {
    private static final String CORRECT_CONFIG = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<dynamicConfig>\n    <entry key=\"remote_config_required\">\n        <value>false</value>\n    </entry>\n    <entry key=\"test-config-1\">\n        <value>test config 1</value>\n    </entry>\n    <entry key=\"test-config-2\">\n        <value>testconfig2</value>\n    </entry>\n    <entry key=\"config-list\">\n        <value>config0</value>\n        <value>config1</value>\n        <value>config2</value>\n        <value>config3</value>\n        <value>config4</value>\n    </entry>\n    <entry key=\"config-list-2\">\n        <value>A</value>\n        <value>B</value>\n        <value>C</value>\n        <value>D</value>\n        <value>E</value>\n    </entry>\n</dynamicConfig>\n";
    private static final String CONFIG_WRONG_NODE_NAME = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<dynamicCsonfig>\n    <entry key=\"remote_config_required\">\n        <value>false</value>\n    </entry>\n    <entry key=\"test-config-1\">\n        <value>test config 1</value>\n    </entry>\n    <entry key=\"test-config-2\">\n        <value>testconfig2</value>\n    </entry>\n    <entry key=\"config-list\">\n        <value>Nevermore</value>\n        <value>Puck</value>\n        <value>Zeus</value>\n        <value>Earth Shaker</value>\n        <value>Vengeful Spirit</value>\n    </entry>\n    <entry key=\"config-list-2\">\n        <value>A</value>\n        <value>B</value>\n        <value>C</value>\n        <value>D</value>\n        <value>E</value>\n    </entry>\n</dynamicConfig>\n";

    public void testCorrectConfig() throws Exception {
        DynamicConfig config = new DynamicConfig();
        File file = this.createFileFromStr(CORRECT_CONFIG);
        try {
            config.initializeConfig(file);
            DynamicConfigTest.assertEquals((String)"Wrong Config", (String)config.getValue("test-config-1"), (String)"test config 1");
            DynamicConfigTest.assertEquals((String)"Wrong Config", (String)config.getValue("test-config-2"), (String)"testconfig2");
            DynamicConfigTest.assertEquals((String)"Wrong Config List", (String)((String)config.getValues("config-list").get(0)), (String)"config0");
            DynamicConfigTest.assertEquals((String)"Wrong Config List", (String)((String)config.getValues("config-list").get(2)), (String)"config2");
            DynamicConfigTest.assertEquals((String)"Wrong Config List", (String)((String)config.getValues("config-list-2").get(2)), (String)"C");
        }
        finally {
            FileUtil.deleteFile((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConfigWithWrongNodeName() throws Exception {
        DynamicConfig config = new DynamicConfig();
        File file = this.createFileFromStr(CONFIG_WRONG_NODE_NAME);
        try {
            config.initializeConfig(file);
            DynamicConfigTest.fail((String)"Cannot detect error when config file has wrong node name");
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        finally {
            FileUtil.deleteFile((File)file);
        }
    }

    private File createFileFromStr(String configStr) throws IOException {
        File file = File.createTempFile("test", "dynamic");
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(configStr.getBytes());
        stream.flush();
        stream.close();
        return file;
    }
}

