/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.CrashUtils;
import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CrashUtilsTest {
    private JSONArray mCrashes;

    @Before
    public void setUp() throws IOException {
        try (BufferedReader txtReader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("logcat.txt")));){
            String tmp;
            StringBuffer input = new StringBuffer();
            while ((tmp = txtReader.readLine()) != null) {
                input.append(tmp + "\n");
            }
            this.mCrashes = CrashUtils.addAllCrashes((String)input.toString(), (JSONArray)new JSONArray());
        }
    }

    @Test
    public void testGetAllCrashes() throws Exception {
        JSONArray expectedResults = new JSONArray();
        expectedResults.put((Object)this.createCrashJson(11071, 11189, "AudioOut_D", "/system/bin/audioserver", "e9380000", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libaudioutils.so", "memcpy_to_float_from_i16+5"), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libutils.so", "_ZN7android6Thread11_threadLoopEPv+140"), (Object)this.stackFrame("/system/lib/libc.so", "_ZL15__pthread_startPv+22"), (Object)this.stackFrame("/system/lib/libc.so", "__start_thread+6"))));
        expectedResults.put((Object)this.createCrashJson(12736, 12761, "Binder:12736_2", "/system/bin/audioserver", "0", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libc.so", "strlen+71"), (Object)this.stackFrame("/system/lib/libc.so", "__strlen_chk+4"), (Object)this.stackFrame("/system/lib/libutils.so", "_ZN7android7String8C2EPKc+12"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZNK7android18HwModuleCollection19getDeviceDescriptorEjPKcS2_b+458"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZN7android18AudioPolicyManager27setDeviceConnectionStateIntEj24audio_policy_dev_state_tPKcS3_+178"), (Object)this.stackFrame("/system/lib/libaudiopolicyservice.so", null), (Object)this.stackFrame("/system/lib/libmedia.so", "_ZN7android20BnAudioPolicyService10onTransactEjRKNS_6ParcelEPS1_j+1256"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android7BBinder8transactEjRKNS_6ParcelEPS1_j+70"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14executeCommandEi+702"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState20getAndExecuteCommandEv+114"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14joinThreadPoolEb+46"), (Object)this.stackFrame("/system/lib/libbinder.so", null), (Object[])new JSONObject[]{this.stackFrame("/system/lib/libutils.so", "_ZN7android6Thread11_threadLoopEPv+140"), this.stackFrame("/system/lib/libc.so", "_ZL15__pthread_startPv+22"), this.stackFrame("/system/lib/libc.so", "__start_thread+6")})));
        expectedResults.put((Object)this.createCrashJson(26201, 26227, "Binder:26201_3", "/system/bin/audioserver", "0", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libc.so", "strlen+71"), (Object)this.stackFrame("/system/lib/libc.so", "__strlen_chk+4"), (Object)this.stackFrame("/system/lib/libutils.so", "_ZN7android7String8C2EPKc+12"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZNK7android18HwModuleCollection19getDeviceDescriptorEjPKcS2_b+458"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZN7android18AudioPolicyManager27setDeviceConnectionStateIntEj24audio_policy_dev_state_tPKcS3_+178"), (Object)this.stackFrame("/system/lib/libaudiopolicyservice.so", null), (Object)this.stackFrame("/system/lib/libmedia.so", "_ZN7android20BnAudioPolicyService10onTransactEjRKNS_6ParcelEPS1_j+1256"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android7BBinder8transactEjRKNS_6ParcelEPS1_j+70"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14executeCommandEi+702"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState20getAndExecuteCommandEv+114"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14joinThreadPoolEb+46"), (Object)this.stackFrame("/system/lib/libbinder.so", null), (Object[])new JSONObject[]{this.stackFrame("/system/lib/libutils.so", "_ZN7android6Thread11_threadLoopEPv+140"), this.stackFrame("/system/lib/libc.so", "_ZL15__pthread_startPv+22"), this.stackFrame("/system/lib/libc.so", "__start_thread+6")})));
        expectedResults.put((Object)this.createCrashJson(26246, 26282, "Binder:26246_5", "/system/bin/audioserver", "0", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libc.so", "strlen+71"), (Object)this.stackFrame("/system/lib/libc.so", "__strlen_chk+4"), (Object)this.stackFrame("/system/lib/libutils.so", "_ZN7android7String8C2EPKc+12"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZNK7android18HwModuleCollection19getDeviceDescriptorEjPKcS2_b+458"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZN7android18AudioPolicyManager27setDeviceConnectionStateIntEj24audio_policy_dev_state_tPKcS3_+178"), (Object)this.stackFrame("/system/lib/libaudiopolicyservice.so", null), (Object)this.stackFrame("/system/lib/libmedia.so", "_ZN7android20BnAudioPolicyService10onTransactEjRKNS_6ParcelEPS1_j+1256"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android7BBinder8transactEjRKNS_6ParcelEPS1_j+70"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14executeCommandEi+702"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState20getAndExecuteCommandEv+114"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14joinThreadPoolEb+46"), (Object)this.stackFrame("/system/lib/libbinder.so", null), (Object[])new JSONObject[]{this.stackFrame("/system/lib/libutils.so", "_ZN7android6Thread11_threadLoopEPv+140"), this.stackFrame("/system/lib/libc.so", "_ZL15__pthread_startPv+22"), this.stackFrame("/system/lib/libc.so", "__start_thread+6")})));
        expectedResults.put((Object)this.createCrashJson(245, 245, "installd", "/system/bin/installd", null, "SIGABRT", "'utils.cpp:67] Check failed: is_valid_package_name(package_name) == 0 '", (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib64/libc.so", "tgkill+8"), (Object)this.stackFrame("/system/lib64/libc.so", "pthread_kill+64"), (Object)this.stackFrame("/system/lib64/libc.so", "raise+24"), (Object)this.stackFrame("/system/lib64/libc.so", "abort+52"), (Object)this.stackFrame("/system/lib64/libbase.so", "_ZN7android4base10LogMessageD1Ev+1084"), (Object)this.stackFrame("/system/bin/installd", null), (Object)this.stackFrame("/system/bin/installd", null), (Object)this.stackFrame("/system/bin/installd", null), (Object)this.stackFrame("/system/bin/installd", null), (Object)this.stackFrame("/system/lib64/libc.so", "__libc_init+88"), (Object)this.stackFrame("/system/bin/installd", null))));
        expectedResults.put((Object)this.createCrashJson(6371, 8072, "media.codec", "omx@1.0-service", "ed000000", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libstagefright_soft_hevcdec.so", null))));
        expectedResults.put((Object)this.createCrashJson(8373, 8414, "loo", "com.android.bluetooth", null, "SIGABRT", "'[FATAL:allocation_tracker.cc(143)] Check failed: map_entry != allocations.end().", (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib64/libc.so", "abort+120"), (Object)this.stackFrame("/system/lib64/libchrome.so", "base::debug::BreakDebugger()+20"), (Object)this.stackFrame("/system/lib64/libchrome.so", "logging::LogMessage::~LogMessage()+1068"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "allocation_tracker_notify_free(unsigned char, void*)+720"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "osi_free(void*)+20"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "l2c_fcr_cleanup(t_l2c_ccb*)+92"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "l2cu_release_ccb(t_l2c_ccb*)+176"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "l2c_csm_execute(t_l2c_ccb*, unsigned short, void*)+1852"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "L2CA_DisconnectRsp(unsigned short)+92"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "sdp_disconnect_ind(unsigned short, bool)+52"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "l2c_csm_execute(t_l2c_ccb*, unsigned short, void*)+3600"), (Object)this.stackFrame("/system/lib64/hw/bluetooth.default.so", "l2c_rcv_acl_data(BT_HDR*)+3980"), (Object[])new JSONObject[]{this.stackFrame("/system/lib64/libchrome.so", "base::debug::TaskAnnotator::RunTask(char const*, base::PendingTask const&)+188"), this.stackFrame("/system/lib64/libchrome.so", "base::MessageLoop::RunTask(base::PendingTask const&)+444"), this.stackFrame("/system/lib64/libchrome.so", "base::MessageLoop::DeferOrRunPendingTask(base::PendingTask)+52"), this.stackFrame("/system/lib64/libchrome.so", "base::MessageLoop::DoWork()+356"), this.stackFrame("/system/lib64/libchrome.so", "base::MessagePumpDefault::Run(base::MessagePump::Delegate*)+220"), this.stackFrame("/system/lib64/libchrome.so", "base::RunLoop::Run()+136"), this.stackFrame("/system/lib64/hw/bluetooth.default.so", "btu_message_loop_run(void*)+248"), this.stackFrame("/system/lib64/hw/bluetooth.default.so", "work_queue_read_cb(void*)+92"), this.stackFrame("/system/lib64/hw/bluetooth.default.so", "run_reactor(reactor_t*, int)+320"), this.stackFrame("/system/lib64/hw/bluetooth.default.so", "reactor_start(reactor_t*)+84"), this.stackFrame("/system/lib64/hw/bluetooth.default.so", "run_thread(void*)+184"), this.stackFrame("/system/lib64/libc.so", "__pthread_start(void*)+36"), this.stackFrame("/system/lib64/libc.so", "__start_thread+68")})));
        expectedResults.put((Object)this.createCrashJson(8080, 11665, "generic", "/system/bin/mediaserver", null, "SIGABRT", "'frameworks/av/media/libstagefright/MPEG4Extractor.cpp:6853 CHECK_EQ( (unsigned)ptr[0],1u) failed: 129 vs. 1'", (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libc.so", "tgkill+12"), (Object)this.stackFrame("/system/lib/libc.so", "pthread_kill+32"), (Object)this.stackFrame("/system/lib/libc.so", "raise+10"), (Object)this.stackFrame("/system/lib/libc.so", "__libc_android_abort+34"), (Object)this.stackFrame("/system/lib/libc.so", "abort+4"), (Object)this.stackFrame("/system/lib/libcutils.so", "__android_log_assert+86"), (Object)this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor25avcc_getCodecSpecificInfoERNS_2spINS_7ABufferEEEPKcj+392"), (Object)this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor15checkConfigDataEjRKNS_2spINS_8MetaDataEEE+218"), (Object)this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor12checkSupportEjRKNS_2spINS_8MetaDataEEE+136"), (Object)this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor10parseChunkEPxi+13060"), (Object)this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor10parseChunkEPxi+12508"), (Object)this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor10parseChunkEPxi+6174"), (Object[])new JSONObject[]{this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor10parseChunkEPxi+6174"), this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor10parseChunkEPxi+6174"), this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor10parseChunkEPxi+6174"), this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor10parseChunkEPxi+6174"), this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor12readMetaDataEv+94"), this.stackFrame("/system/lib/libstagefright.so", "_ZN7android14MPEG4Extractor11getMetaDataEv+10"), this.stackFrame("/system/lib/libmediaplayerservice.so", "_ZN7android8NuPlayer13GenericSource18initFromDataSourceEv+386"), this.stackFrame("/system/lib/libmediaplayerservice.so", "_ZN7android8NuPlayer13GenericSource14onPrepareAsyncEv+238"), this.stackFrame("/system/lib/libstagefright_foundation.so", "_ZN7android8AHandler14deliverMessageERKNS_2spINS_8AMessageEEE+16"), this.stackFrame("/system/lib/libstagefright_foundation.so", "_ZN7android8AMessage7deliverEv+54"), this.stackFrame("/system/lib/libstagefright_foundation.so", "_ZN7android7ALooper4loopEv+224"), this.stackFrame("/system/lib/libutils.so", "_ZN7android6Thread11_threadLoopEPv+112"), this.stackFrame("/system/lib/libc.so", "_ZL15__pthread_startPv+30"), this.stackFrame("/system/lib/libc.so", "__start_thread+6")})));
        expectedResults.put((Object)this.createCrashJson(11071, 11189, "synthetic_thread", "synthetic_process_0", "e9380000", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libaudioutils.so", "memcpy_to_float_from_i16+5"), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libaudioflinger.so", null), (Object)this.stackFrame("/system/lib/libutils.so", "_ZN7android6Thread11_threadLoopEPv+140"), (Object)this.stackFrame("/system/lib/libc.so", "_ZL15__pthread_startPv+22"), (Object)this.stackFrame("/system/lib/libc.so", "__start_thread+6"))));
        expectedResults.put((Object)this.createCrashJson(12736, 12761, "synthetic_thread", "synthetic_process_1", "0", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib/libc.so", "strlen+71"), (Object)this.stackFrame("/system/lib/libc.so", "__strlen_chk+4"), (Object)this.stackFrame("/system/lib/libutils.so", "_ZN7android7String8C2EPKc+12"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZNK7android18HwModuleCollection19getDeviceDescriptorEjPKcS2_b+458"), (Object)this.stackFrame("/system/lib/libaudiopolicymanagerdefault.so", "_ZN7android18AudioPolicyManager27setDeviceConnectionStateIntEj24audio_policy_dev_state_tPKcS3_+178"), (Object)this.stackFrame("/system/lib/libaudiopolicyservice.so", null), (Object)this.stackFrame("/system/lib/libmedia.so", "_ZN7android20BnAudioPolicyService10onTransactEjRKNS_6ParcelEPS1_j+1256"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android7BBinder8transactEjRKNS_6ParcelEPS1_j+70"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14executeCommandEi+702"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState20getAndExecuteCommandEv+114"), (Object)this.stackFrame("/system/lib/libbinder.so", "_ZN7android14IPCThreadState14joinThreadPoolEb+46"), (Object)this.stackFrame("/system/lib/libbinder.so", null), (Object[])new JSONObject[]{this.stackFrame("/system/lib/libutils.so", "_ZN7android6Thread11_threadLoopEPv+140"), this.stackFrame("/system/lib/libc.so", "_ZL15__pthread_startPv+22"), this.stackFrame("/system/lib/libc.so", "__start_thread+6")})));
        expectedResults.put((Object)this.createCrashJson(8925, 8925, "CVE-2021-0684", "/data/local/tmp/CVE-2021-0684", "7e772b8cfbe0", "SIGSEGV", null, (List<JSONObject>)ImmutableList.of((Object)this.stackFrame("/system/lib64/libinputreader.so", "android::TouchInputMapper::assignPointerIds(android::TouchInputMapper::RawState const*, android::TouchInputMapper::RawState*)+37"), (Object)this.stackFrame("/system/lib64/libinputreader.so", "android::TouchInputMapper::sync(long, long)+285"), (Object)this.stackFrame("/system/lib64/libinputreader.so", "android::MultiTouchInputMapper::process(android::RawEvent const*)+14"), (Object)this.stackFrame("/data/local/tmp/CVE-2021-0684", null), (Object)this.stackFrame("/data/local/tmp/CVE-2021-0684", null), (Object)this.stackFrame("/apex/com.android.runtime/lib64/bionic/libc.so", "__libc_init+86"))));
        Assert.assertEquals((String)(expectedResults.toString() + "\n" + this.mCrashes.toString() + "\n"), (Object)expectedResults.toString(), (Object)this.mCrashes.toString());
    }

    private JSONObject stackFrame(String filename, String method) throws JSONException {
        return new JSONObject().put("filename", (Object)filename).put("method", (Object)method);
    }

    public JSONObject createCrashJson(int pid, int tid, String name, String process, String faultaddress, String signal, String abortMessage) {
        return this.createCrashJson(pid, tid, name, process, faultaddress, signal, abortMessage, (List<JSONObject>)ImmutableList.of());
    }

    public JSONObject createCrashJson(int pid, int tid, String name, String process, String faultaddress, String signal, String abortMessage, List<JSONObject> stacktrace) {
        JSONObject json = new JSONObject();
        try {
            json.put("pid", pid);
            json.put("tid", tid);
            json.put("name", (Object)name);
            json.put("process", (Object)process);
            json.put("faultaddress", (Object)faultaddress);
            json.put("signal", (Object)signal);
            json.put("abortmessage", (Object)abortMessage);
            JSONArray stacktraceJson = new JSONArray();
            for (JSONObject stackframe : stacktrace) {
                stacktraceJson.put((Object)stackframe);
            }
            json.put("backtrace", (Object)stacktraceJson);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    @Test
    public void testValidCrash() throws Exception {
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")})));
    }

    @Test
    public void testMissingName() throws Exception {
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("")})));
    }

    @Test
    public void testSIGABRT() throws Exception {
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("installd")})));
    }

    @Test
    public void testFaultAddressBelowMin() throws Exception {
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_1")})));
    }

    @Test
    public void testIgnoreMinAddressCheck() throws Exception {
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(false).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_1")})));
    }

    @Test
    public void testBadAbortMessage() throws Exception {
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("generic")})));
    }

    @Test
    public void testGoodAndBadCrashes() throws Exception {
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0"), Pattern.compile("generic")})));
    }

    @Test
    public void testNullFaultAddress() throws Exception {
        JSONArray crashes = new JSONArray();
        crashes.put((Object)this.createCrashJson(8373, 8414, "loo", "com.android.bluetooth", null, "SIGSEGV", ""));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)crashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("com\\.android\\.bluetooth")})));
    }

    @Test
    public void testAbortMessageInclude() throws Exception {
        JSONArray crashes = new JSONArray();
        crashes.put((Object)this.createCrashJson(8373, 8414, "loo", "com.android.bluetooth", null, "SIGABRT", "'[FATAL:allocation_tracker.cc(143)] Check failed: map_entry != allocations.end()."));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)crashes, (CrashUtils.Config)new CrashUtils.Config().appendSignals(new String[]{"SIGABRT"}).appendAbortMessageIncludes(new String[]{"Check failed:"}).setProcessPatterns(new Pattern[]{Pattern.compile("com\\.android\\.bluetooth")})));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)crashes, (CrashUtils.Config)new CrashUtils.Config().appendSignals(new String[]{"SIGABRT"}).appendAbortMessageIncludes(new String[]{"include not matches"}).setProcessPatterns(new Pattern[]{Pattern.compile("com\\.android\\.bluetooth")})));
    }

    @Test
    public void testAbortMessageExclude() throws Exception {
        JSONArray crashes = new JSONArray();
        crashes.put((Object)this.createCrashJson(8373, 8414, "loo", "com.android.bluetooth", null, "SIGABRT", "'[FATAL:allocation_tracker.cc(143)] Check failed: map_entry != allocations.end()."));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)crashes, (CrashUtils.Config)new CrashUtils.Config().appendSignals(new String[]{"SIGABRT"}).appendAbortMessageExcludes(new String[]{"Check failed:"}).setProcessPatterns(new Pattern[]{Pattern.compile("com\\.android\\.bluetooth")})));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)crashes, (CrashUtils.Config)new CrashUtils.Config().appendSignals(new String[]{"SIGABRT"}).appendAbortMessageExcludes(new String[]{"exclude not matches"}).setProcessPatterns(new Pattern[]{Pattern.compile("com\\.android\\.bluetooth")})));
    }

    @Test
    public void testAbortMessageExcludeCannotLink() throws Exception {
        JSONArray crashes = new JSONArray();
        crashes.put((Object)this.createCrashJson(18959, 18959, "CVE-2020-0073", "/data/local/tmp/CVE-2020-0073", null, "SIGABRT", "'CANNOT LINK EXECUTABLE \"/data/local/tmp/CVE-2020-0073\": library \"libnfc-nci.so\" (\"(default)\", \"/data/local/tmp/CVE-2020-0073\", \"\") not found'"));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)crashes, (CrashUtils.Config)new CrashUtils.Config().appendSignals(new String[]{"SIGABRT"}).setProcessPatterns(new Pattern[]{Pattern.compile("CVE-2020-0073")})));
        crashes.put((Object)this.createCrashJson(5105, 5105, "CVE-2015-6616-2", "/data/local/tmp/CVE-2015-6616-2", null, "SIGABRT", "'CANNOT LINK EXECUTABLE \"/data/local/tmp/CVE-2015-6616-2\": cannot locate symbol \"_ZN7android14MediaExtractor17CreateFromServiceERKNS_2spINS_10DataSourceEEEPKc\" referenced by \"/data/local/tmp/CVE-2015-6616-2\"...'"));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)crashes, (CrashUtils.Config)new CrashUtils.Config().appendSignals(new String[]{"SIGABRT"}).setProcessPatterns(new Pattern[]{Pattern.compile("CVE-2015-6616-2")})));
    }

    @Test
    public void testBacktraceFilterIncludeFilename() throws Exception {
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libaudioutils", null)})));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libstagefright", null), new CrashUtils.Config.BacktraceFilterPattern("libaudioflinger\\.so", null)})));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libstagefright", null)})));
    }

    @Test
    public void testBacktraceFilterExcludeFilename() throws Exception {
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceExcludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libaudioutils", null)})));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceExcludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libstagefright", null), new CrashUtils.Config.BacktraceFilterPattern("libaudioflinger\\.so", null)})));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceExcludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libstagefright", null)})));
    }

    @Test
    public void testBacktraceFilterIncludeMethodName() throws Exception {
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern(null, "memcpy_to_float")})));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern(null, "strlen"), new CrashUtils.Config.BacktraceFilterPattern(null, "memcpy_[^_]+_float")})));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern(null, "strlen")})));
    }

    @Test
    public void testBacktraceFilterExcludeMethodName() throws Exception {
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceExcludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern(null, "memcpy_to_float")})));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceExcludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern(null, "strlen"), new CrashUtils.Config.BacktraceFilterPattern(null, "memcpy_[^_]+_float")})));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceExcludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern(null, "strlen")})));
    }

    @Test
    public void testBacktraceFilterCombinations() throws Exception {
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern(null, null)})));
        Assert.assertTrue((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libaudioutils", "memcpy")})));
        Assert.assertFalse((boolean)CrashUtils.securityCrashDetected((JSONArray)this.mCrashes, (CrashUtils.Config)new CrashUtils.Config().checkMinAddress(true).setProcessPatterns(new Pattern[]{Pattern.compile("synthetic_process_0")}).setBacktraceIncludes(new CrashUtils.Config.BacktraceFilterPattern[]{new CrashUtils.Config.BacktraceFilterPattern("libaudioutils", "strlen")})));
    }
}

