/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.CaseResult;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.TestStatus;
import junit.framework.TestCase;

public class CaseResultTest
extends TestCase {
    private static final String CLASS = "android.test.FoorBar";
    private static final String METHOD_1 = "testBlah1";
    private static final String METHOD_2 = "testBlah2";
    private static final String METHOD_3 = "testBlah3";
    private static final String MESSAGE = "Something small is not alright";
    private static final String STACK_TRACE = "Something small is not alright\n at four.big.insects.Marley.sing(Marley.java:10)";
    private CaseResult mResult;

    public void setUp() throws Exception {
        this.mResult = new CaseResult(CLASS);
    }

    public void tearDown() throws Exception {
        this.mResult = null;
    }

    public void testAccessors() throws Exception {
        CaseResultTest.assertEquals((String)"Incorrect case name", (String)CLASS, (String)this.mResult.getName());
    }

    public void testResultCreation() throws Exception {
        ITestResult testResult = this.mResult.getOrCreateResult(METHOD_1);
        CaseResultTest.assertEquals((String)"Expected one result", (int)1, (int)this.mResult.getResults().size());
        CaseResultTest.assertTrue((String)"Expected test result", (boolean)this.mResult.getResults().contains(testResult));
        ITestResult testResult2 = this.mResult.getOrCreateResult(METHOD_1);
        CaseResultTest.assertEquals((String)"Expected the same result", (Object)testResult, (Object)testResult2);
        CaseResultTest.assertEquals((String)"Expected one result", (int)1, (int)this.mResult.getResults().size());
    }

    public void testResultReporting() throws Exception {
        ITestResult testResult = this.mResult.getOrCreateResult(METHOD_1);
        testResult.failed(STACK_TRACE);
        CaseResultTest.assertEquals((String)"Expected status to be set", (Object)TestStatus.FAIL, (Object)testResult.getResultStatus());
        CaseResultTest.assertEquals((String)"Expected message to be set", (String)MESSAGE, (String)testResult.getMessage());
        CaseResultTest.assertEquals((String)"Expected stack to be set", (String)STACK_TRACE, (String)testResult.getStackTrace());
        testResult = this.mResult.getOrCreateResult(METHOD_2);
        testResult.passed(null);
        CaseResultTest.assertEquals((String)"Expected status to be set", (Object)TestStatus.PASS, (Object)testResult.getResultStatus());
        CaseResultTest.assertEquals((String)"Expected two results", (int)2, (int)this.mResult.getResults().size());
    }

    public void testCountResults() throws Exception {
        this.mResult.getOrCreateResult(METHOD_1).failed(STACK_TRACE);
        this.mResult.getOrCreateResult(METHOD_2).failed(STACK_TRACE);
        this.mResult.getOrCreateResult(METHOD_3).passed(null);
        CaseResultTest.assertEquals((String)"Expected two failures", (int)2, (int)this.mResult.countResults(TestStatus.FAIL));
        CaseResultTest.assertEquals((String)"Expected one pass", (int)1, (int)this.mResult.countResults(TestStatus.PASS));
    }

    public void testMergeCase() throws Exception {
        this.mResult.getOrCreateResult(METHOD_1).failed(STACK_TRACE);
        this.mResult.getOrCreateResult(METHOD_2).passed(null);
        CaseResult otherResult = new CaseResult(CLASS);
        otherResult.getOrCreateResult(METHOD_1).passed(null);
        otherResult.getOrCreateResult(METHOD_2).passed(null);
        otherResult.getOrCreateResult(METHOD_3).failed(STACK_TRACE);
        this.mResult.mergeFrom((ICaseResult)otherResult);
        CaseResultTest.assertEquals((String)"Expected one result", (int)3, (int)this.mResult.getResults().size());
        CaseResultTest.assertEquals((String)"Expected one failures", (int)1, (int)this.mResult.countResults(TestStatus.FAIL));
        CaseResultTest.assertEquals((String)"Expected two pass", (int)2, (int)this.mResult.countResults(TestStatus.PASS));
    }

    public void testMergeCase_passToFail() throws Exception {
        this.mResult.getOrCreateResult(METHOD_1).passed(null);
        CaseResult otherResult = new CaseResult(CLASS);
        otherResult.getOrCreateResult(METHOD_1).passed(null);
        otherResult.getOrCreateResult(METHOD_2).passed(null);
        otherResult.getOrCreateResult(METHOD_3).failed(STACK_TRACE);
        this.mResult.mergeFrom((ICaseResult)otherResult);
        CaseResultTest.assertEquals((String)"Expected one result", (int)3, (int)this.mResult.getResults().size());
        CaseResultTest.assertEquals((String)"Expected one failures", (int)1, (int)this.mResult.countResults(TestStatus.FAIL));
        CaseResultTest.assertEquals((String)"Expected two pass", (int)2, (int)this.mResult.countResults(TestStatus.PASS));
    }

    public void testMergeCase_mismatchedModuleName() throws Exception {
        CaseResult otherResult = new CaseResult("android.test.FoorBarfoo");
        try {
            this.mResult.mergeFrom((ICaseResult)otherResult);
            CaseResultTest.fail((String)"Expected IlleglArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

