/*
 * Decompiled with CFR 0.152.
 */
package com.android.catbox.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.targetprep.BuildError;
import com.android.tradefed.targetprep.ITargetCleaner;
import com.android.tradefed.targetprep.TargetSetupError;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

@OptionClass(alias="result-report-collector")
public class ResultReportCollector
implements ITargetCleaner {
    @Option(name="pull-file-content-uri", description="Copy the src files from device to destination using content uri")
    private Map<String, String> mFileContentUriMap = new HashMap<String, String>();
    @Option(name="pull-file-path", description="Copy the src files from device to destination using file path")
    private Map<String, String> mFilePathMap = new HashMap<String, String>();
    @Option(name="pull-dir-path", description="Copy the src directory from device to destination using directory path")
    private Map<String, String> mDirPathMap = new HashMap<String, String>();
    private static final String NO_RESULTS_STRING = "No result found.";
    private static final String ERROR_MESSAGE_TAG = "[ERROR]";

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, BuildError, DeviceNotAvailableException {
    }

    public void tearDown(ITestDevice device, IBuildInfo buildInfo, Throwable e) throws DeviceNotAvailableException {
        this.pullFilesUsingContentUri(device, buildInfo, this.mFileContentUriMap);
        this.pullFilesUsingFilePaths(device, buildInfo, this.mFilePathMap);
        this.pullDirUsingFilePaths(device, buildInfo, this.mDirPathMap);
    }

    private void pullFilesUsingContentUri(ITestDevice device, IBuildInfo buildInfo, Map<String, String> contentUriMap) throws DeviceNotAvailableException {
        if (contentUriMap.isEmpty()) {
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Started pulling file using Content URI.");
        for (Map.Entry<String, String> entry : contentUriMap.entrySet()) {
            this.pullFileUsingContentUri(device, buildInfo, entry.getKey(), entry.getValue());
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Completed pulling file using Content URI.");
    }

    private void pullFileUsingContentUri(ITestDevice device, IBuildInfo buildInfo, String fileContentUri, String destFilePath) throws DeviceNotAvailableException {
        if (Strings.isNullOrEmpty((String)fileContentUri) || Strings.isNullOrEmpty((String)destFilePath) || !fileContentUri.startsWith("content://")) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Either Src or Dest Path is invalid. Source: %s, Destination: %s", fileContentUri, destFilePath));
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("Started pulling file. Source File: %s, Destination File: %s", fileContentUri, destFilePath));
        if (!this.doesFileExist(device, fileContentUri)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("File %s does not exist on the device.", fileContentUri));
            return;
        }
        File destinationFile = this.getDestinationFile(buildInfo, destFilePath);
        if (destinationFile == null) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to get destination file path for %s.", destFilePath));
            return;
        }
        if (!this.createResultDir(buildInfo, destinationFile, true)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to create results directory %s.", destFilePath));
            return;
        }
        String pullCommand = String.format("content read --user %d --uri %s", device.getCurrentUser(), fileContentUri);
        try (FileOutputStream localFileStream = new FileOutputStream(destinationFile);){
            CommandResult pullResult = device.executeShellV2Command(pullCommand, (OutputStream)localFileStream);
            if (!this.isSuccessful(pullResult)) {
                String stderr = pullResult.getStderr();
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Failed to pull a file at '%s' to %s. Error: '%s'", fileContentUri, destFilePath, stderr));
            }
        }
        catch (IOException ex) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Failed to open OutputStream to the local file %s. Error: %s", destFilePath, ex.getMessage()));
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("Completed pulling file. Source File: %s, Destination File: %s", fileContentUri, destFilePath));
    }

    private boolean doesFileExist(ITestDevice device, String contentUri) throws DeviceNotAvailableException {
        String queryContentCommand = String.format("content query --user %d --uri %s", device.getCurrentUser(), contentUri);
        String listCommandResult = device.executeShellCommand(queryContentCommand);
        return !NO_RESULTS_STRING.equals(listCommandResult.trim());
    }

    private boolean isSuccessful(CommandResult result) {
        if (!CommandStatus.SUCCESS.equals((Object)result.getStatus())) {
            return false;
        }
        String stdout = result.getStdout();
        if (stdout.contains(ERROR_MESSAGE_TAG)) {
            return false;
        }
        return Strings.isNullOrEmpty((String)result.getStderr());
    }

    private File getDestinationFile(IBuildInfo buildInfo, String destPath) {
        File destinationFile = null;
        CompatibilityBuildHelper buildHelper = new CompatibilityBuildHelper(buildInfo);
        try {
            destinationFile = buildHelper.getResultDir();
            destinationFile = new File(destinationFile, destPath);
        }
        catch (IOException ex) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to get destination file %s: Error: %s.", destPath, ex.getMessage()));
            return null;
        }
        return destinationFile;
    }

    private boolean createResultDir(IBuildInfo buildInfo, File destination, boolean isDestFile) {
        File resultDir = destination;
        if (isDestFile) {
            resultDir = destination.getParentFile();
        }
        if (!resultDir.exists() && !resultDir.mkdirs()) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to create %s directory", resultDir.getAbsolutePath()));
            return false;
        }
        if (!resultDir.isDirectory()) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("%s is not a directory", resultDir.getAbsolutePath()));
            return false;
        }
        return true;
    }

    private void pullFilesUsingFilePaths(ITestDevice device, IBuildInfo buildInfo, Map<String, String> filePathMap) throws DeviceNotAvailableException {
        if (filePathMap.isEmpty()) {
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Started pulling file using file path.");
        for (Map.Entry<String, String> entry : filePathMap.entrySet()) {
            this.pullFileUsingFilePath(device, buildInfo, entry.getKey(), entry.getValue());
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Completed pulling file using file path.");
    }

    private void pullFileUsingFilePath(ITestDevice device, IBuildInfo buildInfo, String filePath, String destPath) throws DeviceNotAvailableException {
        if (Strings.isNullOrEmpty((String)filePath) || Strings.isNullOrEmpty((String)destPath)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Either Src or Dest Path is invalid. Source: %s, Destination: %s", filePath, destPath));
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("Started pulling file. Source File: %s, Destination File: %s", filePath, destPath));
        if (!device.doesFileExist(filePath)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("File %s does not exist on the device.", filePath));
            return;
        }
        File destinationFile = this.getDestinationFile(buildInfo, destPath);
        if (destinationFile == null) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to get destination file path for %s.", destPath));
            return;
        }
        if (!this.createResultDir(buildInfo, destinationFile, true)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to create results directory %s.", destPath));
            return;
        }
        boolean isSuccess = device.pullFile(filePath, destinationFile);
        if (!isSuccess) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Failed to pull the file. Source File: %s, Destination File: %s", filePath, destPath));
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("Completed pulling file. Source File: %s, Destination File: %s", filePath, destPath));
    }

    private void pullDirUsingFilePaths(ITestDevice device, IBuildInfo buildInfo, Map<String, String> dirPathMap) throws DeviceNotAvailableException {
        if (dirPathMap.isEmpty()) {
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Started pulling directory using file path.");
        for (Map.Entry<String, String> entry : dirPathMap.entrySet()) {
            this.pullDirectoryUsingDirPath(device, buildInfo, entry.getKey(), entry.getValue());
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Completed pulling directory using file path.");
    }

    private void pullDirectoryUsingDirPath(ITestDevice device, IBuildInfo buildInfo, String dirPath, String destPath) throws DeviceNotAvailableException {
        if (Strings.isNullOrEmpty((String)dirPath) || Strings.isNullOrEmpty((String)destPath)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Either Src or Dest Path is invalid. Source: %s, Destination: %s", dirPath, destPath));
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("Started pulling directory. Source File: %s, Destination File: %s", dirPath, destPath));
        if (!device.doesFileExist(dirPath)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("File %s does not exist on the device.", dirPath));
            return;
        }
        File destinationDir = this.getDestinationFile(buildInfo, destPath);
        if (destinationDir == null) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to get destination file path for %s.", destPath));
            return;
        }
        if (!this.createResultDir(buildInfo, destinationDir, false)) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Unable to create results directory %s.", destPath));
            return;
        }
        boolean isSuccess = device.pullDir(dirPath, destinationDir);
        if (!isSuccess) {
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)String.format("Failed to pull directory. Source Dir: %s, Destination File: %s", dirPath, destPath));
            return;
        }
        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)String.format("Completed pulling directory. Source File: %s, Destination File: %s", dirPath, destPath));
    }
}

