/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.tradefed;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.build.CompatibilityBuildProvider;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import junit.framework.TestCase;

public class CatBoxTradefedTest
extends TestCase {
    private static final String PROPERTY_NAME = "CATBOX_ROOT";
    private static final String SUITE_FULL_NAME = "Complete Automotive Test Suite";
    private static final String SUITE_NAME = "CATBOX";

    public void testSuiteInfoLoad() throws Exception {
        File root = FileUtil.createTempDir((String)"root");
        System.setProperty(PROPERTY_NAME, root.getAbsolutePath());
        File base = new File(root, "android-catbox");
        base.mkdirs();
        File tests = new File(base, "testcases");
        tests.mkdirs();
        CompatibilityBuildProvider provider = new CompatibilityBuildProvider(){

            protected String getSuiteInfoName() {
                return CatBoxTradefedTest.SUITE_NAME;
            }

            protected String getSuiteInfoFullname() {
                return CatBoxTradefedTest.SUITE_FULL_NAME;
            }
        };
        IBuildInfo info = provider.getBuild();
        CompatibilityBuildHelper helper = new CompatibilityBuildHelper(info);
        CatBoxTradefedTest.assertEquals((String)"Incorrect suite full name", (String)SUITE_FULL_NAME, (String)helper.getSuiteFullName());
        CatBoxTradefedTest.assertEquals((String)"Incorrect suite name", (String)SUITE_NAME, (String)helper.getSuiteName());
        FileUtil.recursiveDelete((File)root);
        System.clearProperty(PROPERTY_NAME);
    }
}

