/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.util;

import com.android.compatibility.common.tradefed.testtype.IModuleDef;
import java.util.ArrayList;
import java.util.List;

public class LinearPartition {
    public static List<List<IModuleDef>> split(List<IModuleDef> seq, int k) {
        int i;
        ArrayList<IModuleDef> partition;
        ArrayList<List<IModuleDef>> result = new ArrayList<List<IModuleDef>>();
        if (k <= 0) {
            ArrayList<IModuleDef> partition2 = new ArrayList<IModuleDef>();
            partition2.addAll(seq);
            result.add(partition2);
            return result;
        }
        int n = seq.size() - 1;
        if (k > n) {
            for (IModuleDef value : seq) {
                ArrayList<IModuleDef> partition3 = new ArrayList<IModuleDef>();
                partition3.add(value);
                result.add(partition3);
            }
            return result;
        }
        int[][] table = LinearPartition.buildPartitionTable(seq, k);
        k -= 2;
        while (k >= 0) {
            partition = new ArrayList<IModuleDef>();
            for (i = table[n - 1][k] + 1; i < n + 1; ++i) {
                partition.add(seq.get(i));
            }
            result.add(0, partition);
            n = table[n - 1][k];
            --k;
        }
        partition = new ArrayList();
        for (i = 0; i < n + 1; ++i) {
            partition.add(seq.get(i));
        }
        result.add(0, partition);
        return result;
    }

    private static int[][] buildPartitionTable(List<IModuleDef> seq, int k) {
        int i;
        int n = seq.size();
        float[][] table = new float[n][k];
        int[][] solution = new int[n - 1][k - 1];
        for (i = 0; i < n; ++i) {
            table[i][0] = (float)seq.get(i).getRuntimeHint() + (i > 0 ? table[i - 1][0] : 0.0f);
        }
        for (int j = 0; j < k; ++j) {
            table[0][j] = seq.get(0).getRuntimeHint();
        }
        for (i = 1; i < n; ++i) {
            for (int j = 1; j < k; ++j) {
                table[i][j] = 2.1474836E9f;
                for (int x = 0; x < i; ++x) {
                    float cost = Math.max(table[x][j - 1], table[i][0] - table[x][0]);
                    if (!(table[i][j] > cost)) continue;
                    table[i][j] = cost;
                    solution[i - 1][j - 1] = x;
                }
            }
        }
        return solution;
    }
}

