/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.ResultForwarder;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.RunUtil;

public class FailureListener
extends ResultForwarder {
    private static final int DEFAULT_MAX_LOGCAT_BYTES = 512000;
    public static final int LOGCAT_BYTE_LIMIT = 0x1400000;
    private ITestDevice mDevice;
    private boolean mBugReportOnFailure;
    private boolean mLogcatOnFailure;
    private boolean mScreenshotOnFailure;
    private boolean mRebootOnFailure;
    private int mMaxLogcatBytes;

    public FailureListener(ITestInvocationListener listener, ITestDevice device, boolean bugReportOnFailure, boolean logcatOnFailure, boolean screenshotOnFailure, boolean rebootOnFailure, int maxLogcatBytes) {
        super(new ITestInvocationListener[]{listener});
        this.mDevice = device;
        this.mBugReportOnFailure = bugReportOnFailure;
        this.mLogcatOnFailure = logcatOnFailure;
        this.mScreenshotOnFailure = screenshotOnFailure;
        this.mRebootOnFailure = rebootOnFailure;
        if (maxLogcatBytes < 0) {
            LogUtil.CLog.w((String)"FailureListener could not set %s to '%d', using default value %d", (Object[])new Object[]{"logcat-on-failure-size", maxLogcatBytes, 512000});
            this.mMaxLogcatBytes = 512000;
        } else if (maxLogcatBytes > 0x1400000) {
            LogUtil.CLog.w((String)"Value %d for %s exceeds limit %d, using limit value", (Object[])new Object[]{maxLogcatBytes, "logcat-on-failure-size", 0x1400000});
            this.mMaxLogcatBytes = 0x1400000;
        } else {
            this.mMaxLogcatBytes = maxLogcatBytes;
        }
    }

    public void testFailed(TestDescription test, String trace) {
        super.testFailed(test, trace);
        LogUtil.CLog.i((String)"FailureListener.testFailed %s %b %b %b", (Object[])new Object[]{test.toString(), this.mBugReportOnFailure, this.mLogcatOnFailure, this.mScreenshotOnFailure});
        if (this.mScreenshotOnFailure) {
            try (InputStreamSource screenSource = this.mDevice.getScreenshot();){
                super.testLog(String.format("%s-screenshot", test.toString()), LogDataType.PNG, screenSource);
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((Throwable)e);
                LogUtil.CLog.e((String)"Device %s became unavailable while capturing screenshot", (Object[])new Object[]{this.mDevice.getSerialNumber()});
            }
        }
        if (this.mBugReportOnFailure) {
            int api = -1;
            try {
                api = this.mDevice.getApiLevel();
            }
            catch (DeviceNotAvailableException deviceNotAvailableException) {
                // empty catch block
            }
            if (api < 24) {
                try (InputStreamSource fallback = this.mDevice.getBugreport();){
                    super.testLog(String.format("%s-bugreport", test.toString()), LogDataType.BUGREPORT, fallback);
                }
            }
            try (InputStreamSource bugSource = this.mDevice.getBugreportz();){
                if (bugSource != null) {
                    super.testLog(String.format("%s-bugreportz", test.toString()), LogDataType.BUGREPORTZ, bugSource);
                } else {
                    LogUtil.CLog.e((String)"Failed to capture bugreport for %s", (Object[])new Object[]{test.toString()});
                }
            }
        }
        if (this.mLogcatOnFailure) {
            RunUtil.getDefault().sleep(2000L);
            try (InputStreamSource logSource = this.mDevice.getLogcat(this.mMaxLogcatBytes);){
                super.testLog(String.format("%s-logcat", test.toString()), LogDataType.LOGCAT, logSource);
            }
        }
        if (this.mRebootOnFailure) {
            try {
                if ("user".equals(this.mDevice.getProperty("ro.build.type"))) {
                    LogUtil.CLog.e((String)"Reboot-on-failure should only be used during development, this is a\" user\" build device");
                } else {
                    this.mDevice.reboot();
                }
            }
            catch (DeviceNotAvailableException e) {
                LogUtil.CLog.e((Throwable)e);
                LogUtil.CLog.e((String)"Device %s became unavailable while rebooting", (Object[])new Object[]{this.mDevice.getSerialNumber()});
            }
        }
    }
}

