/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.testtype;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.InvocationFailureHandler;
import com.android.compatibility.common.tradefed.result.SubPlanHelper;
import com.android.compatibility.common.tradefed.targetprep.NetworkConnectivityChecker;
import com.android.compatibility.common.tradefed.testtype.FailureListener;
import com.android.compatibility.common.tradefed.testtype.IModuleDef;
import com.android.compatibility.common.tradefed.testtype.IModuleRepo;
import com.android.compatibility.common.tradefed.testtype.ISubPlan;
import com.android.compatibility.common.tradefed.testtype.ModuleRepo;
import com.android.compatibility.common.tradefed.util.RetryFilterHelper;
import com.android.compatibility.common.tradefed.util.RetryType;
import com.android.compatibility.common.tradefed.util.UniqueModuleCountUtil;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.ResultHandler;
import com.android.compatibility.common.util.TestFilter;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.invoker.InvocationContext;
import com.android.tradefed.log.ITestLogger;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.suite.checker.ISystemStatusChecker;
import com.android.tradefed.suite.checker.ISystemStatusCheckerReceiver;
import com.android.tradefed.suite.checker.StatusCheckerResult;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IInvocationContextReceiver;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IShardableTest;
import com.android.tradefed.testtype.ITestCollector;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.util.AbiFormatter;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TimeUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@Deprecated
@OptionClass(alias="compatibility")
public class CompatibilityTest
implements IDeviceTest,
IShardableTest,
IBuildReceiver,
ISystemStatusCheckerReceiver,
ITestCollector,
IInvocationContextReceiver {
    public static final String INCLUDE_FILTER_OPTION = "include-filter";
    public static final String EXCLUDE_FILTER_OPTION = "exclude-filter";
    public static final String SUBPLAN_OPTION = "subplan";
    public static final String MODULE_OPTION = "module";
    public static final String TEST_OPTION = "test";
    public static final String PRECONDITION_ARG_OPTION = "precondition-arg";
    public static final String MODULE_ARG_OPTION = "module-arg";
    public static final String TEST_ARG_OPTION = "test-arg";
    public static final char TEST_OPTION_SHORT_NAME = 't';
    public static final String RETRY_OPTION = "retry";
    public static final String RETRY_TYPE_OPTION = "retry-type";
    public static final String ABI_OPTION = "abi";
    public static final String SHARD_OPTION = "shards";
    public static final String SKIP_DEVICE_INFO_OPTION = "skip-device-info";
    public static final String SKIP_PRECONDITIONS_OPTION = "skip-preconditions";
    public static final String SKIP_HOST_ARCH_CHECK = "skip-host-arch-check";
    public static final String PRIMARY_ABI_RUN = "primary-abi-only";
    public static final String DEVICE_TOKEN_OPTION = "device-token";
    public static final String LOGCAT_ON_FAILURE_SIZE_OPTION = "logcat-on-failure-size";
    private static final int NUM_PREP_ATTEMPTS = 10;
    private static final int MINUTES_PER_PREP_ATTEMPT = 2;
    @Option(name="subplan", description="the subplan to run", importance=Option.Importance.IF_UNSET)
    private String mSubPlan;
    @Option(name="include-filter", description="the include module filters to apply.", importance=Option.Importance.ALWAYS)
    private Set<String> mIncludeFilters = new HashSet<String>();
    @Option(name="exclude-filter", description="the exclude module filters to apply.", importance=Option.Importance.ALWAYS)
    private Set<String> mExcludeFilters = new HashSet<String>();
    @Option(name="module", shortName=109, description="the test module to run.", importance=Option.Importance.IF_UNSET)
    private String mModuleName = null;
    @Option(name="test", shortName=116, description="the test run.", importance=Option.Importance.IF_UNSET)
    private String mTestName = null;
    @Option(name="precondition-arg", description="the arguments to pass to a precondition. The expected format is\"<arg-name>:<arg-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mPreconditionArgs = new ArrayList<String>();
    @Option(name="module-arg", description="the arguments to pass to a module. The expected format is\"<module-name>:<arg-name>:[<arg-key>:=]<arg-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mModuleArgs = new ArrayList<String>();
    @Option(name="test-arg", description="the arguments to pass to a test. The expected format is\"<test-class>:<arg-name>:[<arg-key>:=]<arg-value>\"", importance=Option.Importance.ALWAYS)
    private List<String> mTestArgs = new ArrayList<String>();
    @Option(name="retry", shortName=114, description="retry a previous session's failed and not executed tests.", importance=Option.Importance.IF_UNSET)
    private Integer mRetrySessionId = null;
    @Option(name="retry-type", description="used with retry, retry tests of a certain status. Possible values include \"failed\", \"not_executed\", and \"custom\".", importance=Option.Importance.IF_UNSET)
    private RetryType mRetryType = null;
    @Option(name="abi", shortName=97, description="the abi to test.", importance=Option.Importance.IF_UNSET)
    private String mAbiName = null;
    @Option(name="shards", description="split the modules up to run on multiple devices concurrently. Deprecated, use --shard-count instead.")
    @Deprecated
    private int mShards = 1;
    @Option(name="skip-device-info", shortName=100, description="Whether device info collection should be skipped")
    private boolean mSkipDeviceInfo = false;
    @Option(name="skip-host-arch-check", description="Whether host architecture check should be skipped")
    private boolean mSkipHostArchCheck = false;
    @Option(name="skip-preconditions", shortName=111, description="Whether preconditions should be skipped")
    private boolean mSkipPreconditions = false;
    @Option(name="primary-abi-only", description="Whether to run tests with only the device primary abi. This override the --abi option.")
    private boolean mPrimaryAbiRun = false;
    @Option(name="device-token", description="Holds the devices' tokens, used when scheduling tests that haveprerequisites such as requiring a SIM card. Format is <serial>:<token>", importance=Option.Importance.ALWAYS)
    private List<String> mDeviceTokens = new ArrayList<String>();
    @Option(name="bugreport-on-failure", description="Take a bugreport on every test failure. Warning: can potentially use a lot of disk space.")
    private boolean mBugReportOnFailure = false;
    @Option(name="logcat-on-failure", description="Take a logcat snapshot on every test failure.")
    private boolean mLogcatOnFailure = false;
    @Option(name="logcat-on-failure-size", description="The max number of logcat data in bytes to capture when --logcat-on-failure is on. Should be an amount that can comfortably fit in memory.")
    private int mMaxLogcatBytes = 512000;
    @Option(name="screenshot-on-failure", description="Take a screenshot on every test failure.")
    private boolean mScreenshotOnFailure = false;
    @Option(name="reboot-before-test", description="Reboot the device before the test suite starts.")
    private boolean mRebootBeforeTest = false;
    @Option(name="reboot-on-failure", description="Reboot the device after every test failure.")
    private boolean mRebootOnFailure = false;
    @Option(name="reboot-per-module", description="Reboot the device before every module run.")
    private boolean mRebootPerModule = false;
    @Option(name="skip-connectivity-check", description="Don't verify device connectivity between module execution.")
    private boolean mSkipConnectivityCheck = false;
    @Option(name="preparer-whitelist", description="Only run specific preparers.Specify zero or more ITargetPreparers as canonical class names. e.g. \"com.android.compatibility.common.tradefed.targetprep.ApkInstaller\" If not specified, all configured preparers are run.")
    private Set<String> mPreparerWhitelist = new HashSet<String>();
    @Option(name="skip-all-system-status-check", description="Whether all system status check between modules should be skipped")
    private boolean mSkipAllSystemStatusCheck = false;
    @Option(name="skip-system-status-check", description="Disable specific system status checkers.Specify zero or more SystemStatusChecker as canonical class names. e.g. \"com.android.compatibility.common.tradefed.targetprep.NetworkConnectivityChecker\" If not specified, all configured or whitelisted system status checkers are run.")
    private Set<String> mSystemStatusCheckBlacklist = new HashSet<String>();
    @Option(name="system-status-check-whitelist", description="Only run specific system status checkers.Specify zero or more SystemStatusChecker as canonical class names. e.g. \"com.android.compatibility.common.tradefed.targetprep.NetworkConnectivityChecker\" If not specified, all configured system status checkers are run.")
    private Set<String> mSystemStatusCheckWhitelist = new HashSet<String>();
    private List<ISystemStatusChecker> mListCheckers = new ArrayList<ISystemStatusChecker>();
    @Option(name="collect-tests-only", description="Only invoke the suite to collect list of applicable test cases. All test run callbacks will be triggered, but test execution will not be actually carried out.")
    private Boolean mCollectTestsOnly = null;
    @Option(name="module-metadata-include-filter", description="Include modules for execution based on matching of metadata fields: for any of the specified filter name and value, if a module has a metadata field with the same name and value, it will be included. When both module inclusion and exclusion rules are applied, inclusion rules will be evaluated first. Using this together with test filter inclusion rules may result in no tests to execute if the rules don't overlap.")
    private MultiMap<String, String> mModuleMetadataIncludeFilter = new MultiMap();
    @Option(name="module-metadata-exclude-filter", description="Exclude modules for execution based on matching of metadata fields: for any of the specified filter name and value, if a module has a metadata field with the same name and value, it will be excluded. When both module inclusion and exclusion rules are applied, inclusion rules will be evaluated first.")
    private MultiMap<String, String> mModuleMetadataExcludeFilter = new MultiMap();
    private int mTotalShards;
    private Integer mShardIndex = null;
    private IModuleRepo mModuleRepo;
    private ITestDevice mDevice;
    private CompatibilityBuildHelper mBuildHelper;
    private static CountDownLatch sPreparedLatch;
    private boolean mIsLocalSharding = false;
    private boolean mIsSharded = false;
    private IInvocationContext mInvocationContext;

    public CompatibilityTest() {
        this(1, new ModuleRepo(), 0);
    }

    public CompatibilityTest(int totalShards, IModuleRepo moduleRepo, Integer shardIndex) {
        if (totalShards < 1) {
            throw new IllegalArgumentException("Must be at least 1 shard. Given:" + totalShards);
        }
        this.mTotalShards = totalShards;
        this.mModuleRepo = moduleRepo;
        this.mShardIndex = shardIndex;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void setBuild(IBuildInfo buildInfo) {
        this.mBuildHelper = new CompatibilityBuildHelper(buildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ITestInvocationListener listener) throws DeviceNotAvailableException {
        try {
            ArrayList<ISystemStatusChecker> checkers = new ArrayList<ISystemStatusChecker>();
            if (this.mSkipAllSystemStatusCheck) {
                LogUtil.CLog.d((String)"Skipping system status checkers");
            } else {
                this.checkSystemStatusBlackAndWhiteList();
                for (ISystemStatusChecker checker : this.mListCheckers) {
                    if (!this.shouldIncludeSystemStatusChecker(checker)) continue;
                    checkers.add(checker);
                }
            }
            LinkedList<IModuleDef> modules = this.initializeModuleRepo();
            this.mExcludeFilters.clear();
            this.mIncludeFilters.clear();
            if (this.mRetrySessionId != null) {
                this.loadRetryCommandLineArgs(this.mRetrySessionId);
            }
            listener = new FailureListener((ITestInvocationListener)listener, this.getDevice(), this.mBugReportOnFailure, this.mLogcatOnFailure, this.mScreenshotOnFailure, this.mRebootOnFailure, this.mMaxLogcatBytes);
            int moduleCount = modules.size();
            if (moduleCount == 0) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"No module to run on %s.", (Object[])new Object[]{this.mDevice.getSerialNumber()});
                if (sPreparedLatch != null) {
                    sPreparedLatch.countDown();
                }
                return;
            }
            int uniqueModuleCount = UniqueModuleCountUtil.countUniqueModules(modules);
            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Starting %d test sub-module%s on %s", (Object[])new Object[]{uniqueModuleCount, uniqueModuleCount > 1 ? "s" : "", this.mDevice.getSerialNumber()});
            if (this.mRebootBeforeTest) {
                LogUtil.CLog.d((String)"Rebooting device before test starts as requested.");
                this.mDevice.reboot();
            }
            if (this.mSkipConnectivityCheck) {
                String clazz = NetworkConnectivityChecker.class.getCanonicalName();
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"\"--skip-connectivity-check\" is deprecated, please use \"--skip-system-status-check %s\" instead", (Object[])new Object[]{clazz});
                this.mSystemStatusCheckBlacklist.add(clazz);
            }
            boolean isPrepared = true;
            for (int i = 0; i < moduleCount; ++i) {
                IModuleDef module = modules.get(i);
                module.setBuild(this.mBuildHelper.getBuildInfo());
                module.setDevice(this.mDevice);
                module.setPreparerWhitelist(this.mPreparerWhitelist);
                if (this.mCollectTestsOnly != null) {
                    module.setCollectTestsOnly(this.mCollectTestsOnly);
                }
                isPrepared &= module.prepare(this.mSkipPreconditions, this.mPreconditionArgs);
            }
            if (!isPrepared) {
                throw new RuntimeException(String.format("Failed preconditions on %s", this.mDevice.getSerialNumber()));
            }
            if (this.mIsLocalSharding) {
                try {
                    sPreparedLatch.countDown();
                    int attempt = 1;
                    while (!sPreparedLatch.await(2L, TimeUnit.MINUTES)) {
                        if (attempt > 10 || InvocationFailureHandler.hasFailed(this.mBuildHelper)) {
                            LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.ERROR, (String)"Incorrect preparation detected, exiting test run from %s", (Object[])new Object[]{this.mDevice.getSerialNumber()});
                            return;
                        }
                        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)"waiting on preconditions");
                        ++attempt;
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.mModuleRepo.tearDown();
            this.mModuleRepo = null;
            while (!modules.isEmpty()) {
                IModuleDef module = modules.poll();
                long start = System.currentTimeMillis();
                if (this.mRebootPerModule) {
                    if ("user".equals(this.mDevice.getProperty("ro.build.type"))) {
                        LogUtil.CLog.e((String)"reboot-per-module should only be used during development, this is a\" user\" build device");
                    } else {
                        LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Rebooting device before starting next module");
                        this.mDevice.reboot();
                    }
                }
                if (checkers != null && !checkers.isEmpty()) {
                    this.runPreModuleCheck(module.getName(), checkers, this.mDevice, (ITestLogger)listener);
                }
                InvocationContext moduleContext = new InvocationContext();
                moduleContext.setConfigurationDescriptor(module.getConfigurationDescriptor());
                moduleContext.addInvocationAttribute("module-name", module.getName());
                moduleContext.addInvocationAttribute("module-abi", module.getAbi().getName());
                moduleContext.addInvocationAttribute("module-id", String.format("%s %s", module.getAbi().getName(), module.getName()));
                this.mInvocationContext.setModuleInvocationContext((IInvocationContext)moduleContext);
                for (String deviceName : this.mInvocationContext.getDeviceConfigNames()) {
                    moduleContext.addAllocatedDevice(deviceName, this.mInvocationContext.getDevice(deviceName));
                    moduleContext.addDeviceBuildInfo(deviceName, this.mInvocationContext.getBuildInfo(deviceName));
                }
                module.setInvocationContext((IInvocationContext)moduleContext);
                try {
                    listener.testModuleStarted((IInvocationContext)moduleContext);
                    module.run((ITestInvocationListener)listener);
                }
                catch (DeviceUnresponsiveException due) {
                    ByteArrayOutputStream stack = new ByteArrayOutputStream();
                    due.printStackTrace(new PrintWriter(stack, true));
                    StreamUtil.close((Closeable)stack);
                    LogUtil.CLog.w((String)"Ignored DeviceUnresponsiveException because recovery was successful, proceeding with next module. Stack trace: %s", (Object[])new Object[]{stack.toString()});
                    LogUtil.CLog.w((String)"This may be due to incorrect timeout setting on module %s", (Object[])new Object[]{module.getName()});
                }
                finally {
                    this.mInvocationContext.setModuleInvocationContext(null);
                    listener.testModuleEnded();
                }
                long duration = System.currentTimeMillis() - start;
                long expected = module.getRuntimeHint();
                long delta = Math.abs(duration - expected);
                if (expected > 0L && (float)delta / (float)expected > 0.1f) {
                    LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)"Inaccurate runtime hint for %s, expected %s was %s", (Object[])new Object[]{module.getId(), TimeUtil.formatElapsedTime((long)expected), TimeUtil.formatElapsedTime((long)duration)});
                }
                if (checkers != null && !checkers.isEmpty()) {
                    this.runPostModuleCheck(module.getName(), checkers, this.mDevice, (ITestLogger)listener);
                }
                module = null;
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new RuntimeException("Failed to initialize modules", fnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LinkedList<IModuleDef> initializeModuleRepo() throws DeviceNotAvailableException, FileNotFoundException {
        IModuleRepo iModuleRepo = this.mModuleRepo;
        synchronized (iModuleRepo) {
            if (!this.mModuleRepo.isInitialized()) {
                this.setupFilters();
                this.mModuleRepo.initialize(this.mTotalShards, this.mShardIndex, this.mBuildHelper.getTestsDir(), this.getAbis(), this.mDeviceTokens, this.mTestArgs, this.mModuleArgs, this.mIncludeFilters, this.mExcludeFilters, this.mModuleMetadataIncludeFilter, this.mModuleMetadataExcludeFilter, this.mBuildHelper.getBuildInfo());
                this.mBuildHelper.setModuleIds(this.mModuleRepo.getModuleIds());
                int count = UniqueModuleCountUtil.countUniqueModules(this.mModuleRepo.getTokenModules()) + UniqueModuleCountUtil.countUniqueModules(this.mModuleRepo.getNonTokenModules());
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"========================================");
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"Starting a run with %s unique modules.", (Object[])new Object[]{count});
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)"========================================");
            } else {
                LogUtil.CLog.d((String)"ModuleRepo already initialized.");
            }
            return this.mModuleRepo.getModules(this.getDevice().getSerialNumber(), this.mShardIndex);
        }
    }

    Set<IAbi> getAbis() throws DeviceNotAvailableException {
        LinkedHashSet<IAbi> abis = new LinkedHashSet<IAbi>();
        Set<String> archAbis = this.getAbisForBuildTargetArch();
        if (this.mPrimaryAbiRun) {
            if (this.mAbiName == null) {
                this.mAbiName = this.mDevice.getProperty("ro.product.cpu.abi").trim();
            } else {
                LogUtil.CLog.d((String)"Option --%s supersedes the option --%s, using abi: %s", (Object[])new Object[]{ABI_OPTION, PRIMARY_ABI_RUN, this.mAbiName});
            }
        }
        if (this.mAbiName != null) {
            if (!this.mSkipHostArchCheck && !archAbis.contains(this.mAbiName) || !AbiUtils.isAbiSupportedByCompatibility((String)this.mAbiName)) {
                throw new IllegalArgumentException(String.format("Your CTS hasn't been built with abi '%s' support, this CTS currently supports '%s'.", this.mAbiName, archAbis));
            }
            abis.add((IAbi)new Abi(this.mAbiName, AbiUtils.getBitness((String)this.mAbiName)));
            return abis;
        }
        List<String> deviceAbis = Arrays.asList(AbiFormatter.getSupportedAbis((ITestDevice)this.mDevice, (String)""));
        for (String abi : deviceAbis) {
            if ((this.mSkipHostArchCheck || archAbis.contains(abi)) && AbiUtils.isAbiSupportedByCompatibility((String)abi)) {
                abis.add((IAbi)new Abi(abi, AbiUtils.getBitness((String)abi)));
                continue;
            }
            LogUtil.CLog.d((String)"abi '%s' is supported by device but not by this CTS build (%s), tests will not run against it.", (Object[])new Object[]{abi, archAbis});
        }
        if (abis.isEmpty()) {
            throw new IllegalArgumentException(String.format("None of the abi supported by this CTS build ('%s') are supported by the device ('%s').", archAbis, deviceAbis));
        }
        return abis;
    }

    protected Set<String> getAbisForBuildTargetArch() {
        return AbiUtils.getAbisForArch((String)((String)TestSuiteInfo.getInstance().getTargetArchs().get(0)));
    }

    protected void checkSystemStatusBlackAndWhiteList() {
        for (String checker : this.mSystemStatusCheckWhitelist) {
            try {
                Class.forName(checker);
            }
            catch (ClassNotFoundException e) {
                ConfigurationException ex = new ConfigurationException(String.format("--system-status-check-whitelist must contains valid class, %s was not found", checker), (Throwable)e);
                throw new RuntimeException(ex);
            }
        }
        for (String checker : this.mSystemStatusCheckBlacklist) {
            try {
                Class.forName(checker);
            }
            catch (ClassNotFoundException e) {
                ConfigurationException ex = new ConfigurationException(String.format("--skip-system-status-check must contains valid class, %s was not found", checker), (Throwable)e);
                throw new RuntimeException(ex);
            }
        }
    }

    private boolean shouldIncludeSystemStatusChecker(ISystemStatusChecker s) {
        String clazz = s.getClass().getCanonicalName();
        boolean shouldInclude = this.mSystemStatusCheckWhitelist.isEmpty() || this.mSystemStatusCheckWhitelist.contains(clazz);
        boolean shouldExclude = !this.mSystemStatusCheckBlacklist.isEmpty() && this.mSystemStatusCheckBlacklist.contains(clazz);
        return shouldInclude && !shouldExclude;
    }

    @VisibleForTesting
    void runPreModuleCheck(String moduleName, List<ISystemStatusChecker> checkers, ITestDevice device, ITestLogger logger) throws DeviceNotAvailableException {
        LogUtil.CLog.i((String)"Running system status checker before module execution: %s", (Object[])new Object[]{moduleName});
        ArrayList<String> failures = new ArrayList<String>();
        for (ISystemStatusChecker checker : checkers) {
            StatusCheckerResult result = checker.preExecutionCheck(device);
            if (StatusCheckerResult.CheckStatus.SUCCESS.equals((Object)result.getStatus())) continue;
            failures.add(checker.getClass().getCanonicalName());
            LogUtil.CLog.w((String)"System status checker [%s] failed", (Object[])new Object[]{checker.getClass().getCanonicalName()});
        }
        if (!failures.isEmpty()) {
            LogUtil.CLog.w((String)"There are failed system status checkers: %s capturing a bugreport", (Object[])new Object[]{((Object)failures).toString()});
            try (InputStreamSource bugSource = device.getBugreport();){
                logger.testLog(String.format("bugreport-checker-pre-module-%s", moduleName), LogDataType.BUGREPORT, bugSource);
            }
        }
    }

    @VisibleForTesting
    void runPostModuleCheck(String moduleName, List<ISystemStatusChecker> checkers, ITestDevice device, ITestLogger logger) throws DeviceNotAvailableException {
        LogUtil.CLog.i((String)"Running system status checker after module execution: %s", (Object[])new Object[]{moduleName});
        ArrayList<String> failures = new ArrayList<String>();
        for (ISystemStatusChecker checker : checkers) {
            StatusCheckerResult result = checker.postExecutionCheck(device);
            if (StatusCheckerResult.CheckStatus.SUCCESS.equals((Object)result.getStatus())) continue;
            failures.add(checker.getClass().getCanonicalName());
            LogUtil.CLog.w((String)"System status checker [%s] failed", (Object[])new Object[]{checker.getClass().getCanonicalName()});
        }
        if (!failures.isEmpty()) {
            LogUtil.CLog.w((String)"There are failed system status checkers: %s capturing a bugreport", (Object[])new Object[]{((Object)failures).toString()});
            try (InputStreamSource bugSource = device.getBugreport();){
                logger.testLog(String.format("bugreport-checker-post-module-%s", moduleName), LogDataType.BUGREPORT, bugSource);
            }
        }
    }

    void loadRetryCommandLineArgs(Integer sessionId) {
        IInvocationResult result = null;
        try {
            result = ResultHandler.findResult((File)this.mBuildHelper.getResultsDir(), (Integer)sessionId);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Could not find session with id %d", sessionId));
        }
        String retryCommandLineArgs = result.getCommandLineArgs();
        if (retryCommandLineArgs != null) {
            this.mBuildHelper.setRetryCommandLineArgs(retryCommandLineArgs);
        }
    }

    void setupFilters() throws DeviceNotAvailableException {
        if (this.mRetrySessionId != null) {
            RetryFilterHelper helper = this.createRetryFilterHelper(this.mRetrySessionId);
            helper.validateBuildFingerprint(this.mDevice);
            helper.setCommandLineOptionsFor(this);
            helper.populateRetryFilters();
            this.mIncludeFilters = helper.getIncludeFilters();
            this.mExcludeFilters = helper.getExcludeFilters();
            helper.tearDown();
        } else {
            if (this.mSubPlan != null) {
                ISubPlan subPlan = SubPlanHelper.getSubPlanByName(this.mBuildHelper, this.mSubPlan);
                this.mIncludeFilters.addAll(subPlan.getIncludeFilters());
                this.mExcludeFilters.addAll(subPlan.getExcludeFilters());
            }
            if (this.mModuleName != null) {
                try {
                    List<String> modules = ModuleRepo.getModuleNamesMatching(this.mBuildHelper.getTestsDir(), this.mModuleName);
                    if (modules.size() == 0) {
                        throw new IllegalArgumentException(String.format("No modules found matching %s", this.mModuleName));
                    }
                    if (modules.size() > 1) {
                        throw new IllegalArgumentException(String.format("Multiple modules found matching %s:\n%s\nWhich one did you mean?\n", this.mModuleName, ArrayUtil.join((String)"\n", (Object[])new Object[]{modules})));
                    }
                    String module = modules.get(0);
                    CompatibilityTest.cleanFilters(this.mIncludeFilters, module);
                    CompatibilityTest.cleanFilters(this.mExcludeFilters, module);
                    this.mIncludeFilters.add(new TestFilter(this.mAbiName, module, this.mTestName).toString());
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            } else if (this.mTestName != null) {
                throw new IllegalArgumentException("Test name given without module name. Add --module <module-name>");
            }
        }
    }

    protected RetryFilterHelper createRetryFilterHelper(Integer retrySessionId) {
        return new RetryFilterHelper(this.mBuildHelper, retrySessionId, this.mSubPlan, this.mIncludeFilters, this.mExcludeFilters, this.mAbiName, this.mModuleName, this.mTestName, this.mRetryType);
    }

    private static void cleanFilters(Set<String> filters, String module) {
        HashSet<String> cleanedFilters = new HashSet<String>();
        for (String filter : filters) {
            if (!module.equals(TestFilter.createFrom((String)filter).getName())) continue;
            cleanedFilters.add(filter);
        }
        filters.clear();
        filters.addAll(cleanedFilters);
    }

    public Collection<IRemoteTest> split() {
        if (this.mShards <= 1) {
            return null;
        }
        this.mIsLocalSharding = true;
        LinkedList<IRemoteTest> shardQueue = new LinkedList<IRemoteTest>();
        for (int i = 0; i < this.mShards; ++i) {
            CompatibilityTest test = (CompatibilityTest)this.getTestShard(this.mShards, i);
            test.mIsLocalSharding = true;
            shardQueue.add((IRemoteTest)test);
        }
        sPreparedLatch = new CountDownLatch(shardQueue.size());
        return shardQueue;
    }

    public Collection<IRemoteTest> split(int shardCount) {
        if (shardCount <= 1 || this.mIsSharded) {
            return null;
        }
        this.mIsSharded = true;
        LinkedList<IRemoteTest> shardQueue = new LinkedList<IRemoteTest>();
        for (int i = 0; i < shardCount; ++i) {
            CompatibilityTest test = (CompatibilityTest)this.getTestShard(shardCount, i);
            shardQueue.add((IRemoteTest)test);
            test.mIsSharded = true;
        }
        return shardQueue;
    }

    private IRemoteTest getTestShard(int shardCount, int shardIndex) {
        CompatibilityTest test = new CompatibilityTest(shardCount, this.mModuleRepo, shardIndex);
        OptionCopier.copyOptionsNoThrow((Object)this, (Object)test);
        test.mShards = 0;
        return test;
    }

    public void setSystemStatusChecker(List<ISystemStatusChecker> systemCheckers) {
        this.mListCheckers = systemCheckers;
    }

    public void setCollectTestsOnly(boolean collectTestsOnly) {
        this.mCollectTestsOnly = collectTestsOnly;
    }

    public void setIncludeFilter(Set<String> includeFilters) {
        this.mIncludeFilters.addAll(includeFilters);
    }

    public void setExcludeFilter(Set<String> excludeFilters) {
        this.mExcludeFilters.addAll(excludeFilters);
    }

    public void setInvocationContext(IInvocationContext invocationContext) {
        this.mInvocationContext = invocationContext;
    }

    protected String getSubPlan() {
        return this.mSubPlan;
    }

    protected Set<String> getIncludeFilters() {
        return this.mIncludeFilters;
    }

    protected Set<String> getExcludeFilters() {
        return this.mExcludeFilters;
    }

    protected String getModuleName() {
        return this.mModuleName;
    }

    protected String getTestName() {
        return this.mTestName;
    }

    protected List<String> getModuleArgs() {
        return this.mModuleArgs;
    }

    protected List<String> getTestArgs() {
        return this.mTestArgs;
    }

    protected RetryType getRetryType() {
        return this.mRetryType;
    }

    protected String getAbiName() {
        return this.mAbiName;
    }

    protected List<String> getDeviceTokens() {
        return this.mDeviceTokens;
    }

    protected MultiMap<String, String> getModuleMetadataIncludeFilter() {
        return this.mModuleMetadataIncludeFilter;
    }

    protected MultiMap<String, String> getModuleMetadataExcludeFilter() {
        return this.mModuleMetadataExcludeFilter;
    }

    protected int getTotalShards() {
        return this.mTotalShards;
    }

    protected Integer getShardIndex() {
        return this.mShardIndex;
    }

    protected CompatibilityBuildHelper getBuildHelper() {
        return this.mBuildHelper;
    }

    protected IInvocationContext getInvocationContext() {
        return this.mInvocationContext;
    }

    protected IModuleRepo getModuleRepo() {
        return this.mModuleRepo;
    }
}

