/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result.suite;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class PreviousSessionFileCopier
implements ITestInvocationListener {
    private static final List<String> NOT_RETRY_FILES = Arrays.asList("checksum.data", "checksum.previous.data", "test_result_failures.html", "test_result.html", "test_result_failures_suite.html", "invocation_summary.txt", "checksum-suite.data", "diffs", "proto");
    private CompatibilityBuildHelper mBuildHelper;
    private File mPreviousSessionDir = null;

    public void setPreviousSessionDir(File previousSessionDir) {
        this.mPreviousSessionDir = previousSessionDir;
    }

    public void invocationStarted(IInvocationContext context) {
        if (this.mBuildHelper == null) {
            this.mBuildHelper = this.createCompatibilityHelper((IBuildInfo)context.getBuildInfos().get(0));
        }
    }

    public void invocationEnded(long elapsedTime) {
        if (this.mPreviousSessionDir == null) {
            LogUtil.CLog.e((String)"Could not copy previous sesson files.");
            return;
        }
        File resultDir = this.getResultDirectory();
        this.copyRetryFiles(this.mPreviousSessionDir, resultDir);
    }

    protected CompatibilityBuildHelper createCompatibilityHelper(IBuildInfo info) {
        return new CompatibilityBuildHelper(info);
    }

    private void copyRetryFiles(File oldDir, File newDir) {
        File[] oldChildren;
        for (File oldChild : oldChildren = oldDir.listFiles()) {
            if (NOT_RETRY_FILES.contains(oldChild.getName())) continue;
            File newChild = new File(newDir, oldChild.getName());
            if (!newChild.exists()) {
                try {
                    LogUtil.CLog.d((String)"Copying %s to new session.", (Object[])new Object[]{oldChild.getName()});
                    if (oldChild.isDirectory()) {
                        FileUtil.recursiveCopy((File)oldChild, (File)newChild);
                        continue;
                    }
                    FileUtil.copyFile((File)oldChild, (File)newChild);
                }
                catch (IOException e) {
                    LogUtil.CLog.w((String)"Failed to copy file \"%s\" from previous session", (Object[])new Object[]{oldChild.getName()});
                }
                continue;
            }
            if (!oldChild.isDirectory() || !newChild.isDirectory()) continue;
            this.copyRetryFiles(oldChild, newChild);
        }
    }

    private File getResultDirectory() {
        File resultDir = null;
        try {
            resultDir = this.mBuildHelper.getResultDir();
            if (resultDir != null) {
                resultDir.mkdirs();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (resultDir == null) {
            throw new RuntimeException("Result Directory was not created");
        }
        if (!resultDir.exists()) {
            throw new RuntimeException("Result Directory was not created: " + resultDir.getAbsolutePath());
        }
        LogUtil.CLog.d((String)"Results Directory: %s", (Object[])new Object[]{resultDir.getAbsolutePath()});
        return resultDir;
    }
}

