/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.result.InvocationFailureHandler;
import com.android.compatibility.common.tradefed.result.TestRunHandler;
import com.android.compatibility.common.tradefed.util.FingerprintComparisonException;
import com.android.compatibility.common.tradefed.util.RetryType;
import com.android.compatibility.common.util.ICaseResult;
import com.android.compatibility.common.util.IInvocationResult;
import com.android.compatibility.common.util.IModuleResult;
import com.android.compatibility.common.util.ITestResult;
import com.android.compatibility.common.util.InvocationResult;
import com.android.compatibility.common.util.MetricsStore;
import com.android.compatibility.common.util.ReportLog;
import com.android.compatibility.common.util.ResultHandler;
import com.android.compatibility.common.util.ResultUploader;
import com.android.compatibility.common.util.TestStatus;
import com.android.ddmlib.Log;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationReceiver;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionClass;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.FileInputStreamSource;
import com.android.tradefed.result.ILogSaver;
import com.android.tradefed.result.ILogSaverListener;
import com.android.tradefed.result.IShardableListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFile;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.result.suite.SuiteResultReporter;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.ZipUtil;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.xml.XmlEscapers;
import com.google.gson.Gson;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.xmlpull.v1.XmlPullParserException;

@OptionClass(alias="result-reporter")
public class ResultReporter
implements ILogSaverListener,
ITestInvocationListener,
ITestSummaryListener,
IShardableListener,
IConfigurationReceiver {
    public static final String INCLUDE_HTML_IN_ZIP = "html-in-zip";
    private static final String UNKNOWN_DEVICE = "unknown_device";
    private static final String RESULT_KEY = "COMPATIBILITY_TEST_RESULT";
    private static final String CTS_PREFIX = "cts:";
    private static final String BUILD_INFO = "cts:build_";
    private static final String LATEST_LINK_NAME = "latest";
    private static final String RUN_HISTORY_KEY = "run_history";
    public static final String BUILD_BRAND = "build_brand";
    public static final String BUILD_DEVICE = "build_device";
    public static final String BUILD_FINGERPRINT = "build_fingerprint";
    public static final String BUILD_ID = "build_id";
    public static final String BUILD_MANUFACTURER = "build_manufacturer";
    public static final String BUILD_MODEL = "build_model";
    public static final String BUILD_PRODUCT = "build_product";
    public static final String BUILD_VERSION_RELEASE = "build_version_release";
    private static final List<String> NOT_RETRY_FILES = Arrays.asList("checksum.data", "checksum.previous.data", "test_result_failures.html", "diffs");
    @Option(name="retry", shortName=114, description="retry a previous session.", importance=Option.Importance.IF_UNSET)
    private Integer mRetrySessionId = null;
    @Option(name="retry-type", description="used with retry, retry tests of a certain status. Possible values include \"failed\", \"not_executed\", and \"custom\".", importance=Option.Importance.IF_UNSET)
    private RetryType mRetryType = null;
    @Option(name="result-server", description="Server to publish test results.")
    private String mResultServer;
    @Option(name="disable-result-posting", description="Disable result posting into report server.")
    private boolean mDisableResultPosting = false;
    @Option(name="include-test-log-tags", description="Include test log tags in report.")
    private boolean mIncludeTestLogTags = false;
    @Option(name="use-log-saver", description="Also saves generated result with log saver")
    private boolean mUseLogSaver = false;
    @Option(name="compress-logs", description="Whether logs will be saved with compression")
    private boolean mCompressLogs = true;
    @Option(name="html-in-zip", description="Whether failure summary report is included in the zip fie.")
    private boolean mIncludeHtml = false;
    @Option(name="result-attribute", description="Extra key-value pairs to be added as attributes and correspondingvalues of the \"Result\" tag in the result XML.")
    private Map<String, String> mResultAttributes = new HashMap<String, String>();
    private CompatibilityBuildHelper mBuildHelper;
    private File mResultDir = null;
    private File mLogDir = null;
    private ResultUploader mUploader;
    private String mReferenceUrl;
    private ILogSaver mLogSaver;
    private int invocationEndedCount = 0;
    private CountDownLatch mFinalized = null;
    protected IInvocationResult mResult = new InvocationResult();
    private IModuleResult mCurrentModuleResult;
    private ICaseResult mCurrentCaseResult;
    private ITestResult mCurrentResult;
    private String mDeviceSerial = "unknown_device";
    private Set<String> mMasterDeviceSerials = new HashSet<String>();
    private Set<IBuildInfo> mMasterBuildInfos = new HashSet<IBuildInfo>();
    private boolean mFingerprintFailure = false;
    private int mCurrentTestNum;
    private int mTotalTestsInModule;
    protected boolean mCanMarkDone;
    protected boolean mTestRunFailed;
    private boolean mModuleWasDone;
    private final ResultReporter mMasterResultReporter;
    private LogFileSaver mTestLogSaver;
    private long mElapsedTime;
    private IConfiguration mConfiguration = null;

    public ResultReporter() {
        this(null);
        this.mFinalized = new CountDownLatch(1);
    }

    public ResultReporter(ResultReporter masterResultReporter) {
        this.mMasterResultReporter = masterResultReporter;
    }

    public void setConfiguration(IConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationStarted(IInvocationContext context) {
        IBuildInfo primaryBuild = (IBuildInfo)context.getBuildInfos().get(0);
        ResultReporter resultReporter = this;
        synchronized (resultReporter) {
            if (this.mBuildHelper == null) {
                this.mBuildHelper = new CompatibilityBuildHelper(primaryBuild);
            }
            if (this.mDeviceSerial == null && primaryBuild.getDeviceSerial() != null) {
                this.mDeviceSerial = primaryBuild.getDeviceSerial();
            }
            this.mCanMarkDone = this.canMarkDone(this.mBuildHelper.getRecentCommandLineArgs());
        }
        if (this.isShardResultReporter()) {
            this.mMasterResultReporter.invocationStarted(context);
            return;
        }
        resultReporter = this;
        synchronized (resultReporter) {
            if (primaryBuild.getDeviceSerial() != null) {
                this.mMasterDeviceSerials.add(primaryBuild.getDeviceSerial());
            }
            this.mMasterBuildInfos.add(primaryBuild);
            if (this.mResultDir == null) {
                this.initializeResultDirectories();
            }
        }
    }

    private void initializeResultDirectories() {
        ResultReporter.debug("Initializing result directory", new Object[0]);
        try {
            if (this.mRetrySessionId != null) {
                this.mResult = ResultHandler.findResult((File)this.mBuildHelper.getResultsDir(), (Integer)this.mRetrySessionId);
            }
            this.mResult.setStartTime(this.mBuildHelper.getStartTime());
            this.mResultDir = this.mBuildHelper.getResultDir();
            if (this.mResultDir != null) {
                this.mResultDir.mkdirs();
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        if (this.mResultDir == null) {
            throw new RuntimeException("Result Directory was not created");
        }
        if (!this.mResultDir.exists()) {
            throw new RuntimeException("Result Directory was not created: " + this.mResultDir.getAbsolutePath());
        }
        ResultReporter.debug("Results Directory: %s", this.mResultDir.getAbsolutePath());
        this.mUploader = new ResultUploader(this.mResultServer, this.mBuildHelper.getSuiteName());
        try {
            this.mLogDir = new File(this.mBuildHelper.getLogsDir(), CompatibilityBuildHelper.getDirSuffix(this.mBuildHelper.getStartTime()));
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e((Throwable)e);
        }
        if (this.mLogDir != null && this.mLogDir.mkdirs()) {
            ResultReporter.debug("Created log dir %s", this.mLogDir.getAbsolutePath());
        }
        if (this.mLogDir == null || !this.mLogDir.exists()) {
            throw new IllegalArgumentException(String.format("Could not create log dir %s", this.mLogDir.getAbsolutePath()));
        }
        if (this.mTestLogSaver == null) {
            this.mTestLogSaver = new LogFileSaver(this.mLogDir);
        }
    }

    public void testRunStarted(String id, int numTests) {
        if (this.mCurrentModuleResult != null && this.mCurrentModuleResult.getId().equals(id) && this.mCurrentModuleResult.isDone()) {
            this.mTotalTestsInModule += numTests;
        } else {
            this.mCurrentModuleResult = this.mResult.getOrCreateModule(id);
            this.mModuleWasDone = this.mCurrentModuleResult.isDone();
            this.mTestRunFailed = false;
            if (!this.mModuleWasDone) {
                if (this.mCurrentModuleResult.getExpectedTestRuns() == 0) {
                    this.mCurrentModuleResult.setExpectedTestRuns(TestRunHandler.getTestRuns(this.mBuildHelper, this.mCurrentModuleResult.getId()));
                }
                this.mCurrentModuleResult.addTestRun();
            }
            this.mTotalTestsInModule = numTests;
            this.mCurrentTestNum = 0;
        }
        this.mCurrentModuleResult.inProgress(true);
    }

    public void testStarted(TestDescription test) {
        this.mCurrentCaseResult = this.mCurrentModuleResult.getOrCreateResult(test.getClassName());
        this.mCurrentResult = this.mCurrentCaseResult.getOrCreateResult(test.getTestName().trim());
        if (this.mCurrentResult.isRetry()) {
            this.mCurrentResult.reset();
        }
        ++this.mCurrentTestNum;
    }

    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> metrics) {
        if (this.mCurrentResult.getResultStatus() == TestStatus.FAIL) {
            return;
        }
        MetricMeasurement.Metric perfResult = metrics.get(RESULT_KEY);
        ReportLog report = null;
        if (perfResult != null) {
            try {
                report = ReportLog.parse((String)perfResult.getMeasurements().getSingleString());
            }
            catch (IOException | XmlPullParserException e) {
                e.printStackTrace();
            }
        } else {
            report = MetricsStore.removeResult((IBuildInfo)this.mBuildHelper.getBuildInfo(), (String)this.mCurrentModuleResult.getAbi(), (String)test.toString());
        }
        if (this.mCurrentResult.getResultStatus() == null) {
            this.mCurrentResult.passed(report);
        }
    }

    public void testIgnored(TestDescription test) {
        this.mCurrentResult.skipped();
    }

    public void testFailed(TestDescription test, String trace) {
        this.mCurrentResult.failed(ResultReporter.sanitizeXmlContent(trace));
    }

    public void testAssumptionFailure(TestDescription test, String trace) {
        this.mCurrentResult.skipped();
    }

    public void testRunStopped(long elapsedTime) {
    }

    public void testRunEnded(long elapsedTime, Map<String, String> metrics) {
        this.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(metrics));
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> metrics) {
        this.mCurrentModuleResult.inProgress(false);
        this.mCurrentModuleResult.addRuntime(elapsedTime);
        if (!this.mModuleWasDone && this.mCanMarkDone) {
            if (this.mTestRunFailed) {
                this.mCurrentModuleResult.setDone(false);
            } else {
                this.mCurrentModuleResult.setDone(this.mCurrentTestNum >= this.mTotalTestsInModule);
            }
        }
        if (this.isShardResultReporter()) {
            this.mMasterResultReporter.mergeModuleResult(this.mCurrentModuleResult);
            this.mCurrentModuleResult.resetTestRuns();
            this.mCurrentModuleResult.resetRuntime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeModuleResult(IModuleResult moduleResult) {
        ResultReporter resultReporter = this;
        synchronized (resultReporter) {
            this.mResult.mergeModuleResult(moduleResult);
        }
    }

    public void testRunFailed(String errorMessage) {
        this.mTestRunFailed = true;
        this.mCurrentModuleResult.setFailed();
    }

    public TestSummary getSummary() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSummary(List<TestSummary> summaries) {
        for (TestSummary summary : summaries) {
            if (SuiteResultReporter.SUITE_REPORTER_SOURCE.equals(summary.getSource())) {
                File summaryFile = null;
                try {
                    summaryFile = FileUtil.createTempFile((String)"summary", (String)".txt");
                    FileUtil.writeToFile((String)summary.getSummary().getString(), (File)summaryFile);
                    FileInputStreamSource stream = new FileInputStreamSource(summaryFile);
                    try {
                        this.testLog("summary", LogDataType.TEXT, (InputStreamSource)stream);
                        continue;
                    }
                    finally {
                        stream.close();
                        continue;
                    }
                }
                catch (IOException e) {
                    LogUtil.CLog.e((Throwable)e);
                    continue;
                }
                finally {
                    FileUtil.deleteFile((File)summaryFile);
                    continue;
                }
            }
            if (this.mReferenceUrl != null || summary.getSummary().getString() == null) continue;
            this.mReferenceUrl = summary.getSummary().getString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationEnded(long elapsedTime) {
        if (this.isShardResultReporter()) {
            this.mMasterResultReporter.invocationEnded(elapsedTime);
            return;
        }
        ResultReporter resultReporter = this;
        synchronized (resultReporter) {
            if (++this.invocationEndedCount < this.mMasterBuildInfos.size()) {
                return;
            }
            this.mElapsedTime = elapsedTime;
            this.finalizeResults();
            this.mFinalized.countDown();
        }
    }

    protected boolean shouldSkipReportCreation() {
        return false;
    }

    private void finalizeResults() {
        if (this.mFingerprintFailure) {
            LogUtil.CLog.w((String)"Failed the fingerprint check. Skip result reporting.");
            return;
        }
        for (String string : this.mMasterDeviceSerials) {
            this.mResult.addDeviceSerial(string);
        }
        this.addDeviceBuildInfoToResult();
        HashSet allExpectedModules = new HashSet();
        for (IBuildInfo buildInfo : this.mMasterBuildInfos) {
            for (Map.Entry entry : buildInfo.getBuildAttributes().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.equals("MODULE_IDS") || value.length() <= 0) continue;
                Collections.addAll(allExpectedModules, value.split(","));
            }
        }
        for (String moduleId : allExpectedModules) {
            this.mResult.getOrCreateModule(moduleId);
        }
        String string = String.format("%d of %d", this.mResult.getModuleCompleteCount(), this.mResult.getModules().size());
        if (this.shouldSkipReportCreation()) {
            return;
        }
        Collection runHistories = ((InvocationResult)this.mResult).getRunHistories();
        String runHistoryJSON = (String)this.mResult.getInvocationInfo().get(RUN_HISTORY_KEY);
        Gson gson = new Gson();
        if (runHistoryJSON != null) {
            InvocationResult.RunHistory[] runHistoryArray = (InvocationResult.RunHistory[])gson.fromJson(runHistoryJSON, InvocationResult.RunHistory[].class);
            Collections.addAll(runHistories, runHistoryArray);
        }
        InvocationResult.RunHistory newRun = new InvocationResult.RunHistory();
        newRun.startTime = this.mResult.getStartTime();
        newRun.endTime = newRun.startTime + this.mElapsedTime;
        runHistories.add(newRun);
        this.mResult.addInvocationInfo(RUN_HISTORY_KEY, gson.toJson((Object)runHistories));
        try {
            this.copyDynamicConfigFiles();
            ResultReporter.copyFormattingFiles(this.mResultDir, this.mBuildHelper.getSuiteName());
            File resultFile = this.generateResultXmlFile();
            if (this.mRetrySessionId != null) {
                ResultReporter.copyRetryFiles(ResultHandler.getResultDirectory((File)this.mBuildHelper.getResultsDir(), (Integer)this.mRetrySessionId), this.mResultDir);
            }
            File failureReport = null;
            if (this.mIncludeHtml) {
                failureReport = ResultHandler.createFailureReport((File)resultFile);
            }
            File zippedResults = ResultReporter.zipResults(this.mResultDir);
            if (!this.mIncludeHtml) {
                failureReport = ResultHandler.createFailureReport((File)resultFile);
            }
            if (failureReport != null && failureReport.exists()) {
                ResultReporter.info("Test Result: %s", failureReport.getCanonicalPath());
            } else {
                ResultReporter.info("Test Result: %s", resultFile.getCanonicalPath());
            }
            ResultReporter.info("Test Logs: %s", this.mLogDir.getCanonicalPath());
            ResultReporter.debug("Full Result: %s", zippedResults.getCanonicalPath());
            Path latestLink = this.createLatestLinkDirectory(this.mResultDir.toPath());
            if (latestLink != null) {
                ResultReporter.info("Latest results link: " + latestLink.toAbsolutePath(), new Object[0]);
            }
            if ((latestLink = this.createLatestLinkDirectory(this.mLogDir.toPath())) != null) {
                ResultReporter.info("Latest logs link: " + latestLink.toAbsolutePath(), new Object[0]);
            }
            this.saveLog(resultFile, zippedResults);
            this.uploadResult(resultFile);
        }
        catch (IOException | XmlPullParserException e) {
            LogUtil.CLog.e((String)"[%s] Exception while saving result XML.", (Object[])new Object[]{this.mDeviceSerial});
            LogUtil.CLog.e((Throwable)e);
        }
        ResultReporter.info("Invocation finished in %s. PASSED: %d, FAILED: %d, MODULES: %s", TimeUtil.formatElapsedTime((long)this.mElapsedTime), this.mResult.countResults(TestStatus.PASS), this.mResult.countResults(TestStatus.FAIL), string);
    }

    private Path createLatestLinkDirectory(Path directory) {
        Path link = null;
        Path parent = directory.getParent();
        if (parent != null) {
            link = parent.resolve(LATEST_LINK_NAME);
            try {
                Files.deleteIfExists(link);
                Files.createSymbolicLink(link, directory, new FileAttribute[0]);
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)"Exception while attempting to create 'latest' link to: [%s]", (Object[])new Object[]{directory});
                LogUtil.CLog.e((Throwable)ioe);
                return null;
            }
            catch (UnsupportedOperationException uoe) {
                LogUtil.CLog.e((String)"Failed to create 'latest' symbolic link - unsupported operation");
                return null;
            }
        }
        return link;
    }

    public void invocationFailed(Throwable cause) {
        ResultReporter.warn("Invocation failed: %s", cause);
        InvocationFailureHandler.setFailed(this.mBuildHelper, cause);
        if (cause instanceof FingerprintComparisonException) {
            this.mFingerprintFailure = true;
        }
    }

    public void testLog(String name, LogDataType type, InputStreamSource stream) {
        if (this.isShardResultReporter()) {
            this.mMasterResultReporter.testLog(name, type, stream);
            return;
        }
        if (name.endsWith(".deviceinfo.json")) {
            this.testLogDeviceInfo(name, stream);
        } else {
            try {
                File logFile = null;
                if (this.mCompressLogs) {
                    try (InputStream inputStream = stream.createInputStream();){
                        logFile = this.mTestLogSaver.saveAndGZipLogData(name, type, inputStream);
                    }
                }
                try (InputStream inputStream = stream.createInputStream();){
                    logFile = this.mTestLogSaver.saveLogData(name, type, inputStream);
                }
                ResultReporter.debug("Saved logs for %s in %s", name, logFile.getAbsolutePath());
            }
            catch (IOException e) {
                ResultReporter.warn("Failed to write log for %s", name);
                LogUtil.CLog.e((Throwable)e);
            }
        }
    }

    private void testLogDeviceInfo(String name, InputStreamSource stream) {
        try {
            File ediDir = new File(this.mResultDir, "device-info-files");
            ediDir.mkdirs();
            File ediFile = new File(ediDir, name);
            if (!ediFile.exists()) {
                FileUtil.writeToFile((InputStream)stream.createInputStream(), (File)ediFile);
            }
        }
        catch (IOException e) {
            ResultReporter.warn("Failed to write device info %s to result", name);
            LogUtil.CLog.e((Throwable)e);
        }
    }

    public void testLogSaved(String dataName, LogDataType dataType, InputStreamSource dataStream, LogFile logFile) {
        if (this.mIncludeTestLogTags && this.mCurrentResult != null && dataName.startsWith(this.mCurrentResult.getFullName())) {
            if (dataType == LogDataType.BUGREPORT) {
                this.mCurrentResult.setBugReport(logFile.getUrl());
            } else if (dataType == LogDataType.LOGCAT) {
                this.mCurrentResult.setLog(logFile.getUrl());
            } else if (dataType == LogDataType.PNG) {
                this.mCurrentResult.setScreenshot(logFile.getUrl());
            }
        }
    }

    public void setLogSaver(ILogSaver saver) {
        this.mLogSaver = saver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog(File resultFile, File zippedResults) throws IOException {
        if (!this.mUseLogSaver) {
            return;
        }
        FileInputStream fis = null;
        LogFile logFile = null;
        try {
            fis = new FileInputStream(resultFile);
            logFile = this.mLogSaver.saveLogData("log-result", LogDataType.XML, (InputStream)fis);
            ResultReporter.debug("Result XML URL: %s", logFile.getUrl());
            this.logReportFiles(this.mConfiguration, resultFile, resultFile.getName(), LogDataType.XML);
        }
        catch (IOException ioe) {
            try {
                LogUtil.CLog.e((String)"[%s] error saving XML with log saver", (Object[])new Object[]{this.mDeviceSerial});
                LogUtil.CLog.e((Throwable)ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.close(fis);
                throw throwable;
            }
            StreamUtil.close((Closeable)fis);
        }
        StreamUtil.close((Closeable)fis);
        if (zippedResults != null) {
            FileInputStream zipResultStream = null;
            try {
                zipResultStream = new FileInputStream(zippedResults);
                logFile = this.mLogSaver.saveLogData("results", LogDataType.ZIP, (InputStream)zipResultStream);
                ResultReporter.debug("Result zip URL: %s", logFile.getUrl());
                this.logReportFiles(this.mConfiguration, zippedResults, "results", LogDataType.ZIP);
            }
            catch (Throwable throwable) {
                StreamUtil.close(zipResultStream);
                throw throwable;
            }
            StreamUtil.close((Closeable)zipResultStream);
        }
    }

    private String getLogUrl() {
        if (!this.mUseLogSaver || this.mLogSaver == null) {
            return null;
        }
        return this.mLogSaver.getLogReportDir().getUrl();
    }

    public IShardableListener clone() {
        ResultReporter clone = new ResultReporter(this);
        OptionCopier.copyOptionsNoThrow((Object)this, (Object)clone);
        return clone;
    }

    protected File generateResultXmlFile() throws IOException, XmlPullParserException {
        return ResultHandler.writeResults((String)this.mBuildHelper.getSuiteName(), (String)this.mBuildHelper.getSuiteVersion(), (String)this.getSuitePlan(this.mBuildHelper), (String)this.mBuildHelper.getSuiteBuild(), (IInvocationResult)this.mResult, (File)this.mResultDir, (long)this.mResult.getStartTime(), (long)(this.mElapsedTime + this.mResult.getStartTime()), (String)this.mReferenceUrl, (String)this.getLogUrl(), (String)this.mBuildHelper.getCommandLineArgs(), this.mResultAttributes);
    }

    protected void addDeviceBuildInfoToResult() {
        Map<String, String> buildProperties = this.mapBuildInfo();
        ResultReporter.addBuildInfoToResult(buildProperties, this.mResult);
    }

    protected void addDeviceBuildInfoToResult(String buildFingerprintOverride, String manufactureOverride, String modelOverride) {
        Map<String, String> buildProperties = this.mapBuildInfo();
        String fingerprintPrefix = buildFingerprintOverride.split(":")[0];
        String fingerprintTail = buildFingerprintOverride.split(":")[1];
        String buildIdOverride = fingerprintTail.split("/")[1];
        buildProperties.put(BUILD_ID, buildIdOverride);
        String brandOverride = fingerprintPrefix.split("/")[0];
        buildProperties.put(BUILD_BRAND, brandOverride);
        String deviceOverride = fingerprintPrefix.split("/")[2];
        buildProperties.put(BUILD_DEVICE, deviceOverride);
        String productOverride = fingerprintPrefix.split("/")[1];
        buildProperties.put(BUILD_PRODUCT, productOverride);
        String versionOverride = fingerprintTail.split("/")[0];
        buildProperties.put(BUILD_VERSION_RELEASE, versionOverride);
        buildProperties.put(BUILD_FINGERPRINT, buildFingerprintOverride);
        buildProperties.put(BUILD_MANUFACTURER, manufactureOverride);
        buildProperties.put(BUILD_MODEL, modelOverride);
        ResultReporter.addBuildInfoToResult(buildProperties, this.mResult);
        this.mResult.setBuildFingerprint(buildFingerprintOverride);
    }

    protected Map<String, String> mapBuildInfo() {
        HashMap<String, String> buildProperties = new HashMap<String, String>();
        for (IBuildInfo buildInfo : this.mMasterBuildInfos) {
            for (Map.Entry entry : buildInfo.getBuildAttributes().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!key.startsWith(BUILD_INFO)) continue;
                buildProperties.put(key.substring(CTS_PREFIX.length()), value);
            }
        }
        return buildProperties;
    }

    protected static void addBuildInfoToResult(Map<String, String> buildProperties, IInvocationResult invocationResult) {
        buildProperties.entrySet().stream().forEach(entry -> invocationResult.addInvocationInfo((String)entry.getKey(), (String)entry.getValue()));
    }

    protected String getSuitePlan(CompatibilityBuildHelper mBuildHelper) {
        return mBuildHelper.getSuitePlan();
    }

    private boolean isShardResultReporter() {
        return this.mMasterResultReporter != null;
    }

    private void uploadResult(File resultFile) {
        if (this.mResultServer != null && !this.mResultServer.trim().isEmpty() && !this.mDisableResultPosting) {
            try {
                ResultReporter.debug("Result Server: %d", this.mUploader.uploadResult(resultFile, this.mReferenceUrl));
            }
            catch (IOException ioe) {
                LogUtil.CLog.e((String)"[%s] IOException while uploading result.", (Object[])new Object[]{this.mDeviceSerial});
                LogUtil.CLog.e((Throwable)ioe);
            }
        }
    }

    private boolean canMarkDone(String args) {
        if (this.mRetrySessionId == null) {
            return true;
        }
        return !RetryType.FAILED.equals((Object)this.mRetryType) && !RetryType.CUSTOM.equals((Object)this.mRetryType) && !args.contains("include-filter") && !args.contains("exclude-filter") && !args.contains("subplan") && !args.matches(String.format(".* (-%s|--%s) .*", Character.valueOf('t'), "test"));
    }

    static void copyFormattingFiles(File resultsDir, String suiteName) {
        for (String resultFileName : ResultHandler.RESULT_RESOURCES) {
            InputStream configStream = ResultHandler.class.getResourceAsStream(String.format("/report/%s-%s", suiteName, resultFileName));
            if (configStream == null) {
                configStream = ResultHandler.class.getResourceAsStream(String.format("/report/%s", resultFileName));
            }
            if (configStream != null) {
                File resultFile = new File(resultsDir, resultFileName);
                try {
                    FileUtil.writeToFile((InputStream)configStream, (File)resultFile);
                }
                catch (IOException e) {
                    ResultReporter.warn("Failed to write %s to file", resultFileName);
                }
                continue;
            }
            ResultReporter.warn("Failed to load %s from jar", resultFileName);
        }
    }

    private void copyDynamicConfigFiles() {
        File configDir = new File(this.mResultDir, "config");
        if (!configDir.mkdir()) {
            ResultReporter.warn("Failed to make dynamic config directory \"%s\" in the result", configDir.getAbsolutePath());
        }
        HashSet<String> uniqueModules = new HashSet<String>();
        for (IBuildInfo buildInfo : this.mMasterBuildInfos) {
            CompatibilityBuildHelper helper = new CompatibilityBuildHelper(buildInfo);
            Map<String, File> dcFiles = helper.getDynamicConfigFiles();
            for (String moduleName : dcFiles.keySet()) {
                File srcFile = dcFiles.get(moduleName);
                if (!uniqueModules.contains(moduleName)) {
                    File destFile = new File(configDir, moduleName + ".dynamic");
                    try {
                        FileUtil.copyFile((File)srcFile, (File)destFile);
                        uniqueModules.add(moduleName);
                    }
                    catch (IOException e) {
                        ResultReporter.warn("Failure when copying config file \"%s\" to \"%s\" for module %s", srcFile.getAbsolutePath(), destFile.getAbsolutePath(), moduleName);
                        LogUtil.CLog.e((Throwable)e);
                    }
                }
                FileUtil.deleteFile((File)srcFile);
            }
        }
    }

    static void copyRetryFiles(File oldDir, File newDir) {
        File[] oldChildren;
        for (File oldChild : oldChildren = oldDir.listFiles()) {
            if (NOT_RETRY_FILES.contains(oldChild.getName())) continue;
            File newChild = new File(newDir, oldChild.getName());
            if (!newChild.exists()) {
                try {
                    if (oldChild.isDirectory()) {
                        FileUtil.recursiveCopy((File)oldChild, (File)newChild);
                        continue;
                    }
                    FileUtil.copyFile((File)oldChild, (File)newChild);
                }
                catch (IOException e) {
                    ResultReporter.warn("Failed to copy file \"%s\" from previous session", oldChild.getName());
                }
                continue;
            }
            if (!oldChild.isDirectory() || !newChild.isDirectory()) continue;
            ResultReporter.copyRetryFiles(oldChild, newChild);
        }
    }

    private static File zipResults(File resultsDir) {
        File zipResultFile = null;
        try {
            zipResultFile = new File(resultsDir.getParent(), String.format("%s.zip", resultsDir.getName()));
            ZipUtil.createZip((File)resultsDir, (File)zipResultFile);
        }
        catch (IOException e) {
            ResultReporter.warn("Failed to create zip for %s", resultsDir.getName());
        }
        return zipResultFile;
    }

    private static void info(String format, Object ... args) {
        ResultReporter.log(Log.LogLevel.INFO, format, args);
    }

    private static void debug(String format, Object ... args) {
        ResultReporter.log(Log.LogLevel.DEBUG, format, args);
    }

    private static void warn(String format, Object ... args) {
        ResultReporter.log(Log.LogLevel.WARN, format, args);
    }

    private static void log(Log.LogLevel level, String format, Object ... args) {
        LogUtil.CLog.logAndDisplay((Log.LogLevel)level, (String)format, (Object[])args);
    }

    @VisibleForTesting
    public IInvocationResult getResult() {
        return this.mResult;
    }

    @VisibleForTesting
    public boolean waitForFinalized(long timeout, TimeUnit unit) throws InterruptedException {
        return this.mFinalized.await(timeout, unit);
    }

    private static String sanitizeXmlContent(String s) {
        return XmlEscapers.xmlContentEscaper().escape(s);
    }

    private void logReportFiles(IConfiguration configuration, File resultFile, String dataName, LogDataType type) {
        if (configuration == null) {
            return;
        }
        List listeners = configuration.getTestInvocationListeners();
        try (FileInputStreamSource source = new FileInputStreamSource(resultFile);){
            for (ITestInvocationListener listener : listeners) {
                if (listener.equals(this)) continue;
                listener.testLog(dataName, type, (InputStreamSource)source);
            }
        }
    }
}

