/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.result.IModuleListener;
import com.android.compatibility.common.tradefed.testtype.IModuleDef;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.util.HashMap;
import java.util.Map;

public class ModuleListener
implements IModuleListener {
    private IModuleDef mModule;
    private ITestInvocationListener mListener;

    public ModuleListener(IModuleDef module, ITestInvocationListener listener) {
        this.mModule = module;
        this.mListener = listener;
    }

    public void invocationStarted(IInvocationContext context) {
        LogUtil.CLog.d((String)"ModuleListener.invocationStarted(%s)", (Object[])new Object[]{context.getBuildInfos()});
        this.mListener.invocationStarted(context);
    }

    public void testRunStarted(String name, int numTests) {
        LogUtil.CLog.d((String)"ModuleListener.testRunStarted(%s, %d)", (Object[])new Object[]{name, numTests});
        this.mListener.testRunStarted(this.mModule.getId(), numTests);
    }

    public void testStarted(TestDescription test) {
        LogUtil.CLog.d((String)"ModuleListener.testStarted(%s)", (Object[])new Object[]{test.toString()});
        this.mListener.testStarted(test);
    }

    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> metrics) {
        LogUtil.CLog.d((String)"ModuleListener.testEnded(%s, %s)", (Object[])new Object[]{test.toString(), metrics.toString()});
        this.mListener.testEnded(test, metrics);
    }

    public void testIgnored(TestDescription test) {
        LogUtil.CLog.d((String)"ModuleListener.testIgnored(%s)", (Object[])new Object[]{test.toString()});
        this.mListener.testIgnored(test);
    }

    public void testFailed(TestDescription test, String trace) {
        LogUtil.CLog.d((String)"ModuleListener.testFailed(%s, %s)", (Object[])new Object[]{test.toString(), trace});
        this.mListener.testFailed(test, trace);
    }

    public void testAssumptionFailure(TestDescription test, String trace) {
        LogUtil.CLog.d((String)"ModuleListener.testAssumptionFailure(%s, %s)", (Object[])new Object[]{test.toString(), trace});
        this.mListener.testAssumptionFailure(test, trace);
    }

    public void testRunStopped(long elapsedTime) {
        LogUtil.CLog.d((String)"ModuleListener.testRunStopped(%d)", (Object[])new Object[]{elapsedTime});
        this.mListener.testRunStopped(elapsedTime);
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> metrics) {
        LogUtil.CLog.d((String)"ModuleListener.testRunEnded(%d, %s)", (Object[])new Object[]{elapsedTime, metrics.toString()});
        this.mListener.testRunEnded(elapsedTime, metrics);
    }

    public void testRunEnded(long elapsedTime, Map<String, String> metrics) {
        this.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(metrics));
    }

    public void testRunFailed(String errorMessage) {
        LogUtil.CLog.d((String)"ModuleListener.testRunFailed(%s)", (Object[])new Object[]{errorMessage});
        this.mListener.testRunFailed(errorMessage);
    }

    public TestSummary getSummary() {
        return this.mListener.getSummary();
    }

    public void invocationEnded(long elapsedTime) {
        LogUtil.CLog.d((String)"ModuleListener.invocationEnded(%d)", (Object[])new Object[]{elapsedTime});
        this.mListener.invocationEnded(elapsedTime);
    }

    public void invocationFailed(Throwable cause) {
        LogUtil.CLog.d((String)"ModuleListener.invocationFailed(%s)", (Object[])new Object[]{cause.toString()});
        this.mListener.invocationFailed(cause);
    }

    public void testLog(String name, LogDataType type, InputStreamSource stream) {
        LogUtil.CLog.d((String)"ModuleListener.testLog(%s, %s, %s)", (Object[])new Object[]{name, type.toString(), stream.toString()});
        this.mListener.testLog(name, type, stream);
    }
}

