/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.json.stream.JsonWriter;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.config.OptionCopier;
import com.android.tradefed.invoker.IInvocationContext;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.metrics.proto.MetricMeasurement;
import com.android.tradefed.result.IShardableListener;
import com.android.tradefed.result.TestDescription;
import com.android.tradefed.util.proto.TfMetricProtoUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MetadataReporter
implements IShardableListener {
    @Option(name="include-failure-time", description="Include timing about tests that failed.")
    private boolean mIncludeFailures = false;
    @Option(name="min-test-duration", description="Ignore test durations less than this.", isTimeVal=true)
    private long mMinTestDuration = 2000L;
    private static final String METADATA_DIR = "metadata";
    private CompatibilityBuildHelper mBuildHelper;
    private File mMetadataDir;
    private long mStartTime;
    private String mCurrentModule;
    private boolean mTestFailed;
    private Collection<TestMetadata> mTestMetadata = new LinkedList<TestMetadata>();

    public IShardableListener clone() {
        MetadataReporter clone = new MetadataReporter();
        OptionCopier.copyOptionsNoThrow((Object)this, (Object)clone);
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invocationStarted(IInvocationContext context) {
        IBuildInfo buildInfo = (IBuildInfo)context.getBuildInfos().get(0);
        MetadataReporter metadataReporter = this;
        synchronized (metadataReporter) {
            if (this.mBuildHelper == null) {
                this.mBuildHelper = new CompatibilityBuildHelper(buildInfo);
                try {
                    this.mMetadataDir = new File(this.mBuildHelper.getResultDir(), METADATA_DIR);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("Metadata Directory was not created: " + this.mMetadataDir.getAbsolutePath());
                }
            }
        }
    }

    public void testRunStarted(String id, int numTests) {
        this.mCurrentModule = id;
    }

    public void testStarted(TestDescription test) {
        this.mStartTime = System.currentTimeMillis();
        this.mTestFailed = false;
    }

    public void testFailed(TestDescription test, String trace) {
        this.mTestFailed = true;
    }

    public void testIgnored(TestDescription test) {
        this.mTestFailed = true;
    }

    public void testAssumptionFailure(TestDescription test, String trace) {
        this.mTestFailed = true;
    }

    public void testEnded(TestDescription test, HashMap<String, MetricMeasurement.Metric> testMetrics) {
        long duration = System.currentTimeMillis() - this.mStartTime;
        if (this.mTestFailed && !this.mIncludeFailures) {
            return;
        }
        if (duration < this.mMinTestDuration) {
            return;
        }
        TestMetadata metadata = new TestMetadata();
        metadata.testId = MetadataReporter.buildTestId(test);
        metadata.seconds = duration / 1000L;
        this.mTestMetadata.add(metadata);
    }

    public void testRunEnded(long elapsedTime, Map<String, String> metrics) {
        this.testRunEnded(elapsedTime, TfMetricProtoUtil.upgradeConvert(metrics));
    }

    public void testRunEnded(long elapsedTime, HashMap<String, MetricMeasurement.Metric> metrics) {
        if (!this.mTestMetadata.isEmpty()) {
            MetadataReporter.tryWriteToFile(this.mBuildHelper, this.mCurrentModule, this.mMetadataDir, this.mTestMetadata);
        }
        this.mTestMetadata.clear();
    }

    private static String buildTestId(TestDescription test) {
        return String.format("%s.%s", test.getClassName(), test.getTestName());
    }

    private static void tryWriteToFile(CompatibilityBuildHelper compatibilityBuildHelper, String moduleName, File metadataDir, Collection<TestMetadata> metadatas) {
        metadataDir.mkdirs();
        String moduleFileName = moduleName + "." + System.currentTimeMillis() + ".json";
        File metadataFile = new File(metadataDir, moduleFileName);
        Map buildAttributes = compatibilityBuildHelper.getBuildInfo().getBuildAttributes();
        try (JsonWriter writer = new JsonWriter((Writer)new PrintWriter(metadataFile));){
            writer.beginObject();
            writer.name("fingerprint");
            writer.value((String)buildAttributes.get("cts:build_fingerprint"));
            writer.name("product");
            writer.value((String)buildAttributes.get("cts:build_product"));
            writer.name("build_id");
            writer.value((String)buildAttributes.get("cts:build_id"));
            writer.name("suite_version");
            writer.value(compatibilityBuildHelper.getSuiteVersion());
            writer.name("suite_name");
            writer.value(compatibilityBuildHelper.getSuiteName());
            writer.name("suite_build");
            writer.value(compatibilityBuildHelper.getSuiteBuild());
            writer.name("module_id");
            writer.value(moduleName);
            writer.name("test");
            writer.beginArray();
            for (TestMetadata metadata : metadatas) {
                writer.beginObject();
                writer.name("id");
                writer.value(metadata.testId);
                writer.name("sec");
                writer.value(metadata.seconds);
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"[%s] While saving metadata.", (Object[])new Object[]{metadataFile.getAbsolutePath()});
            LogUtil.CLog.e((Throwable)e);
        }
    }

    protected Collection<TestMetadata> getTestMetadata() {
        return Collections.unmodifiableCollection(this.mTestMetadata);
    }

    public static class TestMetadata {
        String testId;
        long seconds;
    }
}

