/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.result;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class InvocationFailureHandler {
    public static boolean hasFailed(CompatibilityBuildHelper buildHelper) {
        try {
            File f = buildHelper.getInvocationFailureFile();
            return f.exists() && f.length() != 0L;
        }
        catch (FileNotFoundException e) {
            LogUtil.CLog.e((String)"Could not find invocation failure file for session %s", (Object[])new Object[]{CompatibilityBuildHelper.getDirSuffix(buildHelper.getStartTime())});
            LogUtil.CLog.e((Throwable)e);
            return false;
        }
    }

    public static void setFailed(CompatibilityBuildHelper buildHelper, Throwable cause) {
        try {
            File f = buildHelper.getInvocationFailureFile();
            if (!f.exists()) {
                f.createNewFile();
            }
            FileUtil.writeToFile((String)cause.toString(), (File)f, (boolean)true);
        }
        catch (IOException e) {
            LogUtil.CLog.e((String)"Exception while writing invocation failure file.");
            LogUtil.CLog.e((Throwable)e);
        }
    }
}

