/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.tradefed.command;

import com.android.compatibility.common.tradefed.build.CompatibilityBuildHelper;
import com.android.compatibility.common.tradefed.build.CompatibilityBuildProvider;
import com.android.compatibility.common.tradefed.result.SubPlanHelper;
import com.android.compatibility.common.tradefed.result.suite.CertificationResultXml;
import com.android.compatibility.common.tradefed.testtype.ModuleRepo;
import com.android.compatibility.common.tradefed.testtype.suite.CompatibilityTestSuite;
import com.android.compatibility.common.util.ResultHandler;
import com.android.tradefed.build.BuildRetrievalError;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.command.Console;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationFactory;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.suite.SuiteResultHolder;
import com.android.tradefed.testtype.Abi;
import com.android.tradefed.testtype.IAbi;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.IRuntimeHintProvider;
import com.android.tradefed.testtype.suite.TestSuiteInfo;
import com.android.tradefed.testtype.suite.params.ModuleParameters;
import com.android.tradefed.util.AbiUtils;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.MultiMap;
import com.android.tradefed.util.Pair;
import com.android.tradefed.util.RegexTrie;
import com.android.tradefed.util.TableFormatter;
import com.android.tradefed.util.TimeUtil;
import com.android.tradefed.util.VersionParser;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompatibilityConsole
extends Console {
    private static final Set<String> MODULE_SPLIT_EXCLUSIONS = new HashSet<String>();
    private static final String ADD_PATTERN = "a(?:dd)?";
    private static final String LATEST_RESULT_DIR = "latest";
    private CompatibilityBuildHelper mBuildHelper;
    private IBuildInfo mBuildInfo;

    public void run() {
        String buildNumber = TestSuiteInfo.getInstance().getBuildNumber();
        String versionFile = VersionParser.fetchVersion();
        if (versionFile != null) {
            buildNumber = versionFile;
        }
        this.printLine(String.format("Android %s %s (%s)", TestSuiteInfo.getInstance().getFullName(), TestSuiteInfo.getInstance().getVersion(), buildNumber));
        this.printLine("Use \"help\" or \"help all\" to get more information on running commands.");
        super.run();
    }

    protected void setCustomCommands(RegexTrie<Runnable> trie, List<String> genericHelp, Map<String, String> commandHelp) {
        genericHelp.add("Enter 'help add'        for help with 'add subplan' commands");
        genericHelp.add("\t----- " + TestSuiteInfo.getInstance().getFullName() + " usage ----- ");
        genericHelp.add("Usage: run <plan> [--module <module name>] [ options ]");
        genericHelp.add("Example: run cts --module CtsGestureTestCases --bugreport-on-failure");
        genericHelp.add("");
        trie.put((Object)new Runnable(){

            @Override
            public void run() {
                CompatibilityConsole.this.listPlans();
            }
        }, new String[]{"l(?:ist)?", "p(?:lans)?"});
        trie.put((Object)new Runnable(){

            @Override
            public void run() {
                CompatibilityConsole.this.listModules(null);
            }
        }, new String[]{"l(?:ist)?", "m(?:odules)?"});
        trie.put((Object)new Console.ArgRunnable<Console.CaptureList>(){

            public void run(Console.CaptureList args) {
                String parameter = (String)((List)args.get(2)).get(0);
                CompatibilityConsole.this.listModules(parameter);
            }
        }, new String[]{"l(?:ist)?", "m(?:odules)?", "(.*)"});
        trie.put((Object)new Runnable(){

            @Override
            public void run() {
                CompatibilityConsole.this.listResults();
            }
        }, new String[]{"l(?:ist)?", "r(?:esults)?"});
        trie.put((Object)new Runnable(){

            @Override
            public void run() {
                CompatibilityConsole.this.listSubPlans();
            }
        }, new String[]{"l(?:ist)?", "s(?:ubplans)?"});
        trie.put((Object)new Console.ArgRunnable<Console.CaptureList>(){

            public void run(Console.CaptureList args) {
                String arg = (String)((List)args.get(2)).get(0);
                int shards = Integer.parseInt(arg);
                if (shards <= 1) {
                    CompatibilityConsole.this.printLine("number of shards should be more than 1");
                    return;
                }
                CompatibilityConsole.this.splitModules(shards);
            }
        }, new String[]{"split", "m(?:odules)?", "(\\d+)"});
        trie.put((Object)new Console.ArgRunnable<Console.CaptureList>(){

            public void run(Console.CaptureList args) {
                String[] flatArgs = new String[args.size() - 2];
                for (int i = 2; i < args.size(); ++i) {
                    flatArgs[i - 2] = (String)((List)args.get(i)).get(0);
                }
                CompatibilityConsole.this.addSubPlan(flatArgs);
            }
        }, new String[]{ADD_PATTERN, "s(?:ubplan)?", null});
        trie.put((Object)new Console.ArgRunnable<Console.CaptureList>(){

            public void run(Console.CaptureList args) {
                CompatibilityConsole.this.printLine("'add subplan' requires parameters, use 'help add' to get more details");
            }
        }, new String[]{ADD_PATTERN, "s(?:ubplan)?"});
        trie.put((Object)new Runnable(){

            @Override
            public void run() {
                CompatibilityConsole.this.printLine(String.format("Android %s %s (%s)", TestSuiteInfo.getInstance().getFullName(), TestSuiteInfo.getInstance().getVersion(), TestSuiteInfo.getInstance().getBuildNumber()));
            }
        }, new String[]{"version"});
        String listHelp = commandHelp.get("l(?:ist)?");
        if (listHelp == null) {
            listHelp = new String();
        }
        String combinedHelp = listHelp + LINE_SEPARATOR + "\t----- " + TestSuiteInfo.getInstance().getFullName() + " specific options ----- " + LINE_SEPARATOR + "\tp[lans]               List all plans available" + LINE_SEPARATOR + "\tm[odules]             List all modules available" + LINE_SEPARATOR + String.format("\tm[odules] [module parameter] List all modules matching the parameter. (available params: %s)", Arrays.asList(ModuleParameters.values())) + LINE_SEPARATOR + "\tr[esults]             List all results" + LINE_SEPARATOR;
        commandHelp.put("l(?:ist)?", combinedHelp);
        String runHelp = commandHelp.get("r(?:un)?");
        if (runHelp == null) {
            runHelp = new String();
        }
        String combinedRunHelp = runHelp + LINE_SEPARATOR + "\t----- " + TestSuiteInfo.getInstance().getFullName() + " specific options ----- " + LINE_SEPARATOR + "\t<plan> --module/-m <module>       Run a test module" + LINE_SEPARATOR + "\t<plan> --module/-m <module> --test/-t <test_name>    Run a specific test from the module. Test name can be <package>.<class>, <package>.<class>#<method> or <native_binary_name>" + LINE_SEPARATOR + "\t\tAvailable Options:" + LINE_SEPARATOR + "\t\t\t--serial/-s <device_id>: The device to run the test on" + LINE_SEPARATOR + "\t\t\t--abi/-a <abi>         : The ABI to run the test against" + LINE_SEPARATOR + "\t\t\t--logcat-on-failure    : Capture logcat when a test fails" + LINE_SEPARATOR + "\t\t\t--bugreport-on-failure : Capture a bugreport when a test fails" + LINE_SEPARATOR + "\t\t\t--screenshot-on-failure: Capture a screenshot when a test fails" + LINE_SEPARATOR + "\t\t\t--shard-count <shards>: Shards a run into the given number of independent chunks, to run on multiple devices in parallel." + LINE_SEPARATOR + "\t ----- In order to retry a previous run -----" + LINE_SEPARATOR + "\tretry --retry <session id to retry> [--retry-type <FAILED | NOT_EXECUTED>]" + LINE_SEPARATOR + "\t\tWithout --retry-type, retry will run both FAIL and NOT_EXECUTED tests" + LINE_SEPARATOR;
        commandHelp.put("r(?:un)?", combinedRunHelp);
        commandHelp.put(ADD_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tadd s[ubplan]: create a subplan from a previous session" + LINE_SEPARATOR + "\t\tAvailable Options:" + LINE_SEPARATOR + "\t\t\t--session <session_id>: The session used to create a subplan" + LINE_SEPARATOR + "\t\t\t--name/-n <subplan_name>: The name of the new subplan" + LINE_SEPARATOR + "\t\t\t--result-type <status>: Which results to include in the subplan. One of passed, failed, not_executed. Repeatable" + LINE_SEPARATOR, ADD_PATTERN));
    }

    protected String getConsolePrompt() {
        return String.format("%s-tf > ", TestSuiteInfo.getInstance().getName().toLowerCase());
    }

    private void listModules(String moduleParameter) {
        CompatibilityTestSuite test = new CompatibilityTestSuite(){

            public Set<IAbi> getAbis(ITestDevice device) throws DeviceNotAvailableException {
                Set abiStrings = this.getAbisForBuildTargetArch();
                LinkedHashSet<IAbi> abis = new LinkedHashSet<IAbi>();
                for (String abi : abiStrings) {
                    if (!AbiUtils.isAbiSupportedByCompatibility((String)abi)) continue;
                    abis.add((IAbi)new Abi(abi, AbiUtils.getBitness((String)abi)));
                }
                return abis;
            }
        };
        if (this.getBuild() != null) {
            test.setEnableParameterizedModules(true);
            test.setEnableOptionalParameterizedModules(true);
            if (moduleParameter != null) {
                test.setModuleParameter(ModuleParameters.valueOf((String)moduleParameter.toUpperCase()));
            }
            test.setBuild(this.getBuild());
            LinkedHashMap<String, IConfiguration> configs = test.loadTests();
            this.printLine(String.format("%s", Joiner.on((String)"\n").join(configs.keySet())));
        } else {
            this.printLine("Error fetching information about modules.");
        }
    }

    private void listPlans() {
        this.printLine("Available plans include:");
        ConfigurationFactory.getInstance().printHelp(System.out);
    }

    private void splitModules(int shards) {
        File[] files = null;
        try {
            files = this.getBuildHelper().getTestsDir().listFiles(new ModuleRepo.ConfigFilter());
        }
        catch (FileNotFoundException e) {
            this.printLine(e.getMessage());
            e.printStackTrace();
        }
        if (files != null && files.length > 0) {
            IConfigurationFactory configFactory = ConfigurationFactory.getInstance();
            ArrayList<Pair> moduleRuntime = new ArrayList<Pair>();
            for (File file : files) {
                IConfiguration config = null;
                String string = file.getName().split("\\.")[0];
                if (MODULE_SPLIT_EXCLUSIONS.contains(string)) continue;
                try {
                    config = configFactory.createConfigurationFromArgs(new String[]{file.getAbsolutePath()});
                }
                catch (ConfigurationException ce) {
                    this.printLine("Error loading config file: " + file.getAbsolutePath());
                    LogUtil.CLog.e((Throwable)ce);
                    continue;
                }
                long runtime = 0L;
                for (IRemoteTest test : config.getTests()) {
                    if (test instanceof IRuntimeHintProvider) {
                        runtime += ((IRuntimeHintProvider)test).getRuntimeHint();
                        continue;
                    }
                    LogUtil.CLog.w((String)"Using default 1m runtime estimation for test type %s", (Object[])new Object[]{test.getClass().getSimpleName()});
                    runtime += 60000L;
                }
                moduleRuntime.add(new Pair((Object)string, (Object)runtime));
            }
            Collections.sort(moduleRuntime, new Comparator<Pair<String, Long>>(){

                @Override
                public int compare(Pair<String, Long> o1, Pair<String, Long> o2) {
                    return ((Long)o2.second).compareTo((Long)o1.second);
                }
            });
            ArrayList splittedModules = new ArrayList();
            for (int i = 0; i < shards; ++i) {
                splittedModules.add(new ArrayList());
            }
            int shardIndex = 0;
            int increment = 1;
            long[] shardTimes = new long[shards];
            for (Pair pair : moduleRuntime) {
                ((List)splittedModules.get(shardIndex)).add(pair);
                int n = shardIndex;
                shardTimes[n] = shardTimes[n] + (Long)pair.second;
                if ((shardIndex += increment) == shards) {
                    increment = -1;
                    shardIndex = shards - 1;
                }
                if (shardIndex != -1) continue;
                increment = 1;
                shardIndex = 0;
            }
            shardIndex = 0;
            for (List list : splittedModules) {
                StringBuilder lineBuffer = new StringBuilder();
                lineBuffer.append(String.format("shard #%d (%s):", shardIndex, TimeUtil.formatElapsedTime((long)shardTimes[shardIndex])));
                Iterator itr = list.iterator();
                lineBuffer.append((String)((Pair)itr.next()).first);
                while (itr.hasNext()) {
                    lineBuffer.append(',');
                    lineBuffer.append((String)((Pair)itr.next()).first);
                }
                ++shardIndex;
                this.printLine(lineBuffer.toString());
            }
        } else {
            this.printLine("No modules found");
        }
    }

    private void listResults() {
        TableFormatter tableFormatter = new TableFormatter();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        List<File> resultDirs = null;
        LinkedHashMap<SuiteResultHolder, File> holders = new LinkedHashMap<SuiteResultHolder, File>();
        try {
            resultDirs = this.getResults(this.getBuildHelper().getResultsDir());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error while parsing results directory", e);
        }
        CertificationResultXml xmlParser = new CertificationResultXml();
        for (File resultDir : resultDirs) {
            if (LATEST_RESULT_DIR.equals(resultDir.getName())) continue;
            try {
                holders.put(xmlParser.parseResults(resultDir, true), resultDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (holders.isEmpty()) {
            this.printLine(String.format("No results found", new Object[0]));
            return;
        }
        int i = 0;
        for (SuiteResultHolder holder : holders.keySet()) {
            String moduleProgress = String.format("%d of %d", holder.completeModules, holder.totalModules);
            table.add(Arrays.asList(Integer.toString(i), Long.toString(holder.passedTests), Long.toString(holder.failedTests), moduleProgress, ((File)holders.get(holder)).getName(), (String)holder.context.getAttributes().get((Object)"suite_plan").get(0), Joiner.on((String)", ").join(holder.context.getShardsSerials().values()), this.printAttributes((MultiMap<String, String>)holder.context.getAttributes(), "build_id"), this.printAttributes((MultiMap<String, String>)holder.context.getAttributes(), "build_product")));
            ++i;
        }
        table.add(0, Arrays.asList("Session", "Pass", "Fail", "Modules Complete", "Result Directory", "Test Plan", "Device serial(s)", "Build ID", "Product"));
        tableFormatter.displayTable(table, new PrintWriter(System.out, true));
    }

    private String printAttributes(MultiMap<String, String> map, String key) {
        if (map.get((Object)key) == null) {
            return "unknown";
        }
        return (String)map.get((Object)key).get(0);
    }

    private List<File> getResults(File resultsDir) {
        return ResultHandler.getResultDirectories((File)resultsDir);
    }

    private void listSubPlans() {
        File[] files = null;
        try {
            files = this.getBuildHelper().getSubPlansDir().listFiles();
        }
        catch (FileNotFoundException e) {
            this.printLine(e.getMessage());
            e.printStackTrace();
        }
        if (files != null && files.length > 0) {
            ArrayList<String> subPlans = new ArrayList<String>();
            for (File subPlanFile : files) {
                subPlans.add(FileUtil.getBaseName((String)subPlanFile.getName()));
            }
            Collections.sort(subPlans);
            for (String subPlan : subPlans) {
                this.printLine(subPlan);
            }
        } else {
            this.printLine("No subplans found");
        }
    }

    private void addSubPlan(String[] flatArgs) {
        SubPlanHelper creator = new SubPlanHelper();
        try {
            ArgsOptionParser optionParser = new ArgsOptionParser(new Object[]{creator});
            optionParser.parse(Arrays.asList(flatArgs));
            creator.createAndSerializeSubPlan(this.getBuildHelper());
        }
        catch (ConfigurationException e) {
            this.printLine("Error: " + e.getMessage());
            this.printLine(ArgsOptionParser.getOptionHelp((boolean)false, (Object)creator));
        }
    }

    private CompatibilityBuildHelper getBuildHelper() {
        if (this.mBuildHelper == null) {
            IBuildInfo build = this.getBuild();
            if (build == null) {
                return null;
            }
            this.mBuildHelper = new CompatibilityBuildHelper(build);
        }
        return this.mBuildHelper;
    }

    private IBuildInfo getBuild() {
        if (this.mBuildInfo == null) {
            try {
                CompatibilityBuildProvider buildProvider = new CompatibilityBuildProvider();
                this.mBuildInfo = buildProvider.getBuild();
            }
            catch (BuildRetrievalError e) {
                e.printStackTrace();
            }
        }
        return this.mBuildInfo;
    }

    public static void main(String[] args) throws InterruptedException, ConfigurationException {
        CompatibilityConsole console = new CompatibilityConsole();
        Console.startConsole((Console)console, (String[])args);
    }

    static {
        MODULE_SPLIT_EXCLUSIONS.add("CtsDeqpTestCases");
    }
}

