/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.TestFilter;
import junit.framework.TestCase;

public class TestFilterTest
extends TestCase {
    private static final String NAME = "ModuleName";
    private static final String ABI = "mips64";
    private static final String TEST = "com.android.foobar.Blah#testAllTheThings";
    private static final String NAME_FILTER = String.format("%s", "ModuleName");
    private static final String ABI_NAME_FILTER = String.format("%s %s", "mips64", "ModuleName");
    private static final String NAME_TEST_FILTER = String.format("%s %s", "ModuleName", "com.android.foobar.Blah#testAllTheThings");
    private static final String FULL_FILTER = String.format("%s %s %s", "mips64", "ModuleName", "com.android.foobar.Blah#testAllTheThings");

    public void testParseNameFilter() {
        TestFilter filter = TestFilter.createFrom((String)NAME_FILTER);
        TestFilterTest.assertNull((String)"Incorrect abi", (Object)filter.getAbi());
        TestFilterTest.assertEquals((String)"Incorrect name", (String)NAME, (String)filter.getName());
        TestFilterTest.assertNull((String)"Incorrect test", (Object)filter.getTest());
    }

    public void testParseAbiNameFilter() {
        TestFilter filter = TestFilter.createFrom((String)ABI_NAME_FILTER);
        TestFilterTest.assertEquals((String)"Incorrect abi", (String)ABI, (String)filter.getAbi());
        TestFilterTest.assertEquals((String)"Incorrect name", (String)NAME, (String)filter.getName());
        TestFilterTest.assertNull((String)"Incorrect test", (Object)filter.getTest());
    }

    public void testParseNameTestFilter() {
        TestFilter filter = TestFilter.createFrom((String)NAME_TEST_FILTER);
        TestFilterTest.assertNull((String)"Incorrect abi", (Object)filter.getAbi());
        TestFilterTest.assertEquals((String)"Incorrect name", (String)NAME, (String)filter.getName());
        TestFilterTest.assertEquals((String)"Incorrect test", (String)TEST, (String)filter.getTest());
    }

    public void testParseFullFilter() {
        TestFilter filter = TestFilter.createFrom((String)FULL_FILTER);
        TestFilterTest.assertEquals((String)"Incorrect abi", (String)ABI, (String)filter.getAbi());
        TestFilterTest.assertEquals((String)"Incorrect name", (String)NAME, (String)filter.getName());
        TestFilterTest.assertEquals((String)"Incorrect test", (String)TEST, (String)filter.getTest());
    }

    public void testCreateNameFilter() {
        TestFilter filter = new TestFilter(null, NAME, null);
        TestFilterTest.assertEquals((String)"Incorrect filter", (String)NAME_FILTER, (String)filter.toString());
    }

    public void testCreateAbiNameFilter() {
        TestFilter filter = new TestFilter(ABI, NAME, null);
        TestFilterTest.assertEquals((String)"Incorrect filter", (String)ABI_NAME_FILTER, (String)filter.toString());
    }

    public void testCreateNameTestFilter() {
        TestFilter filter = new TestFilter(null, NAME, TEST);
        TestFilterTest.assertEquals((String)"Incorrect filter", (String)NAME_TEST_FILTER, (String)filter.toString());
    }

    public void testCreateFullFilter() {
        TestFilter filter = new TestFilter(ABI, NAME, TEST);
        TestFilterTest.assertEquals((String)"Incorrect filter", (String)FULL_FILTER, (String)filter.toString());
    }
}

