/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import com.android.compatibility.common.util.DynamicConfig;
import com.android.compatibility.common.util.DynamicConfigHandler;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class DynamicConfigHandlerTest
extends TestCase {
    private static final String LOCAL_CONFIG = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<dynamicConfig>\n    <entry key=\"test-config-1\">\n        <value>test config 1</value>\n    </entry>\n    <entry key=\"test-config-2\">\n        <value>test config 2</value>\n    </entry>\n    <entry key=\"override-config-2\">\n        <value>test config 3</value>\n    </entry>\n    <entry key=\"config-list\">\n        <value>config0</value>\n        <value>config1</value>\n        <value>config2</value>\n        <value>config3</value>\n        <value>config4</value>\n    </entry>\n    <entry key=\"override-config-list-2\">\n        <value>A</value>\n        <value>B</value>\n        <value>C</value>\n        <value>D</value>\n        <value>E</value>\n    </entry>\n</dynamicConfig>\n";
    private static final String OVERRIDE_JSON = "{\n  \"dynamicConfigEntries\": {\n    \"override-config-1\": {\n      \"configValues\": [\n        \"override-config-val-1\"\n      ]\n    },\n    \"override-config-2\": {\n      \"configValues\": [\n        \"override-config-val-2\"\n      ]\n    },\n    \"override-config-list-1\": {\n      \"configValues\": [\n        \"override-config-list-val-1-1\",\n        \"override-config-list-val-1-2\"\n      ]\n    },\n    \"override-config-list-2\": {\n      \"configValues\": [\n        \"override-config-list-val-2-1\"\n      ]\n    },\n    \"override-config-list-3\": {\n      \"configValues\": [\n      ]\n    }\n  }\n}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDynamicConfigHandler() throws Exception {
        String module = "test1";
        File localConfigFile = this.createFileFromStr(LOCAL_CONFIG, module);
        File mergedFile = null;
        try {
            mergedFile = DynamicConfigHandler.getMergedDynamicConfigFile((File)localConfigFile, (String)OVERRIDE_JSON, (String)module);
            Map configMap = DynamicConfig.createConfigMap((File)mergedFile);
            DynamicConfigHandlerTest.assertEquals((String)"override-config-val-1", (String)((String)((List)configMap.get("override-config-1")).get(0)));
            DynamicConfigHandlerTest.assertTrue((boolean)((List)configMap.get("override-config-list-1")).contains("override-config-list-val-1-1"));
            DynamicConfigHandlerTest.assertTrue((boolean)((List)configMap.get("override-config-list-1")).contains("override-config-list-val-1-2"));
            DynamicConfigHandlerTest.assertTrue((((List)configMap.get("override-config-list-3")).size() == 0 ? 1 : 0) != 0);
            DynamicConfigHandlerTest.assertEquals((String)"test config 1", (String)((String)((List)configMap.get("test-config-1")).get(0)));
            DynamicConfigHandlerTest.assertTrue((boolean)((List)configMap.get("config-list")).contains("config2"));
            DynamicConfigHandlerTest.assertEquals((String)"override-config-val-2", (String)((String)((List)configMap.get("override-config-2")).get(0)));
            DynamicConfigHandlerTest.assertEquals((int)1, (int)((List)configMap.get("override-config-list-2")).size());
            DynamicConfigHandlerTest.assertTrue((boolean)((List)configMap.get("override-config-list-2")).contains("override-config-list-val-2-1"));
        }
        finally {
            FileUtil.deleteFile((File)localConfigFile);
            FileUtil.recursiveDelete((File)mergedFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileFromStr(String configStr, String module) throws IOException {
        File file = File.createTempFile(module, "dynamic");
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            stream.write(configStr.getBytes());
            stream.flush();
        }
        catch (Throwable throwable) {
            StreamUtil.close(stream);
            throw throwable;
        }
        StreamUtil.close((Closeable)stream);
        return file;
    }
}

