#!/bin/bash

# CATBOX runner is supposed to pass in the device serial IDs
SCRIPT_DIR=$( cd -- "$( dirname -- "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )

function print_help() {
    echo -e "Usage: $(basename "$0") [OPTION]"
    echo -e "\nOptions:"
    echo -e "\t-n/--devicenum               \t\tNumber of devices allocated"
    echo -e "\t-h/--help                    \t\tPrint help information"
    echo -e "\t-u/--hu                      \t\tSerial of head unit"
    echo -e "\t-p/--phone1                  \t\tSerial of first companion device"
    echo -e "\t-e/--phone2                  \t\tSerial of second companion device"
    echo -e "\t-o/--phone3                  \t\tSerial of third companion device"
    echo -e "\t-t/--testcase                \t\tTestcase binary to run"
}

function_install_sl4a() {
    DEV=$1
    adb -s "${DEV}" install -d -r -g "${SCRIPT_DIR}/sl4a.apk"
}

while [[ $# -gt 0 ]]
do
    arg="$1"
    case $arg in
        -n|--devicenum)
            NUM_DEVICE="$2"
            shift; shift
            ;;
        -h|--help)
            print_help
            exit
            ;;
        -u|--hu)
            HU="$2"
            shift; shift
            ;;
        -p|--phone1)
            PHONE1="$2"
            shift
            ;;
        -e|--phone2)
            PHONE2="$2"
            shift; shift
            ;;
        -o|--phone3)
            PHONE3="$2"
            shift; shift
            ;;
        -t|--testcase)
            TEST_BIN="$2"
            shift; shift
            ;;
        *) # anything else
            echo "Unknown options"
            exit 1
            ;;
    esac
done

# reconfig testbed and run test
if [[ "$NUM_DEVICE" == "1" ]]
then
  sed -i "s/HU/$HU/" "$SCRIPT_DIR"/testbed1.yaml
  function_install_sl4a "${HU}"
  "$SCRIPT_DIR/${TEST_BIN}" -c "$SCRIPT_DIR"/testbed1.yaml
elif [[ "$NUM_DEVICE" == "2" ]]
then
  sed -i "s/HU/$HU/" "$SCRIPT_DIR"/testbed2.yaml
  sed -i "s/PHONE1/$PHONE1/" "$SCRIPT_DIR"/testbed2.yaml
  function_install_sl4a "${HU}"
  function_install_sl4a "${PHONE1}"
  "$SCRIPT_DIR/${TEST_BIN}" -c "$SCRIPT_DIR"/testbed2.yaml
elif [[ "$NUM_DEVICE" == "3" ]]
then
  sed -i "s/HU/$HU/" "$SCRIPT_DIR"/testbed3.yaml
  sed -i "s/PHONE1/$PHONE1/" "$SCRIPT_DIR"/testbed3.yaml
  sed -i "s/PHONE2/$PHONE2/" "$SCRIPT_DIR"/testbed3.yaml
  function_install_sl4a "${HU}"
  function_install_sl4a "${PHONE1}"
  function_install_sl4a "${PHONE2}"
  "$SCRIPT_DIR/${TEST_BIN}" -c "$SCRIPT_DIR"/testbed3.yaml
elif [[ "$NUM_DEVICE" == "4" ]]
then
  sed -i "s/HU/$HU/" "$SCRIPT_DIR"/testbed4.yaml
  sed -i "s/PHONE1/$PHONE1/" "$SCRIPT_DIR"/testbed4.yaml
  sed -i "s/PHONE2/$PHONE2/" "$SCRIPT_DIR"/testbed4.yaml
  sed -i "s/PHONE3/$PHONE3/" "$SCRIPT_DIR"/testbed4.yaml
  function_install_sl4a "${HU}"
  function_install_sl4a "${PHONE1}"
  function_install_sl4a "${PHONE2}"
  function_install_sl4a "${PHONE3}"
  "$SCRIPT_DIR/${TEST_BIN}" -c "$SCRIPT_DIR"/testbed4.yaml
else
  echo "argument wrong, please check your config!"
fi
