/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlSerializer;

public class TestScreenshotsMetadata
implements Serializable {
    private static final String SCREENSHOTS_TAG = "Screenshots";
    private static final String SCREENSHOT_TAG = "Screenshot";
    private static final String NAME_ATTR = "name";
    private static final String DESCRIPTION_ATTR = "description";
    private final String mTestName;
    private final Set<ScreenshotMetadata> mScreenshotMetadataSet;

    public TestScreenshotsMetadata(String testName, Set<ScreenshotMetadata> screenshots) {
        this.mTestName = testName;
        this.mScreenshotMetadataSet = screenshots;
    }

    public String getTestName() {
        return this.mTestName;
    }

    public Set<ScreenshotMetadata> getScreenshotMetadataSet() {
        return this.mScreenshotMetadataSet;
    }

    public String toString() {
        ArrayList<String> arr = new ArrayList<String>();
        for (ScreenshotMetadata e : this.mScreenshotMetadataSet) {
            arr.add(e.toString());
        }
        return String.join((CharSequence)", ", arr);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestScreenshotsMetadata)) {
            return false;
        }
        TestScreenshotsMetadata that = (TestScreenshotsMetadata)o;
        return Objects.equals(this.mTestName, that.mTestName) && Objects.equals(this.mScreenshotMetadataSet, that.mScreenshotMetadataSet);
    }

    public int hashCode() {
        return Objects.hash(this.mTestName, this.mScreenshotMetadataSet);
    }

    public static void serialize(XmlSerializer serializer, TestScreenshotsMetadata screenshotsMetadata) throws IOException {
        if (screenshotsMetadata == null) {
            throw new IllegalArgumentException("Test screenshots metadata was null");
        }
        serializer.startTag(null, SCREENSHOTS_TAG);
        for (ScreenshotMetadata screenshotMetadata : screenshotsMetadata.getScreenshotMetadataSet()) {
            serializer.startTag(null, SCREENSHOT_TAG);
            serializer.attribute(null, NAME_ATTR, String.valueOf(screenshotMetadata.getScreenshotName()));
            serializer.attribute(null, DESCRIPTION_ATTR, String.valueOf(screenshotMetadata.getDescription()));
            serializer.endTag(null, SCREENSHOT_TAG);
        }
        serializer.endTag(null, SCREENSHOTS_TAG);
    }

    public static class ScreenshotMetadata
    implements Serializable {
        String mScreenshotName;
        String mDescription;

        public void setDescription(String description) {
            this.mDescription = description;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public void setScreenshotName(String screenshotName) {
            this.mScreenshotName = screenshotName;
        }

        public String getScreenshotName() {
            return this.mScreenshotName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ScreenshotMetadata)) {
                return false;
            }
            ScreenshotMetadata that = (ScreenshotMetadata)o;
            return this.mScreenshotName.equals(that.mScreenshotName) && this.mDescription.equals(that.mDescription);
        }

        public int hashCode() {
            return Objects.hash(this.mScreenshotName, this.mDescription);
        }

        public String toString() {
            return "[" + this.mScreenshotName + ", " + this.mDescription + "]";
        }
    }
}

