/*
 * Decompiled with CFR 0.152.
 */
package com.android.compatibility.common.util;

import java.util.concurrent.Callable;
import org.junit.Assert;

public abstract class PollingCheck {
    public static final PollingCheckClock DEFAULT_CLOCK = new SystemClock();
    private static final long TIME_SLICE = 50L;

    public static boolean check(PollingCheckClock clock, long pollInterval, long timeout, Callable<Boolean> condition) throws Exception {
        long start = clock.currentTimeMillis();
        if (condition.call().booleanValue()) {
            return true;
        }
        while (clock.currentTimeMillis() - start < timeout) {
            clock.sleep(pollInterval);
            if (!condition.call().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean check(long timeout, Callable<Boolean> condition) throws Exception {
        return PollingCheck.check(DEFAULT_CLOCK, 50L, timeout, condition);
    }

    public static void check(PollingCheckClock clock, String message, long pollInterval, long timeout, Callable<Boolean> condition) throws Exception {
        if (!PollingCheck.check(clock, pollInterval, timeout, condition)) {
            Assert.fail((String)message);
        }
    }

    public static void check(String message, long timeout, Callable<Boolean> condition) throws Exception {
        PollingCheck.check(DEFAULT_CLOCK, message, 50L, timeout, condition);
    }

    public static void waitFor(PollingCheckClock clock, long pollInterval, long timeout, Callable<Boolean> condition) throws Exception {
        PollingCheck.check(clock, "Unexpected timeout waiting for condition", pollInterval, timeout, condition);
    }

    public static void waitFor(long timeout, Callable<Boolean> condition) throws Exception {
        PollingCheck.waitFor(DEFAULT_CLOCK, 50L, timeout, condition);
    }

    public static interface PollingCheckClock {
        public long currentTimeMillis();

        default public void sleep(long millis) throws InterruptedException {
            Thread.sleep(millis);
        }
    }

    private static class SystemClock
    implements PollingCheckClock {
        private SystemClock() {
        }

        @Override
        public long currentTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

